/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData PlanData}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.PlanDataField
 * PlanDataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.PlanDataLink PlanDataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#BILLING_CONTROL_CATEGORY
 * BILLING_CONTROL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#BILLING_CONTROL_CATEGORY_ID
 * BILLING_CONTROL_CATEGORY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#EMPLOYEE_NAME
 * EMPLOYEE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#WPNAME WPNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#PROJECT_ID
 * PROJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#RES_TYPE
 * RES_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#WORK_PACKAGE_ID
 * WORK_PACKAGE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#RES_TYPE_TEXT
 * RES_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#RESOURCE_ID
 * RESOURCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#RESOURCE_TEXT
 * RESOURCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#UOM UOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#VERSION VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#PERIOD PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#FC_YEAR FC_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#EMPLOYEE
 * EMPLOYEE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#CONFIRMED
 * CONFIRMED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#WORKITEM_ID
 * WORKITEM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#WORKITEM_NAME
 * WORKITEM_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#EFFORT EFFORT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#DELVRY_SERV_ORG
 * DELVRY_SERV_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#DELVRY_SERV_ORG_T
 * DELVRY_SERV_ORG_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData#TO_STAFF_DATA
 * TO_STAFF_DATA}</li>
 * </ul>
 *
 */
public interface PlanDataSelectable extends EntitySelectable<PlanData>
{

}
