/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole ProjectRole}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.ProjectRoleField
 * ProjectRoleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.ProjectRoleLink
 * ProjectRoleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole#PROJECT_ID
 * PROJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole#PROJECT_ROLE_ID
 * PROJECT_ROLE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole#PROJECT_ROLE_NAME
 * PROJECT_ROLE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole#BUSINESS_PARTNER_ID
 * BUSINESS_PARTNER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole#BUSINESS_PARTNER_NAME
 * BUSINESS_PARTNER_NAME}</li>
 * </ul>
 *
 */
public interface ProjectRoleSelectable extends EntitySelectable<ProjectRole>
{

}
