/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData StaffingData}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.StaffingDataField
 * StaffingDataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.StaffingDataLink
 * StaffingDataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#PROJECT_ID
 * PROJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#BILLING_CONTROL_CATEGORY
 * BILLING_CONTROL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#WORK_PACKAGE_ID
 * WORK_PACKAGE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#W_PNAME
 * W_PNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#RES_TYPE
 * RES_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#RES_TYPE_TEXT
 * RES_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#RESOURCE_ID
 * RESOURCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#RESOURCE_TEXT
 * RESOURCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#UOM UOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#VERSION
 * VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#PERIOD
 * PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#FC_YEAR
 * FC_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#STAFFED_EMPLOYEE
 * STAFFED_EMPLOYEE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#CONFIRMED
 * CONFIRMED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#WORKITEM_ID
 * WORKITEM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#WORKITEM_NAME
 * WORKITEM_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#STAFFED_EFFORT
 * STAFFED_EFFORT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#STAFFED_EMP_DELVRY_SERV_ORG
 * STAFFED_EMP_DELVRY_SERV_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#STAFFED_EMP_DELVRY_SERV_ORG_T
 * STAFFED_EMP_DELVRY_SERV_ORG_T}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData#STAFFED_EMPLOYEE_NAME
 * STAFFED_EMPLOYEE_NAME}</li>
 * </ul>
 *
 */
public interface StaffingDataSelectable extends EntitySelectable<StaffingData>
{

}
