/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem WorkItem}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.WorkItemField
 * WorkItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.WorkItemLink WorkItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem#WORKITEM
 * WORKITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem#WORKPACKAGE_ID
 * WORKPACKAGE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem#WORKITEMNAME
 * WORKITEMNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem#WORKITEMISINACTIVE
 * WORKITEMISINACTIVE}</li>
 * </ul>
 *
 */
public interface WorkItemSelectable extends EntitySelectable<WorkItem>
{

}
