/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage Workpackage}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.WorkpackageField
 * WorkpackageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.WorkpackageLink
 * WorkpackageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#WORK_PACKAGE_UNIT_TEXT
 * WORK_PACKAGE_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#WORK_PACKAGE_TYPE
 * WORK_PACKAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#UNIT_OF_MEASURE
 * UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#CHANGED_ON
 * CHANGED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#PROJECT_ID
 * PROJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#CHANGED_BY
 * CHANGED_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#WORK_PACKAGE_ID
 * WORK_PACKAGE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#WORK_PACKAGE_NAME
 * WORK_PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#WP_START_DATE
 * WP_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#WP_END_DATE
 * WP_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#PROJECT_NAME
 * PROJECT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#TO_WORK_PACKAGE_FUNCTION_SET
 * TO_WORK_PACKAGE_FUNCTION_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#TO_WORK_ITEM_SET
 * TO_WORK_ITEM_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage#TO_PLAN_DATA_SET
 * TO_PLAN_DATA_SET}</li>
 * </ul>
 *
 */
public interface WorkpackageSelectable extends EntitySelectable<Workpackage>
{

}
