/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.field.PublicSectorCommitmentActualItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.selectable.PublicSectorCommitmentActualItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Commitment and Actual Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PublicSectorCommitmentActualItem_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PublicSectorCommitmentActualItem extends VdmEntity<PublicSectorCommitmentActualItem>
{

    /**
     * Selector for all available fields of PublicSectorCommitmentActualItem.
     *
     */
    public final static PublicSectorCommitmentActualItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger in General Ledger Accounting
     */
    @Key
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> LEDGER =
        new PublicSectorCommitmentActualItemField<String>("Ledger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @return Source Ledger
     */
    @Key
    @SerializedName( "SourceLedger" )
    @JsonProperty( "SourceLedger" )
    @Nullable
    @ODataField( odataName = "SourceLedger" )
    private String sourceLedger;
    /**
     * Use with available fluent helpers to apply the <b>SourceLedger</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> SOURCE_LEDGER =
        new PublicSectorCommitmentActualItemField<String>("SourceLedger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> COMPANY_CODE =
        new PublicSectorCommitmentActualItemField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FISCAL_YEAR =
        new PublicSectorCommitmentActualItemField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Journal Entry
     */
    @Key
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> ACCOUNTING_DOCUMENT =
        new PublicSectorCommitmentActualItemField<String>("AccountingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @return Ledger Journal Entry Item
     */
    @Key
    @SerializedName( "LedgerGLLineItem" )
    @JsonProperty( "LedgerGLLineItem" )
    @Nullable
    @ODataField( odataName = "LedgerGLLineItem" )
    private String ledgerGLLineItem;
    /**
     * Use with available fluent helpers to apply the <b>LedgerGLLineItem</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> LEDGER_GL_LINE_ITEM =
        new PublicSectorCommitmentActualItemField<String>("LedgerGLLineItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCommitment</b>
     * </p>
     *
     * @return Indicator: Is Commitment
     */
    @SerializedName( "IsCommitment" )
    @JsonProperty( "IsCommitment" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCommitment" )
    private Boolean isCommitment;
    /**
     * Use with available fluent helpers to apply the <b>IsCommitment</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<Boolean> IS_COMMITMENT =
        new PublicSectorCommitmentActualItemField<Boolean>("IsCommitment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> GL_ACCOUNT =
        new PublicSectorCommitmentActualItemField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> COST_CENTER =
        new PublicSectorCommitmentActualItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PROFIT_CENTER =
        new PublicSectorCommitmentActualItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FUNCTIONAL_AREA =
        new PublicSectorCommitmentActualItemField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> SEGMENT =
        new PublicSectorCommitmentActualItemField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> TRANSACTION_CURRENCY =
        new PublicSectorCommitmentActualItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnCmtmtAmtInTransCrcy</b>
     * </p>
     *
     * @return Commitment Expense Amount in Transaction Currency
     */
    @SerializedName( "PubSecExpnCmtmtAmtInTransCrcy" )
    @JsonProperty( "PubSecExpnCmtmtAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecExpnCmtmtAmtInTransCrcy" )
    private BigDecimal pubSecExpnCmtmtAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecExpnCmtmtAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_EXPN_CMTMT_AMT_IN_TRANS_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecExpnCmtmtAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnActlAmtInTransCrcy</b>
     * </p>
     *
     * @return Actual Expense Amount in Transaction Currency
     */
    @SerializedName( "PubSecExpnActlAmtInTransCrcy" )
    @JsonProperty( "PubSecExpnActlAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecExpnActlAmtInTransCrcy" )
    private BigDecimal pubSecExpnActlAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecExpnActlAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_EXPN_ACTL_AMT_IN_TRANS_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecExpnActlAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnCmtmtAmtInTransCrcy</b>
     * </p>
     *
     * @return Commitment Revenue Amount in Transaction Currency
     */
    @SerializedName( "PubSecRevnCmtmtAmtInTransCrcy" )
    @JsonProperty( "PubSecRevnCmtmtAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecRevnCmtmtAmtInTransCrcy" )
    private BigDecimal pubSecRevnCmtmtAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecRevnCmtmtAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_REVN_CMTMT_AMT_IN_TRANS_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecRevnCmtmtAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnActlAmtInTransCrcy</b>
     * </p>
     *
     * @return Actual Revenue Amount in Transaction Currency
     */
    @SerializedName( "PubSecRevnActlAmtInTransCrcy" )
    @JsonProperty( "PubSecRevnActlAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecRevnActlAmtInTransCrcy" )
    private BigDecimal pubSecRevnActlAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecRevnActlAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_REVN_ACTL_AMT_IN_TRANS_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecRevnActlAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnCmtmtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Commitment Expense Amount in Company Code Currency
     */
    @SerializedName( "PubSecExpnCmtmtAmtInCoCodeCrcy" )
    @JsonProperty( "PubSecExpnCmtmtAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecExpnCmtmtAmtInCoCodeCrcy" )
    private BigDecimal pubSecExpnCmtmtAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecExpnCmtmtAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_EXPN_CMTMT_AMT_IN_CO_CODE_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecExpnCmtmtAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnActlAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Actual Expense Amount in Company Code Currency
     */
    @SerializedName( "PubSecExpnActlAmtInCoCodeCrcy" )
    @JsonProperty( "PubSecExpnActlAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecExpnActlAmtInCoCodeCrcy" )
    private BigDecimal pubSecExpnActlAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecExpnActlAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_EXPN_ACTL_AMT_IN_CO_CODE_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecExpnActlAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnCmtmtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Commitment Revenue Amount in Company Code Currency
     */
    @SerializedName( "PubSecRevnCmtmtAmtInCoCodeCrcy" )
    @JsonProperty( "PubSecRevnCmtmtAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecRevnCmtmtAmtInCoCodeCrcy" )
    private BigDecimal pubSecRevnCmtmtAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecRevnCmtmtAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_REVN_CMTMT_AMT_IN_CO_CODE_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecRevnCmtmtAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnActlAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Actual Revenue Amount in Company Code Currency
     */
    @SerializedName( "PubSecRevnActlAmtInCoCodeCrcy" )
    @JsonProperty( "PubSecRevnActlAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PubSecRevnActlAmtInCoCodeCrcy" )
    private BigDecimal pubSecRevnActlAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PubSecRevnActlAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<BigDecimal> PUB_SEC_REVN_ACTL_AMT_IN_CO_CODE_CRCY =
        new PublicSectorCommitmentActualItemField<BigDecimal>("PubSecRevnActlAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> COMPANY_CODE_CURRENCY =
        new PublicSectorCommitmentActualItemField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> DEBIT_CREDIT_CODE =
        new PublicSectorCommitmentActualItemField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FISCAL_PERIOD =
        new PublicSectorCommitmentActualItemField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @return Fiscal Year Period
     */
    @SerializedName( "FiscalYearPeriod" )
    @JsonProperty( "FiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearPeriod" )
    private String fiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearPeriod</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FISCAL_YEAR_PERIOD =
        new PublicSectorCommitmentActualItemField<String>("FiscalYearPeriod");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<LocalDateTime> POSTING_DATE =
        new PublicSectorCommitmentActualItemField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Journal Entry Date
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<LocalDateTime> DOCUMENT_DATE =
        new PublicSectorCommitmentActualItemField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Time Stamp of Last Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PublicSectorCommitmentActualItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Time Stamp of Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<ZonedDateTime> CREATION_DATE_TIME =
        new PublicSectorCommitmentActualItemField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<LocalDateTime> CREATION_DATE =
        new PublicSectorCommitmentActualItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @return Type of a General Ledger Account
     */
    @SerializedName( "GLAccountType" )
    @JsonProperty( "GLAccountType" )
    @Nullable
    @ODataField( odataName = "GLAccountType" )
    private String gLAccountType;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountType</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> GL_ACCOUNT_TYPE =
        new PublicSectorCommitmentActualItemField<String>("GLAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PURCHASING_DOCUMENT =
        new PublicSectorCommitmentActualItemField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PURCHASING_DOCUMENT_ITEM =
        new PublicSectorCommitmentActualItemField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @return Account Assignment Number
     */
    @SerializedName( "AccountAssignmentNumber" )
    @JsonProperty( "AccountAssignmentNumber" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentNumber" )
    private String accountAssignmentNumber;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentNumber</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> ACCOUNT_ASSIGNMENT_NUMBER =
        new PublicSectorCommitmentActualItemField<String>("AccountAssignmentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PRODUCT =
        new PublicSectorCommitmentActualItemField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> SUPPLIER =
        new PublicSectorCommitmentActualItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> CUSTOMER =
        new PublicSectorCommitmentActualItemField<String>("Customer");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @return Indicator: Account is a balance sheet account?
     */
    @SerializedName( "IsBalanceSheetAccount" )
    @JsonProperty( "IsBalanceSheetAccount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBalanceSheetAccount" )
    private Boolean isBalanceSheetAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsBalanceSheetAccount</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<Boolean> IS_BALANCE_SHEET_ACCOUNT =
        new PublicSectorCommitmentActualItemField<Boolean>("IsBalanceSheetAccount");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Fixed Asset
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> MASTER_FIXED_ASSET =
        new PublicSectorCommitmentActualItemField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FIXED_ASSET =
        new PublicSectorCommitmentActualItemField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetClass</b>
     * </p>
     *
     * @return Asset Class
     */
    @SerializedName( "AssetClass" )
    @JsonProperty( "AssetClass" )
    @Nullable
    @ODataField( odataName = "AssetClass" )
    private String assetClass;
    /**
     * Use with available fluent helpers to apply the <b>AssetClass</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> ASSET_CLASS =
        new PublicSectorCommitmentActualItemField<String>("AssetClass");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return WBS Element External ID
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new PublicSectorCommitmentActualItemField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID</b>
     * </p>
     *
     * @return Project External ID
     */
    @SerializedName( "ProjectExternalID" )
    @JsonProperty( "ProjectExternalID" )
    @Nullable
    @ODataField( odataName = "ProjectExternalID" )
    private String projectExternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectExternalID</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PROJECT_EXTERNAL_ID =
        new PublicSectorCommitmentActualItemField<String>("ProjectExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> SALES_ORGANIZATION =
        new PublicSectorCommitmentActualItemField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> DISTRIBUTION_CHANNEL =
        new PublicSectorCommitmentActualItemField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> ORGANIZATION_DIVISION =
        new PublicSectorCommitmentActualItemField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FINANCIAL_MANAGEMENT_AREA =
        new PublicSectorCommitmentActualItemField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FUND =
        new PublicSectorCommitmentActualItemField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> GRANT_ID =
        new PublicSectorCommitmentActualItemField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> BUDGET_PERIOD =
        new PublicSectorCommitmentActualItemField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CashLedgerAccount</b>
     * </p>
     *
     * @return Cash Origin Account
     */
    @SerializedName( "CashLedgerAccount" )
    @JsonProperty( "CashLedgerAccount" )
    @Nullable
    @ODataField( odataName = "CashLedgerAccount" )
    private String cashLedgerAccount;
    /**
     * Use with available fluent helpers to apply the <b>CashLedgerAccount</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> CASH_LEDGER_ACCOUNT =
        new PublicSectorCommitmentActualItemField<String>("CashLedgerAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CashLedgerCompanyCode</b>
     * </p>
     *
     * @return Cash Origin Company Code
     */
    @SerializedName( "CashLedgerCompanyCode" )
    @JsonProperty( "CashLedgerCompanyCode" )
    @Nullable
    @ODataField( odataName = "CashLedgerCompanyCode" )
    private String cashLedgerCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>CashLedgerCompanyCode</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> CASH_LEDGER_COMPANY_CODE =
        new PublicSectorCommitmentActualItemField<String>("CashLedgerCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccount</b>
     * </p>
     *
     * @return Budget Account
     */
    @SerializedName( "PubSecBudgetAccount" )
    @JsonProperty( "PubSecBudgetAccount" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetAccount" )
    private String pubSecBudgetAccount;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetAccount</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PUB_SEC_BUDGET_ACCOUNT =
        new PublicSectorCommitmentActualItemField<String>("PubSecBudgetAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccountCoCode</b>
     * </p>
     *
     * @return Budget Account Company Code
     */
    @SerializedName( "PubSecBudgetAccountCoCode" )
    @JsonProperty( "PubSecBudgetAccountCoCode" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetAccountCoCode" )
    private String pubSecBudgetAccountCoCode;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetAccountCoCode</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PUB_SEC_BUDGET_ACCOUNT_CO_CODE =
        new PublicSectorCommitmentActualItemField<String>("PubSecBudgetAccountCoCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnDate</b>
     * </p>
     *
     * @return Budget Consumption Date
     */
    @SerializedName( "PubSecBudgetCnsmpnDate" )
    @JsonProperty( "PubSecBudgetCnsmpnDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PubSecBudgetCnsmpnDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pubSecBudgetCnsmpnDate;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetCnsmpnDate</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<LocalDateTime> PUB_SEC_BUDGET_CNSMPN_DATE =
        new PublicSectorCommitmentActualItemField<LocalDateTime>("PubSecBudgetCnsmpnDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnFsclPeriod</b>
     * </p>
     *
     * @return CC Fiscal Period for Budget Consumption Date
     */
    @SerializedName( "PubSecBudgetCnsmpnFsclPeriod" )
    @JsonProperty( "PubSecBudgetCnsmpnFsclPeriod" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetCnsmpnFsclPeriod" )
    private String pubSecBudgetCnsmpnFsclPeriod;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetCnsmpnFsclPeriod</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PUB_SEC_BUDGET_CNSMPN_FSCL_PERIOD =
        new PublicSectorCommitmentActualItemField<String>("PubSecBudgetCnsmpnFsclPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnFsclYear</b>
     * </p>
     *
     * @return CC Fiscal Year for Budget Consumption Date
     */
    @SerializedName( "PubSecBudgetCnsmpnFsclYear" )
    @JsonProperty( "PubSecBudgetCnsmpnFsclYear" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetCnsmpnFsclYear" )
    private String pubSecBudgetCnsmpnFsclYear;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetCnsmpnFsclYear</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PUB_SEC_BUDGET_CNSMPN_FSCL_YEAR =
        new PublicSectorCommitmentActualItemField<String>("PubSecBudgetCnsmpnFsclYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnType</b>
     * </p>
     *
     * @return Budget Consumption Type
     */
    @SerializedName( "PubSecBudgetCnsmpnType" )
    @JsonProperty( "PubSecBudgetCnsmpnType" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetCnsmpnType" )
    private String pubSecBudgetCnsmpnType;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetCnsmpnType</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PUB_SEC_BUDGET_CNSMPN_TYPE =
        new PublicSectorCommitmentActualItemField<String>("PubSecBudgetCnsmpnType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnAmtType</b>
     * </p>
     *
     * @return Budget Consumption Amount Type
     */
    @SerializedName( "PubSecBudgetCnsmpnAmtType" )
    @JsonProperty( "PubSecBudgetCnsmpnAmtType" )
    @Nullable
    @ODataField( odataName = "PubSecBudgetCnsmpnAmtType" )
    private String pubSecBudgetCnsmpnAmtType;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetCnsmpnAmtType</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PUB_SEC_BUDGET_CNSMPN_AMT_TYPE =
        new PublicSectorCommitmentActualItemField<String>("PubSecBudgetCnsmpnAmtType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetIsRelevant</b>
     * </p>
     *
     * @return Budget-Relevant Indicator
     */
    @SerializedName( "PubSecBudgetIsRelevant" )
    @JsonProperty( "PubSecBudgetIsRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PubSecBudgetIsRelevant" )
    private Boolean pubSecBudgetIsRelevant;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBudgetIsRelevant</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<Boolean> PUB_SEC_BUDGET_IS_RELEVANT =
        new PublicSectorCommitmentActualItemField<Boolean>("PubSecBudgetIsRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctRevnExpnCode</b>
     * </p>
     *
     * @return Expense or Revenue on Budget Account
     */
    @SerializedName( "PubSecBdgtAcctRevnExpnCode" )
    @JsonProperty( "PubSecBdgtAcctRevnExpnCode" )
    @Nullable
    @ODataField( odataName = "PubSecBdgtAcctRevnExpnCode" )
    private String pubSecBdgtAcctRevnExpnCode;
    /**
     * Use with available fluent helpers to apply the <b>PubSecBdgtAcctRevnExpnCode</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PUB_SEC_BDGT_ACCT_REVN_EXPN_CODE =
        new PublicSectorCommitmentActualItemField<String>("PubSecBdgtAcctRevnExpnCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FundType</b>
     * </p>
     *
     * @return Fund Type
     */
    @SerializedName( "FundType" )
    @JsonProperty( "FundType" )
    @Nullable
    @ODataField( odataName = "FundType" )
    private String fundType;
    /**
     * Use with available fluent helpers to apply the <b>FundType</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FUND_TYPE =
        new PublicSectorCommitmentActualItemField<String>("FundType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredClass</b>
     * </p>
     *
     * @return Sponsored Class
     */
    @SerializedName( "SponsoredClass" )
    @JsonProperty( "SponsoredClass" )
    @Nullable
    @ODataField( odataName = "SponsoredClass" )
    private String sponsoredClass;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredClass</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> SPONSORED_CLASS =
        new PublicSectorCommitmentActualItemField<String>("SponsoredClass");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @return Sponsored Program
     */
    @SerializedName( "SponsoredProgram" )
    @JsonProperty( "SponsoredProgram" )
    @Nullable
    @ODataField( odataName = "SponsoredProgram" )
    private String sponsoredProgram;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredProgram</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> SPONSORED_PROGRAM =
        new PublicSectorCommitmentActualItemField<String>("SponsoredProgram");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetValidityNumber</b>
     * </p>
     *
     * @return Budget Validity Number
     */
    @SerializedName( "GteeMBudgetValidityNumber" )
    @JsonProperty( "GteeMBudgetValidityNumber" )
    @Nullable
    @ODataField( odataName = "GteeMBudgetValidityNumber" )
    private String gteeMBudgetValidityNumber;
    /**
     * Use with available fluent helpers to apply the <b>GteeMBudgetValidityNumber</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> GTEE_M_BUDGET_VALIDITY_NUMBER =
        new PublicSectorCommitmentActualItemField<String>("GteeMBudgetValidityNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchase Order Number
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PURCHASE_ORDER =
        new PublicSectorCommitmentActualItemField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PURCHASE_REQUISITION =
        new PublicSectorCommitmentActualItemField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document Number for Earmarked Funds
     */
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> EARMARKED_FUNDS_DOCUMENT =
        new PublicSectorCommitmentActualItemField<String>("EarmarkedFundsDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsStatisticalOrder</b>
     * </p>
     *
     * @return Indicator: Internal Order is Statistical Account Assignment
     */
    @SerializedName( "IsStatisticalOrder" )
    @JsonProperty( "IsStatisticalOrder" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsStatisticalOrder" )
    private Boolean isStatisticalOrder;
    /**
     * Use with available fluent helpers to apply the <b>IsStatisticalOrder</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<Boolean> IS_STATISTICAL_ORDER =
        new PublicSectorCommitmentActualItemField<Boolean>("IsStatisticalOrder");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsStatisticalCostCenter</b>
     * </p>
     *
     * @return Indicator: Cost Center is Statistical Account Assignment
     */
    @SerializedName( "IsStatisticalCostCenter" )
    @JsonProperty( "IsStatisticalCostCenter" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsStatisticalCostCenter" )
    private Boolean isStatisticalCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>IsStatisticalCostCenter</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<Boolean> IS_STATISTICAL_COST_CENTER =
        new PublicSectorCommitmentActualItemField<Boolean>("IsStatisticalCostCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     *
     * @return Indicator: WBS Element is Statistical Account Assignment
     */
    @SerializedName( "WBSIsStatisticalWBSElement" )
    @JsonProperty( "WBSIsStatisticalWBSElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSIsStatisticalWBSElement" )
    private Boolean wBSIsStatisticalWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSIsStatisticalWBSElement</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<Boolean> WBS_IS_STATISTICAL_WBS_ELEMENT =
        new PublicSectorCommitmentActualItemField<Boolean>("WBSIsStatisticalWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> CONTROLLING_AREA =
        new PublicSectorCommitmentActualItemField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> BUSINESS_AREA =
        new PublicSectorCommitmentActualItemField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "FinancialAccountType" )
    @JsonProperty( "FinancialAccountType" )
    @Nullable
    @ODataField( odataName = "FinancialAccountType" )
    private String financialAccountType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountType</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> FINANCIAL_ACCOUNT_TYPE =
        new PublicSectorCommitmentActualItemField<String>("FinancialAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> PLANT =
        new PublicSectorCommitmentActualItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static PublicSectorCommitmentActualItemField<String> VALUATION_AREA =
        new PublicSectorCommitmentActualItemField<String>("ValuationArea");

    @Nonnull
    @Override
    public Class<PublicSectorCommitmentActualItem> getType()
    {
        return PublicSectorCommitmentActualItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @param sourceLedger
     *            Source Ledger
     */
    public void setSourceLedger( @Nullable final String sourceLedger )
    {
        rememberChangedField("SourceLedger", this.sourceLedger);
        this.sourceLedger = sourceLedger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Journal Entry
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     */
    public void setLedgerGLLineItem( @Nullable final String ledgerGLLineItem )
    {
        rememberChangedField("LedgerGLLineItem", this.ledgerGLLineItem);
        this.ledgerGLLineItem = ledgerGLLineItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCommitment</b>
     * </p>
     *
     * @param isCommitment
     *            Indicator: Is Commitment
     */
    public void setIsCommitment( @Nullable final Boolean isCommitment )
    {
        rememberChangedField("IsCommitment", this.isCommitment);
        this.isCommitment = isCommitment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnCmtmtAmtInTransCrcy</b>
     * </p>
     *
     * @param pubSecExpnCmtmtAmtInTransCrcy
     *            Commitment Expense Amount in Transaction Currency
     */
    public void setPubSecExpnCmtmtAmtInTransCrcy( @Nullable final BigDecimal pubSecExpnCmtmtAmtInTransCrcy )
    {
        rememberChangedField("PubSecExpnCmtmtAmtInTransCrcy", this.pubSecExpnCmtmtAmtInTransCrcy);
        this.pubSecExpnCmtmtAmtInTransCrcy = pubSecExpnCmtmtAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnActlAmtInTransCrcy</b>
     * </p>
     *
     * @param pubSecExpnActlAmtInTransCrcy
     *            Actual Expense Amount in Transaction Currency
     */
    public void setPubSecExpnActlAmtInTransCrcy( @Nullable final BigDecimal pubSecExpnActlAmtInTransCrcy )
    {
        rememberChangedField("PubSecExpnActlAmtInTransCrcy", this.pubSecExpnActlAmtInTransCrcy);
        this.pubSecExpnActlAmtInTransCrcy = pubSecExpnActlAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnCmtmtAmtInTransCrcy</b>
     * </p>
     *
     * @param pubSecRevnCmtmtAmtInTransCrcy
     *            Commitment Revenue Amount in Transaction Currency
     */
    public void setPubSecRevnCmtmtAmtInTransCrcy( @Nullable final BigDecimal pubSecRevnCmtmtAmtInTransCrcy )
    {
        rememberChangedField("PubSecRevnCmtmtAmtInTransCrcy", this.pubSecRevnCmtmtAmtInTransCrcy);
        this.pubSecRevnCmtmtAmtInTransCrcy = pubSecRevnCmtmtAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnActlAmtInTransCrcy</b>
     * </p>
     *
     * @param pubSecRevnActlAmtInTransCrcy
     *            Actual Revenue Amount in Transaction Currency
     */
    public void setPubSecRevnActlAmtInTransCrcy( @Nullable final BigDecimal pubSecRevnActlAmtInTransCrcy )
    {
        rememberChangedField("PubSecRevnActlAmtInTransCrcy", this.pubSecRevnActlAmtInTransCrcy);
        this.pubSecRevnActlAmtInTransCrcy = pubSecRevnActlAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnCmtmtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param pubSecExpnCmtmtAmtInCoCodeCrcy
     *            Commitment Expense Amount in Company Code Currency
     */
    public void setPubSecExpnCmtmtAmtInCoCodeCrcy( @Nullable final BigDecimal pubSecExpnCmtmtAmtInCoCodeCrcy )
    {
        rememberChangedField("PubSecExpnCmtmtAmtInCoCodeCrcy", this.pubSecExpnCmtmtAmtInCoCodeCrcy);
        this.pubSecExpnCmtmtAmtInCoCodeCrcy = pubSecExpnCmtmtAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecExpnActlAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param pubSecExpnActlAmtInCoCodeCrcy
     *            Actual Expense Amount in Company Code Currency
     */
    public void setPubSecExpnActlAmtInCoCodeCrcy( @Nullable final BigDecimal pubSecExpnActlAmtInCoCodeCrcy )
    {
        rememberChangedField("PubSecExpnActlAmtInCoCodeCrcy", this.pubSecExpnActlAmtInCoCodeCrcy);
        this.pubSecExpnActlAmtInCoCodeCrcy = pubSecExpnActlAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnCmtmtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param pubSecRevnCmtmtAmtInCoCodeCrcy
     *            Commitment Revenue Amount in Company Code Currency
     */
    public void setPubSecRevnCmtmtAmtInCoCodeCrcy( @Nullable final BigDecimal pubSecRevnCmtmtAmtInCoCodeCrcy )
    {
        rememberChangedField("PubSecRevnCmtmtAmtInCoCodeCrcy", this.pubSecRevnCmtmtAmtInCoCodeCrcy);
        this.pubSecRevnCmtmtAmtInCoCodeCrcy = pubSecRevnCmtmtAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 25, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecRevnActlAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param pubSecRevnActlAmtInCoCodeCrcy
     *            Actual Revenue Amount in Company Code Currency
     */
    public void setPubSecRevnActlAmtInCoCodeCrcy( @Nullable final BigDecimal pubSecRevnActlAmtInCoCodeCrcy )
    {
        rememberChangedField("PubSecRevnActlAmtInCoCodeCrcy", this.pubSecRevnActlAmtInCoCodeCrcy);
        this.pubSecRevnActlAmtInCoCodeCrcy = pubSecRevnActlAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Code
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @param fiscalYearPeriod
     *            Fiscal Year Period
     */
    public void setFiscalYearPeriod( @Nullable final String fiscalYearPeriod )
    {
        rememberChangedField("FiscalYearPeriod", this.fiscalYearPeriod);
        this.fiscalYearPeriod = fiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Journal Entry Date
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Time Stamp of Last Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Time Stamp of Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @param gLAccountType
     *            Type of a General Ledger Account
     */
    public void setGLAccountType( @Nullable final String gLAccountType )
    {
        rememberChangedField("GLAccountType", this.gLAccountType);
        this.gLAccountType = gLAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @param accountAssignmentNumber
     *            Account Assignment Number
     */
    public void setAccountAssignmentNumber( @Nullable final String accountAssignmentNumber )
    {
        rememberChangedField("AccountAssignmentNumber", this.accountAssignmentNumber);
        this.accountAssignmentNumber = accountAssignmentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @param isBalanceSheetAccount
     *            Indicator: Account is a balance sheet account?
     */
    public void setIsBalanceSheetAccount( @Nullable final Boolean isBalanceSheetAccount )
    {
        rememberChangedField("IsBalanceSheetAccount", this.isBalanceSheetAccount);
        this.isBalanceSheetAccount = isBalanceSheetAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Fixed Asset
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetClass</b>
     * </p>
     *
     * @param assetClass
     *            Asset Class
     */
    public void setAssetClass( @Nullable final String assetClass )
    {
        rememberChangedField("AssetClass", this.assetClass);
        this.assetClass = assetClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            WBS Element External ID
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID</b>
     * </p>
     *
     * @param projectExternalID
     *            Project External ID
     */
    public void setProjectExternalID( @Nullable final String projectExternalID )
    {
        rememberChangedField("ProjectExternalID", this.projectExternalID);
        this.projectExternalID = projectExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CashLedgerAccount</b>
     * </p>
     *
     * @param cashLedgerAccount
     *            Cash Origin Account
     */
    public void setCashLedgerAccount( @Nullable final String cashLedgerAccount )
    {
        rememberChangedField("CashLedgerAccount", this.cashLedgerAccount);
        this.cashLedgerAccount = cashLedgerAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CashLedgerCompanyCode</b>
     * </p>
     *
     * @param cashLedgerCompanyCode
     *            Cash Origin Company Code
     */
    public void setCashLedgerCompanyCode( @Nullable final String cashLedgerCompanyCode )
    {
        rememberChangedField("CashLedgerCompanyCode", this.cashLedgerCompanyCode);
        this.cashLedgerCompanyCode = cashLedgerCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccount</b>
     * </p>
     *
     * @param pubSecBudgetAccount
     *            Budget Account
     */
    public void setPubSecBudgetAccount( @Nullable final String pubSecBudgetAccount )
    {
        rememberChangedField("PubSecBudgetAccount", this.pubSecBudgetAccount);
        this.pubSecBudgetAccount = pubSecBudgetAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetAccountCoCode</b>
     * </p>
     *
     * @param pubSecBudgetAccountCoCode
     *            Budget Account Company Code
     */
    public void setPubSecBudgetAccountCoCode( @Nullable final String pubSecBudgetAccountCoCode )
    {
        rememberChangedField("PubSecBudgetAccountCoCode", this.pubSecBudgetAccountCoCode);
        this.pubSecBudgetAccountCoCode = pubSecBudgetAccountCoCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnDate</b>
     * </p>
     *
     * @param pubSecBudgetCnsmpnDate
     *            Budget Consumption Date
     */
    public void setPubSecBudgetCnsmpnDate( @Nullable final LocalDateTime pubSecBudgetCnsmpnDate )
    {
        rememberChangedField("PubSecBudgetCnsmpnDate", this.pubSecBudgetCnsmpnDate);
        this.pubSecBudgetCnsmpnDate = pubSecBudgetCnsmpnDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnFsclPeriod</b>
     * </p>
     *
     * @param pubSecBudgetCnsmpnFsclPeriod
     *            CC Fiscal Period for Budget Consumption Date
     */
    public void setPubSecBudgetCnsmpnFsclPeriod( @Nullable final String pubSecBudgetCnsmpnFsclPeriod )
    {
        rememberChangedField("PubSecBudgetCnsmpnFsclPeriod", this.pubSecBudgetCnsmpnFsclPeriod);
        this.pubSecBudgetCnsmpnFsclPeriod = pubSecBudgetCnsmpnFsclPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnFsclYear</b>
     * </p>
     *
     * @param pubSecBudgetCnsmpnFsclYear
     *            CC Fiscal Year for Budget Consumption Date
     */
    public void setPubSecBudgetCnsmpnFsclYear( @Nullable final String pubSecBudgetCnsmpnFsclYear )
    {
        rememberChangedField("PubSecBudgetCnsmpnFsclYear", this.pubSecBudgetCnsmpnFsclYear);
        this.pubSecBudgetCnsmpnFsclYear = pubSecBudgetCnsmpnFsclYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnType</b>
     * </p>
     *
     * @param pubSecBudgetCnsmpnType
     *            Budget Consumption Type
     */
    public void setPubSecBudgetCnsmpnType( @Nullable final String pubSecBudgetCnsmpnType )
    {
        rememberChangedField("PubSecBudgetCnsmpnType", this.pubSecBudgetCnsmpnType);
        this.pubSecBudgetCnsmpnType = pubSecBudgetCnsmpnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetCnsmpnAmtType</b>
     * </p>
     *
     * @param pubSecBudgetCnsmpnAmtType
     *            Budget Consumption Amount Type
     */
    public void setPubSecBudgetCnsmpnAmtType( @Nullable final String pubSecBudgetCnsmpnAmtType )
    {
        rememberChangedField("PubSecBudgetCnsmpnAmtType", this.pubSecBudgetCnsmpnAmtType);
        this.pubSecBudgetCnsmpnAmtType = pubSecBudgetCnsmpnAmtType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBudgetIsRelevant</b>
     * </p>
     *
     * @param pubSecBudgetIsRelevant
     *            Budget-Relevant Indicator
     */
    public void setPubSecBudgetIsRelevant( @Nullable final Boolean pubSecBudgetIsRelevant )
    {
        rememberChangedField("PubSecBudgetIsRelevant", this.pubSecBudgetIsRelevant);
        this.pubSecBudgetIsRelevant = pubSecBudgetIsRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PubSecBdgtAcctRevnExpnCode</b>
     * </p>
     *
     * @param pubSecBdgtAcctRevnExpnCode
     *            Expense or Revenue on Budget Account
     */
    public void setPubSecBdgtAcctRevnExpnCode( @Nullable final String pubSecBdgtAcctRevnExpnCode )
    {
        rememberChangedField("PubSecBdgtAcctRevnExpnCode", this.pubSecBdgtAcctRevnExpnCode);
        this.pubSecBdgtAcctRevnExpnCode = pubSecBdgtAcctRevnExpnCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FundType</b>
     * </p>
     *
     * @param fundType
     *            Fund Type
     */
    public void setFundType( @Nullable final String fundType )
    {
        rememberChangedField("FundType", this.fundType);
        this.fundType = fundType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredClass</b>
     * </p>
     *
     * @param sponsoredClass
     *            Sponsored Class
     */
    public void setSponsoredClass( @Nullable final String sponsoredClass )
    {
        rememberChangedField("SponsoredClass", this.sponsoredClass);
        this.sponsoredClass = sponsoredClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @param sponsoredProgram
     *            Sponsored Program
     */
    public void setSponsoredProgram( @Nullable final String sponsoredProgram )
    {
        rememberChangedField("SponsoredProgram", this.sponsoredProgram);
        this.sponsoredProgram = sponsoredProgram;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetValidityNumber</b>
     * </p>
     *
     * @param gteeMBudgetValidityNumber
     *            Budget Validity Number
     */
    public void setGteeMBudgetValidityNumber( @Nullable final String gteeMBudgetValidityNumber )
    {
        rememberChangedField("GteeMBudgetValidityNumber", this.gteeMBudgetValidityNumber);
        this.gteeMBudgetValidityNumber = gteeMBudgetValidityNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchase Order Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsStatisticalOrder</b>
     * </p>
     *
     * @param isStatisticalOrder
     *            Indicator: Internal Order is Statistical Account Assignment
     */
    public void setIsStatisticalOrder( @Nullable final Boolean isStatisticalOrder )
    {
        rememberChangedField("IsStatisticalOrder", this.isStatisticalOrder);
        this.isStatisticalOrder = isStatisticalOrder;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsStatisticalCostCenter</b>
     * </p>
     *
     * @param isStatisticalCostCenter
     *            Indicator: Cost Center is Statistical Account Assignment
     */
    public void setIsStatisticalCostCenter( @Nullable final Boolean isStatisticalCostCenter )
    {
        rememberChangedField("IsStatisticalCostCenter", this.isStatisticalCostCenter);
        this.isStatisticalCostCenter = isStatisticalCostCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     *
     * @param wBSIsStatisticalWBSElement
     *            Indicator: WBS Element is Statistical Account Assignment
     */
    public void setWBSIsStatisticalWBSElement( @Nullable final Boolean wBSIsStatisticalWBSElement )
    {
        rememberChangedField("WBSIsStatisticalWBSElement", this.wBSIsStatisticalWBSElement);
        this.wBSIsStatisticalWBSElement = wBSIsStatisticalWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @param financialAccountType
     *            Account Type
     */
    public void setFinancialAccountType( @Nullable final String financialAccountType )
    {
        rememberChangedField("FinancialAccountType", this.financialAccountType);
        this.financialAccountType = financialAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PubSecCmtmtActlItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Ledger", getLedger());
        result.put("SourceLedger", getSourceLedger());
        result.put("CompanyCode", getCompanyCode());
        result.put("FiscalYear", getFiscalYear());
        result.put("AccountingDocument", getAccountingDocument());
        result.put("LedgerGLLineItem", getLedgerGLLineItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Ledger", getLedger());
        values.put("SourceLedger", getSourceLedger());
        values.put("CompanyCode", getCompanyCode());
        values.put("FiscalYear", getFiscalYear());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("LedgerGLLineItem", getLedgerGLLineItem());
        values.put("IsCommitment", getIsCommitment());
        values.put("GLAccount", getGLAccount());
        values.put("CostCenter", getCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("Segment", getSegment());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("PubSecExpnCmtmtAmtInTransCrcy", getPubSecExpnCmtmtAmtInTransCrcy());
        values.put("PubSecExpnActlAmtInTransCrcy", getPubSecExpnActlAmtInTransCrcy());
        values.put("PubSecRevnCmtmtAmtInTransCrcy", getPubSecRevnCmtmtAmtInTransCrcy());
        values.put("PubSecRevnActlAmtInTransCrcy", getPubSecRevnActlAmtInTransCrcy());
        values.put("PubSecExpnCmtmtAmtInCoCodeCrcy", getPubSecExpnCmtmtAmtInCoCodeCrcy());
        values.put("PubSecExpnActlAmtInCoCodeCrcy", getPubSecExpnActlAmtInCoCodeCrcy());
        values.put("PubSecRevnCmtmtAmtInCoCodeCrcy", getPubSecRevnCmtmtAmtInCoCodeCrcy());
        values.put("PubSecRevnActlAmtInCoCodeCrcy", getPubSecRevnActlAmtInCoCodeCrcy());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("FiscalYearPeriod", getFiscalYearPeriod());
        values.put("PostingDate", getPostingDate());
        values.put("DocumentDate", getDocumentDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreationDate", getCreationDate());
        values.put("GLAccountType", getGLAccountType());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("AccountAssignmentNumber", getAccountAssignmentNumber());
        values.put("Product", getProduct());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("IsBalanceSheetAccount", getIsBalanceSheetAccount());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("AssetClass", getAssetClass());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("ProjectExternalID", getProjectExternalID());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("CashLedgerAccount", getCashLedgerAccount());
        values.put("CashLedgerCompanyCode", getCashLedgerCompanyCode());
        values.put("PubSecBudgetAccount", getPubSecBudgetAccount());
        values.put("PubSecBudgetAccountCoCode", getPubSecBudgetAccountCoCode());
        values.put("PubSecBudgetCnsmpnDate", getPubSecBudgetCnsmpnDate());
        values.put("PubSecBudgetCnsmpnFsclPeriod", getPubSecBudgetCnsmpnFsclPeriod());
        values.put("PubSecBudgetCnsmpnFsclYear", getPubSecBudgetCnsmpnFsclYear());
        values.put("PubSecBudgetCnsmpnType", getPubSecBudgetCnsmpnType());
        values.put("PubSecBudgetCnsmpnAmtType", getPubSecBudgetCnsmpnAmtType());
        values.put("PubSecBudgetIsRelevant", getPubSecBudgetIsRelevant());
        values.put("PubSecBdgtAcctRevnExpnCode", getPubSecBdgtAcctRevnExpnCode());
        values.put("FundType", getFundType());
        values.put("SponsoredClass", getSponsoredClass());
        values.put("SponsoredProgram", getSponsoredProgram());
        values.put("GteeMBudgetValidityNumber", getGteeMBudgetValidityNumber());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("IsStatisticalOrder", getIsStatisticalOrder());
        values.put("IsStatisticalCostCenter", getIsStatisticalCostCenter());
        values.put("WBSIsStatisticalWBSElement", getWBSIsStatisticalWBSElement());
        values.put("ControllingArea", getControllingArea());
        values.put("BusinessArea", getBusinessArea());
        values.put("FinancialAccountType", getFinancialAccountType());
        values.put("Plant", getPlant());
        values.put("ValuationArea", getValuationArea());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("SourceLedger") ) {
                final Object value = values.remove("SourceLedger");
                if( (value == null) || (!value.equals(getSourceLedger())) ) {
                    setSourceLedger(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("LedgerGLLineItem") ) {
                final Object value = values.remove("LedgerGLLineItem");
                if( (value == null) || (!value.equals(getLedgerGLLineItem())) ) {
                    setLedgerGLLineItem(((String) value));
                }
            }
            if( values.containsKey("IsCommitment") ) {
                final Object value = values.remove("IsCommitment");
                if( (value == null) || (!value.equals(getIsCommitment())) ) {
                    setIsCommitment(((Boolean) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("PubSecExpnCmtmtAmtInTransCrcy") ) {
                final Object value = values.remove("PubSecExpnCmtmtAmtInTransCrcy");
                if( (value == null) || (!value.equals(getPubSecExpnCmtmtAmtInTransCrcy())) ) {
                    setPubSecExpnCmtmtAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PubSecExpnActlAmtInTransCrcy") ) {
                final Object value = values.remove("PubSecExpnActlAmtInTransCrcy");
                if( (value == null) || (!value.equals(getPubSecExpnActlAmtInTransCrcy())) ) {
                    setPubSecExpnActlAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PubSecRevnCmtmtAmtInTransCrcy") ) {
                final Object value = values.remove("PubSecRevnCmtmtAmtInTransCrcy");
                if( (value == null) || (!value.equals(getPubSecRevnCmtmtAmtInTransCrcy())) ) {
                    setPubSecRevnCmtmtAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PubSecRevnActlAmtInTransCrcy") ) {
                final Object value = values.remove("PubSecRevnActlAmtInTransCrcy");
                if( (value == null) || (!value.equals(getPubSecRevnActlAmtInTransCrcy())) ) {
                    setPubSecRevnActlAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PubSecExpnCmtmtAmtInCoCodeCrcy") ) {
                final Object value = values.remove("PubSecExpnCmtmtAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getPubSecExpnCmtmtAmtInCoCodeCrcy())) ) {
                    setPubSecExpnCmtmtAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PubSecExpnActlAmtInCoCodeCrcy") ) {
                final Object value = values.remove("PubSecExpnActlAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getPubSecExpnActlAmtInCoCodeCrcy())) ) {
                    setPubSecExpnActlAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PubSecRevnCmtmtAmtInCoCodeCrcy") ) {
                final Object value = values.remove("PubSecRevnCmtmtAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getPubSecRevnCmtmtAmtInCoCodeCrcy())) ) {
                    setPubSecRevnCmtmtAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PubSecRevnActlAmtInCoCodeCrcy") ) {
                final Object value = values.remove("PubSecRevnActlAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getPubSecRevnActlAmtInCoCodeCrcy())) ) {
                    setPubSecRevnActlAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearPeriod") ) {
                final Object value = values.remove("FiscalYearPeriod");
                if( (value == null) || (!value.equals(getFiscalYearPeriod())) ) {
                    setFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GLAccountType") ) {
                final Object value = values.remove("GLAccountType");
                if( (value == null) || (!value.equals(getGLAccountType())) ) {
                    setGLAccountType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentNumber") ) {
                final Object value = values.remove("AccountAssignmentNumber");
                if( (value == null) || (!value.equals(getAccountAssignmentNumber())) ) {
                    setAccountAssignmentNumber(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("IsBalanceSheetAccount") ) {
                final Object value = values.remove("IsBalanceSheetAccount");
                if( (value == null) || (!value.equals(getIsBalanceSheetAccount())) ) {
                    setIsBalanceSheetAccount(((Boolean) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("AssetClass") ) {
                final Object value = values.remove("AssetClass");
                if( (value == null) || (!value.equals(getAssetClass())) ) {
                    setAssetClass(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("ProjectExternalID") ) {
                final Object value = values.remove("ProjectExternalID");
                if( (value == null) || (!value.equals(getProjectExternalID())) ) {
                    setProjectExternalID(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("CashLedgerAccount") ) {
                final Object value = values.remove("CashLedgerAccount");
                if( (value == null) || (!value.equals(getCashLedgerAccount())) ) {
                    setCashLedgerAccount(((String) value));
                }
            }
            if( values.containsKey("CashLedgerCompanyCode") ) {
                final Object value = values.remove("CashLedgerCompanyCode");
                if( (value == null) || (!value.equals(getCashLedgerCompanyCode())) ) {
                    setCashLedgerCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetAccount") ) {
                final Object value = values.remove("PubSecBudgetAccount");
                if( (value == null) || (!value.equals(getPubSecBudgetAccount())) ) {
                    setPubSecBudgetAccount(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetAccountCoCode") ) {
                final Object value = values.remove("PubSecBudgetAccountCoCode");
                if( (value == null) || (!value.equals(getPubSecBudgetAccountCoCode())) ) {
                    setPubSecBudgetAccountCoCode(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetCnsmpnDate") ) {
                final Object value = values.remove("PubSecBudgetCnsmpnDate");
                if( (value == null) || (!value.equals(getPubSecBudgetCnsmpnDate())) ) {
                    setPubSecBudgetCnsmpnDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PubSecBudgetCnsmpnFsclPeriod") ) {
                final Object value = values.remove("PubSecBudgetCnsmpnFsclPeriod");
                if( (value == null) || (!value.equals(getPubSecBudgetCnsmpnFsclPeriod())) ) {
                    setPubSecBudgetCnsmpnFsclPeriod(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetCnsmpnFsclYear") ) {
                final Object value = values.remove("PubSecBudgetCnsmpnFsclYear");
                if( (value == null) || (!value.equals(getPubSecBudgetCnsmpnFsclYear())) ) {
                    setPubSecBudgetCnsmpnFsclYear(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetCnsmpnType") ) {
                final Object value = values.remove("PubSecBudgetCnsmpnType");
                if( (value == null) || (!value.equals(getPubSecBudgetCnsmpnType())) ) {
                    setPubSecBudgetCnsmpnType(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetCnsmpnAmtType") ) {
                final Object value = values.remove("PubSecBudgetCnsmpnAmtType");
                if( (value == null) || (!value.equals(getPubSecBudgetCnsmpnAmtType())) ) {
                    setPubSecBudgetCnsmpnAmtType(((String) value));
                }
            }
            if( values.containsKey("PubSecBudgetIsRelevant") ) {
                final Object value = values.remove("PubSecBudgetIsRelevant");
                if( (value == null) || (!value.equals(getPubSecBudgetIsRelevant())) ) {
                    setPubSecBudgetIsRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("PubSecBdgtAcctRevnExpnCode") ) {
                final Object value = values.remove("PubSecBdgtAcctRevnExpnCode");
                if( (value == null) || (!value.equals(getPubSecBdgtAcctRevnExpnCode())) ) {
                    setPubSecBdgtAcctRevnExpnCode(((String) value));
                }
            }
            if( values.containsKey("FundType") ) {
                final Object value = values.remove("FundType");
                if( (value == null) || (!value.equals(getFundType())) ) {
                    setFundType(((String) value));
                }
            }
            if( values.containsKey("SponsoredClass") ) {
                final Object value = values.remove("SponsoredClass");
                if( (value == null) || (!value.equals(getSponsoredClass())) ) {
                    setSponsoredClass(((String) value));
                }
            }
            if( values.containsKey("SponsoredProgram") ) {
                final Object value = values.remove("SponsoredProgram");
                if( (value == null) || (!value.equals(getSponsoredProgram())) ) {
                    setSponsoredProgram(((String) value));
                }
            }
            if( values.containsKey("GteeMBudgetValidityNumber") ) {
                final Object value = values.remove("GteeMBudgetValidityNumber");
                if( (value == null) || (!value.equals(getGteeMBudgetValidityNumber())) ) {
                    setGteeMBudgetValidityNumber(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("IsStatisticalOrder") ) {
                final Object value = values.remove("IsStatisticalOrder");
                if( (value == null) || (!value.equals(getIsStatisticalOrder())) ) {
                    setIsStatisticalOrder(((Boolean) value));
                }
            }
            if( values.containsKey("IsStatisticalCostCenter") ) {
                final Object value = values.remove("IsStatisticalCostCenter");
                if( (value == null) || (!value.equals(getIsStatisticalCostCenter())) ) {
                    setIsStatisticalCostCenter(((Boolean) value));
                }
            }
            if( values.containsKey("WBSIsStatisticalWBSElement") ) {
                final Object value = values.remove("WBSIsStatisticalWBSElement");
                if( (value == null) || (!value.equals(getWBSIsStatisticalWBSElement())) ) {
                    setWBSIsStatisticalWBSElement(((Boolean) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountType") ) {
                final Object value = values.remove("FinancialAccountType");
                if( (value == null) || (!value.equals(getFinancialAccountType())) ) {
                    setFinancialAccountType(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PublicSectorCommitmentActualItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new PublicSectorCommitmentActualItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PublicSectorCommitmentActualItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PublicSectorCommitmentActualItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommitmentAndActualItemService.DEFAULT_SERVICE_PATH);
    }

}
