/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.selectable.PublicSectorCommitmentActualItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem
 * PublicSectorCommitmentActualItem} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class PublicSectorCommitmentActualItemByKeyFluentHelper
    extends
    FluentHelperByKey<PublicSectorCommitmentActualItemByKeyFluentHelper, PublicSectorCommitmentActualItem, PublicSectorCommitmentActualItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem
     * PublicSectorCommitmentActualItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PublicSectorCommitmentActualItem}
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PublicSectorCommitmentActualItem}
     * @param accountingDocument
     *            Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param sourceLedger
     *            Source Ledger
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public PublicSectorCommitmentActualItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String ledger,
        final String sourceLedger,
        final String companyCode,
        final String fiscalYear,
        final String accountingDocument,
        final String ledgerGLLineItem )
    {
        super(servicePath, entityCollection);
        this.key.put("Ledger", ledger);
        this.key.put("SourceLedger", sourceLedger);
        this.key.put("CompanyCode", companyCode);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("AccountingDocument", accountingDocument);
        this.key.put("LedgerGLLineItem", ledgerGLLineItem);
    }

    @Override
    @Nonnull
    protected Class<PublicSectorCommitmentActualItem> getEntityClass()
    {
        return PublicSectorCommitmentActualItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
