/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CommitmentAndActualItemServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommitmentAndActualItemService
 * CommitmentAndActualItemService}.
 *
 */
public class DefaultCommitmentAndActualItemServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CommitmentAndActualItemServiceBatch, CommitmentAndActualItemServiceBatchChangeSet>
    implements
    CommitmentAndActualItemServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommitmentAndActualItemService service;

    @SuppressWarnings( "deprecation" )
    DefaultCommitmentAndActualItemServiceBatchChangeSet(
        @Nonnull final DefaultCommitmentAndActualItemServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommitmentAndActualItemService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCommitmentAndActualItemServiceBatchChangeSet getThis()
    {
        return this;
    }

}
