/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem
 * PublicSectorCommitmentActualItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.field.PublicSectorCommitmentActualItemField
 * PublicSectorCommitmentActualItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.link.PublicSectorCommitmentActualItemLink
 * PublicSectorCommitmentActualItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#SOURCE_LEDGER
 * SOURCE_LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#LEDGER_GL_LINE_ITEM
 * LEDGER_GL_LINE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#IS_COMMITMENT
 * IS_COMMITMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#SEGMENT
 * SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_EXPN_CMTMT_AMT_IN_TRANS_CRCY
 * PUB_SEC_EXPN_CMTMT_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_EXPN_ACTL_AMT_IN_TRANS_CRCY
 * PUB_SEC_EXPN_ACTL_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_REVN_CMTMT_AMT_IN_TRANS_CRCY
 * PUB_SEC_REVN_CMTMT_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_REVN_ACTL_AMT_IN_TRANS_CRCY
 * PUB_SEC_REVN_ACTL_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_EXPN_CMTMT_AMT_IN_CO_CODE_CRCY
 * PUB_SEC_EXPN_CMTMT_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_EXPN_ACTL_AMT_IN_CO_CODE_CRCY
 * PUB_SEC_EXPN_ACTL_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_REVN_CMTMT_AMT_IN_CO_CODE_CRCY
 * PUB_SEC_REVN_CMTMT_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_REVN_ACTL_AMT_IN_CO_CODE_CRCY
 * PUB_SEC_REVN_ACTL_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#GL_ACCOUNT_TYPE
 * GL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#ACCOUNT_ASSIGNMENT_NUMBER
 * ACCOUNT_ASSIGNMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#IS_BALANCE_SHEET_ACCOUNT
 * IS_BALANCE_SHEET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#ASSET_CLASS
 * ASSET_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PROJECT_EXTERNAL_ID
 * PROJECT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#CASH_LEDGER_ACCOUNT
 * CASH_LEDGER_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#CASH_LEDGER_COMPANY_CODE
 * CASH_LEDGER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_ACCOUNT
 * PUB_SEC_BUDGET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_ACCOUNT_CO_CODE
 * PUB_SEC_BUDGET_ACCOUNT_CO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_CNSMPN_DATE
 * PUB_SEC_BUDGET_CNSMPN_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_CNSMPN_FSCL_PERIOD
 * PUB_SEC_BUDGET_CNSMPN_FSCL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_CNSMPN_FSCL_YEAR
 * PUB_SEC_BUDGET_CNSMPN_FSCL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_CNSMPN_TYPE
 * PUB_SEC_BUDGET_CNSMPN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_CNSMPN_AMT_TYPE
 * PUB_SEC_BUDGET_CNSMPN_AMT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BUDGET_IS_RELEVANT
 * PUB_SEC_BUDGET_IS_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PUB_SEC_BDGT_ACCT_REVN_EXPN_CODE
 * PUB_SEC_BDGT_ACCT_REVN_EXPN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FUND_TYPE
 * FUND_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#SPONSORED_CLASS
 * SPONSORED_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#GTEE_M_BUDGET_VALIDITY_NUMBER
 * GTEE_M_BUDGET_VALIDITY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#EARMARKED_FUNDS_DOCUMENT
 * EARMARKED_FUNDS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#IS_STATISTICAL_ORDER
 * IS_STATISTICAL_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#IS_STATISTICAL_COST_CENTER
 * IS_STATISTICAL_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#WBS_IS_STATISTICAL_WBS_ELEMENT
 * WBS_IS_STATISTICAL_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#FINANCIAL_ACCOUNT_TYPE
 * FINANCIAL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commitmentandactualitem.PublicSectorCommitmentActualItem#VALUATION_AREA
 * VALUATION_AREA}</li>
 * </ul>
 *
 */
public interface PublicSectorCommitmentActualItemSelectable extends EntitySelectable<PublicSectorCommitmentActualItem>
{

}
