/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.companycode.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CompanyCodeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService CompanyCodeService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCompanyCodeServiceBatch
    extends
    BatchFluentHelperBasic<CompanyCodeServiceBatch, CompanyCodeServiceBatchChangeSet>
    implements
    CompanyCodeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCompanyCodeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCompanyCodeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCompanyCodeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCompanyCodeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCompanyCodeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CompanyCodeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCompanyCodeServiceBatchChangeSet(this, service);
    }

}
