/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.companycode.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CompanyCodeServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService CompanyCodeService}.
 *
 */
public class DefaultCompanyCodeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CompanyCodeServiceBatch, CompanyCodeServiceBatchChangeSet>
    implements
    CompanyCodeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService service;

    @SuppressWarnings( "deprecation" )
    DefaultCompanyCodeServiceBatchChangeSet(
        @Nonnull final DefaultCompanyCodeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CompanyCodeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCompanyCodeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
