/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.field.BusVolFldCombnSetTypeAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.link.BusVolFldCombnSetTypeAssgmtLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.selectable.BusVolFldCombnSetTypeAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Field Combination Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusVolFldCombnSetTypeAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusVolFldCombnSetTypeAssgmt extends VdmEntity<BusVolFldCombnSetTypeAssgmt>
{

    /**
     * Selector for all available fields of BusVolFldCombnSetTypeAssgmt.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrType</b>
     * </p>
     *
     * @return Condition Contract Type
     */
    @Key
    @SerializedName( "CndnContrType" )
    @JsonProperty( "CndnContrType" )
    @Nullable
    @ODataField( odataName = "CndnContrType" )
    private String cndnContrType;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrType</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<String> CNDN_CONTR_TYPE =
        new BusVolFldCombnSetTypeAssgmtField<String>("CndnContrType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnSet</b>
     * </p>
     *
     * @return Set of Field Combinations
     */
    @Key
    @SerializedName( "BusVolFldCombnSet" )
    @JsonProperty( "BusVolFldCombnSet" )
    @Nullable
    @ODataField( odataName = "BusVolFldCombnSet" )
    private String busVolFldCombnSet;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnSet</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<String> BUS_VOL_FLD_COMBN_SET =
        new BusVolFldCombnSetTypeAssgmtField<String>("BusVolFldCombnSet");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFieldCombnType</b>
     * </p>
     *
     * @return Field Combination for Business Volume Selection
     */
    @Key
    @SerializedName( "BusVolFieldCombnType" )
    @JsonProperty( "BusVolFieldCombnType" )
    @Nullable
    @ODataField( odataName = "BusVolFieldCombnType" )
    private String busVolFieldCombnType;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFieldCombnType</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<String> BUS_VOL_FIELD_COMBN_TYPE =
        new BusVolFldCombnSetTypeAssgmtField<String>("BusVolFieldCombnType");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnMinNrOfEntries</b>
     * </p>
     *
     * @return Minimum Number of Entries for Field Combination
     */
    @SerializedName( "BusVolFldCombnMinNrOfEntries" )
    @JsonProperty( "BusVolFldCombnMinNrOfEntries" )
    @Nullable
    @ODataField( odataName = "BusVolFldCombnMinNrOfEntries" )
    private BigDecimal busVolFldCombnMinNrOfEntries;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnMinNrOfEntries</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<BigDecimal> BUS_VOL_FLD_COMBN_MIN_NR_OF_ENTRIES =
        new BusVolFldCombnSetTypeAssgmtField<BigDecimal>("BusVolFldCombnMinNrOfEntries");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnMaxNrOfEntries</b>
     * </p>
     *
     * @return Maximum Number of Entries for Field Combination
     */
    @SerializedName( "BusVolFldCombnMaxNrOfEntries" )
    @JsonProperty( "BusVolFldCombnMaxNrOfEntries" )
    @Nullable
    @ODataField( odataName = "BusVolFldCombnMaxNrOfEntries" )
    private BigDecimal busVolFldCombnMaxNrOfEntries;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnMaxNrOfEntries</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<BigDecimal> BUS_VOL_FLD_COMBN_MAX_NR_OF_ENTRIES =
        new BusVolFldCombnSetTypeAssgmtField<BigDecimal>("BusVolFldCombnMaxNrOfEntries");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnGroup</b>
     * </p>
     *
     * @return Field Combination Group for Business Volume Selection
     */
    @SerializedName( "BusVolFldCombnGroup" )
    @JsonProperty( "BusVolFldCombnGroup" )
    @Nullable
    @ODataField( odataName = "BusVolFldCombnGroup" )
    private String busVolFldCombnGroup;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnGroup</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<String> BUS_VOL_FLD_COMBN_GROUP =
        new BusVolFldCombnSetTypeAssgmtField<String>("BusVolFldCombnGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnAllwdSign</b>
     * </p>
     *
     * @return Including / Excluding Control for BV Selection Criteria
     */
    @SerializedName( "BusVolFldCombnAllwdSign" )
    @JsonProperty( "BusVolFldCombnAllwdSign" )
    @Nullable
    @ODataField( odataName = "BusVolFldCombnAllwdSign" )
    private String busVolFldCombnAllwdSign;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnAllwdSign</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<String> BUS_VOL_FLD_COMBN_ALLWD_SIGN =
        new BusVolFldCombnSetTypeAssgmtField<String>("BusVolFldCombnAllwdSign");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnValdtyIsAllwd</b>
     * </p>
     *
     * @return Business Volume Base with Validity
     */
    @SerializedName( "BusVolFldCombnValdtyIsAllwd" )
    @JsonProperty( "BusVolFldCombnValdtyIsAllwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusVolFldCombnValdtyIsAllwd" )
    private Boolean busVolFldCombnValdtyIsAllwd;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnValdtyIsAllwd</b> field to query operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtField<Boolean> BUS_VOL_FLD_COMBN_VALDTY_IS_ALLWD =
        new BusVolFldCombnSetTypeAssgmtField<Boolean>("BusVolFldCombnValdtyIsAllwd");
    /**
     * Navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b> for <b>BusVolFldCombnSetTypeAssgmt</b> to multiple
     * <b>BusVolFldCombnTypeFldAssgmt</b>.
     *
     */
    @SerializedName( "to_BusVolFldCombnTypeFldAssgmt" )
    @JsonProperty( "to_BusVolFldCombnTypeFldAssgmt" )
    @ODataField( odataName = "to_BusVolFldCombnTypeFldAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusVolFldCombnTypeFldAssgmt> toBusVolFldCombnTypeFldAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>to_BusVolFldCombnTypeFldAssgmt</b> navigation property to query
     * operations.
     *
     */
    public final static BusVolFldCombnSetTypeAssgmtLink<BusVolFldCombnTypeFldAssgmt> TO_BUS_VOL_FLD_COMBN_TYPE_FLD_ASSGMT =
        new BusVolFldCombnSetTypeAssgmtLink<BusVolFldCombnTypeFldAssgmt>("to_BusVolFldCombnTypeFldAssgmt");

    @Nonnull
    @Override
    public Class<BusVolFldCombnSetTypeAssgmt> getType()
    {
        return BusVolFldCombnSetTypeAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrType</b>
     * </p>
     *
     * @param cndnContrType
     *            Condition Contract Type
     */
    public void setCndnContrType( @Nullable final String cndnContrType )
    {
        rememberChangedField("CndnContrType", this.cndnContrType);
        this.cndnContrType = cndnContrType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnSet</b>
     * </p>
     *
     * @param busVolFldCombnSet
     *            Set of Field Combinations
     */
    public void setBusVolFldCombnSet( @Nullable final String busVolFldCombnSet )
    {
        rememberChangedField("BusVolFldCombnSet", this.busVolFldCombnSet);
        this.busVolFldCombnSet = busVolFldCombnSet;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFieldCombnType</b>
     * </p>
     *
     * @param busVolFieldCombnType
     *            Field Combination for Business Volume Selection
     */
    public void setBusVolFieldCombnType( @Nullable final String busVolFieldCombnType )
    {
        rememberChangedField("BusVolFieldCombnType", this.busVolFieldCombnType);
        this.busVolFieldCombnType = busVolFieldCombnType;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnMinNrOfEntries</b>
     * </p>
     *
     * @param busVolFldCombnMinNrOfEntries
     *            Minimum Number of Entries for Field Combination
     */
    public void setBusVolFldCombnMinNrOfEntries( @Nullable final BigDecimal busVolFldCombnMinNrOfEntries )
    {
        rememberChangedField("BusVolFldCombnMinNrOfEntries", this.busVolFldCombnMinNrOfEntries);
        this.busVolFldCombnMinNrOfEntries = busVolFldCombnMinNrOfEntries;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnMaxNrOfEntries</b>
     * </p>
     *
     * @param busVolFldCombnMaxNrOfEntries
     *            Maximum Number of Entries for Field Combination
     */
    public void setBusVolFldCombnMaxNrOfEntries( @Nullable final BigDecimal busVolFldCombnMaxNrOfEntries )
    {
        rememberChangedField("BusVolFldCombnMaxNrOfEntries", this.busVolFldCombnMaxNrOfEntries);
        this.busVolFldCombnMaxNrOfEntries = busVolFldCombnMaxNrOfEntries;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnGroup</b>
     * </p>
     *
     * @param busVolFldCombnGroup
     *            Field Combination Group for Business Volume Selection
     */
    public void setBusVolFldCombnGroup( @Nullable final String busVolFldCombnGroup )
    {
        rememberChangedField("BusVolFldCombnGroup", this.busVolFldCombnGroup);
        this.busVolFldCombnGroup = busVolFldCombnGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnAllwdSign</b>
     * </p>
     *
     * @param busVolFldCombnAllwdSign
     *            Including / Excluding Control for BV Selection Criteria
     */
    public void setBusVolFldCombnAllwdSign( @Nullable final String busVolFldCombnAllwdSign )
    {
        rememberChangedField("BusVolFldCombnAllwdSign", this.busVolFldCombnAllwdSign);
        this.busVolFldCombnAllwdSign = busVolFldCombnAllwdSign;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnValdtyIsAllwd</b>
     * </p>
     *
     * @param busVolFldCombnValdtyIsAllwd
     *            Business Volume Base with Validity
     */
    public void setBusVolFldCombnValdtyIsAllwd( @Nullable final Boolean busVolFldCombnValdtyIsAllwd )
    {
        rememberChangedField("BusVolFldCombnValdtyIsAllwd", this.busVolFldCombnValdtyIsAllwd);
        this.busVolFldCombnValdtyIsAllwd = busVolFldCombnValdtyIsAllwd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusVolFldCombnSetTypeAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CndnContrType", getCndnContrType());
        result.put("BusVolFldCombnSet", getBusVolFldCombnSet());
        result.put("BusVolFieldCombnType", getBusVolFieldCombnType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CndnContrType", getCndnContrType());
        values.put("BusVolFldCombnSet", getBusVolFldCombnSet());
        values.put("BusVolFieldCombnType", getBusVolFieldCombnType());
        values.put("BusVolFldCombnMinNrOfEntries", getBusVolFldCombnMinNrOfEntries());
        values.put("BusVolFldCombnMaxNrOfEntries", getBusVolFldCombnMaxNrOfEntries());
        values.put("BusVolFldCombnGroup", getBusVolFldCombnGroup());
        values.put("BusVolFldCombnAllwdSign", getBusVolFldCombnAllwdSign());
        values.put("BusVolFldCombnValdtyIsAllwd", getBusVolFldCombnValdtyIsAllwd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CndnContrType") ) {
                final Object value = values.remove("CndnContrType");
                if( (value == null) || (!value.equals(getCndnContrType())) ) {
                    setCndnContrType(((String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnSet") ) {
                final Object value = values.remove("BusVolFldCombnSet");
                if( (value == null) || (!value.equals(getBusVolFldCombnSet())) ) {
                    setBusVolFldCombnSet(((String) value));
                }
            }
            if( values.containsKey("BusVolFieldCombnType") ) {
                final Object value = values.remove("BusVolFieldCombnType");
                if( (value == null) || (!value.equals(getBusVolFieldCombnType())) ) {
                    setBusVolFieldCombnType(((String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnMinNrOfEntries") ) {
                final Object value = values.remove("BusVolFldCombnMinNrOfEntries");
                if( (value == null) || (!value.equals(getBusVolFldCombnMinNrOfEntries())) ) {
                    setBusVolFldCombnMinNrOfEntries(((BigDecimal) value));
                }
            }
            if( values.containsKey("BusVolFldCombnMaxNrOfEntries") ) {
                final Object value = values.remove("BusVolFldCombnMaxNrOfEntries");
                if( (value == null) || (!value.equals(getBusVolFldCombnMaxNrOfEntries())) ) {
                    setBusVolFldCombnMaxNrOfEntries(((BigDecimal) value));
                }
            }
            if( values.containsKey("BusVolFldCombnGroup") ) {
                final Object value = values.remove("BusVolFldCombnGroup");
                if( (value == null) || (!value.equals(getBusVolFldCombnGroup())) ) {
                    setBusVolFldCombnGroup(((String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnAllwdSign") ) {
                final Object value = values.remove("BusVolFldCombnAllwdSign");
                if( (value == null) || (!value.equals(getBusVolFldCombnAllwdSign())) ) {
                    setBusVolFldCombnAllwdSign(((String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnValdtyIsAllwd") ) {
                final Object value = values.remove("BusVolFldCombnValdtyIsAllwd");
                if( (value == null) || (!value.equals(getBusVolFldCombnValdtyIsAllwd())) ) {
                    setBusVolFldCombnValdtyIsAllwd(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusVolFldCombnTypeFldAssgmt") ) {
                final Object value = (values).remove("to_BusVolFldCombnTypeFldAssgmt");
                if( value instanceof Iterable ) {
                    if( toBusVolFldCombnTypeFldAssgmt == null ) {
                        toBusVolFldCombnTypeFldAssgmt = Lists.newArrayList();
                    } else {
                        toBusVolFldCombnTypeFldAssgmt = Lists.newArrayList(toBusVolFldCombnTypeFldAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusVolFldCombnTypeFldAssgmt entity;
                        if( toBusVolFldCombnTypeFldAssgmt.size() > i ) {
                            entity = toBusVolFldCombnTypeFldAssgmt.get(i);
                        } else {
                            entity = new BusVolFldCombnTypeFldAssgmt();
                            toBusVolFldCombnTypeFldAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusVolFldCombnSetTypeAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusVolFldCombnSetTypeAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusVolFldCombnSetTypeAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusVolFldCombnSetTypeAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusVolFldCombnTypeFldAssgmt != null ) {
            (values).put("to_BusVolFldCombnTypeFldAssgmt", toBusVolFldCombnTypeFldAssgmt);
        }
        return values;
    }

    /**
     * Fetches the <b>BusVolFldCombnTypeFldAssgmt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusVolFldCombnTypeFldAssgmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusVolFldCombnTypeFldAssgmt> fetchBusVolFldCombnTypeFldAssgmt()
    {
        return fetchFieldAsList("to_BusVolFldCombnTypeFldAssgmt", BusVolFldCombnTypeFldAssgmt.class);
    }

    /**
     * Retrieval of associated <b>BusVolFldCombnTypeFldAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b>.
     * <p>
     * If the navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b> of a queried <b>BusVolFldCombnSetTypeAssgmt</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusVolFldCombnTypeFldAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusVolFldCombnTypeFldAssgmt> getBusVolFldCombnTypeFldAssgmtOrFetch()
    {
        if( toBusVolFldCombnTypeFldAssgmt == null ) {
            toBusVolFldCombnTypeFldAssgmt = fetchBusVolFldCombnTypeFldAssgmt();
        }
        return toBusVolFldCombnTypeFldAssgmt;
    }

    /**
     * Retrieval of associated <b>BusVolFldCombnTypeFldAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>BusVolFldCombnSetTypeAssgmt</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b> is already loaded, the
     *         result will contain the <b>BusVolFldCombnTypeFldAssgmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusVolFldCombnTypeFldAssgmt>> getBusVolFldCombnTypeFldAssgmtIfPresent()
    {
        return Option.of(toBusVolFldCombnTypeFldAssgmt);
    }

    /**
     * Overwrites the list of associated <b>BusVolFldCombnTypeFldAssgmt</b> entities for the loaded navigation property
     * <b>to_BusVolFldCombnTypeFldAssgmt</b>.
     * <p>
     * If the navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b> of a queried <b>BusVolFldCombnSetTypeAssgmt</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusVolFldCombnTypeFldAssgmt</b> entities.
     */
    public void setBusVolFldCombnTypeFldAssgmt( @Nonnull final List<BusVolFldCombnTypeFldAssgmt> value )
    {
        if( toBusVolFldCombnTypeFldAssgmt == null ) {
            toBusVolFldCombnTypeFldAssgmt = Lists.newArrayList();
        }
        toBusVolFldCombnTypeFldAssgmt.clear();
        toBusVolFldCombnTypeFldAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusVolFldCombnTypeFldAssgmt</b> entities. This corresponds to the
     * OData navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b>.
     * <p>
     * If the navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b> of a queried <b>BusVolFldCombnSetTypeAssgmt</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusVolFldCombnTypeFldAssgmt</b> entities.
     */
    public void addBusVolFldCombnTypeFldAssgmt( BusVolFldCombnTypeFldAssgmt... entity )
    {
        if( toBusVolFldCombnTypeFldAssgmt == null ) {
            toBusVolFldCombnTypeFldAssgmt = Lists.newArrayList();
        }
        toBusVolFldCombnTypeFldAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusVolFldCombnSetTypeAssgmt instances.
     *
     */
    public final static class BusVolFldCombnSetTypeAssgmtBuilder
    {

        private List<BusVolFldCombnTypeFldAssgmt> toBusVolFldCombnTypeFldAssgmt = Lists.newArrayList();

        private BusVolFldCombnSetTypeAssgmt.BusVolFldCombnSetTypeAssgmtBuilder toBusVolFldCombnTypeFldAssgmt(
            final List<BusVolFldCombnTypeFldAssgmt> value )
        {
            toBusVolFldCombnTypeFldAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusVolFldCombnTypeFldAssgmt</b> for <b>BusVolFldCombnSetTypeAssgmt</b> to multiple
         * <b>BusVolFldCombnTypeFldAssgmt</b>.
         *
         * @param value
         *            The BusVolFldCombnTypeFldAssgmts to build this BusVolFldCombnSetTypeAssgmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusVolFldCombnSetTypeAssgmt.BusVolFldCombnSetTypeAssgmtBuilder busVolFldCombnTypeFldAssgmt(
            BusVolFldCombnTypeFldAssgmt... value )
        {
            return toBusVolFldCombnTypeFldAssgmt(Lists.newArrayList(value));
        }

    }

}
