/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.selectable.BusVolFldCombnSetTypeAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt
 * BusVolFldCombnSetTypeAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BusVolFldCombnSetTypeAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<BusVolFldCombnSetTypeAssgmtByKeyFluentHelper, BusVolFldCombnSetTypeAssgmt, BusVolFldCombnSetTypeAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt
     * BusVolFldCombnSetTypeAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param busVolFldCombnSet
     *            Set of Field Combinations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusVolFldCombnSetTypeAssgmt}
     * @param busVolFieldCombnType
     *            Field Combination for Business Volume Selection
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusVolFldCombnSetTypeAssgmt}
     * @param cndnContrType
     *            Condition Contract Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public BusVolFldCombnSetTypeAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String cndnContrType,
        final String busVolFldCombnSet,
        final String busVolFieldCombnType )
    {
        super(servicePath, entityCollection);
        this.key.put("CndnContrType", cndnContrType);
        this.key.put("BusVolFldCombnSet", busVolFldCombnSet);
        this.key.put("BusVolFieldCombnType", busVolFieldCombnType);
    }

    @Override
    @Nonnull
    protected Class<BusVolFldCombnSetTypeAssgmt> getEntityClass()
    {
        return BusVolFldCombnSetTypeAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
