/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.field.BusVolFldCombnTypeFldAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.selectable.BusVolFldCombnTypeFldAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Field Assignment to Combination Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusVolFldCombnTypeFldAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusVolFldCombnTypeFldAssgmt extends VdmEntity<BusVolFldCombnTypeFldAssgmt>
{

    /**
     * Selector for all available fields of BusVolFldCombnTypeFldAssgmt.
     *
     */
    public final static BusVolFldCombnTypeFldAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFieldCombnType</b>
     * </p>
     *
     * @return Field Combination for Business Volume Selection
     */
    @Key
    @SerializedName( "BusVolFieldCombnType" )
    @JsonProperty( "BusVolFieldCombnType" )
    @Nullable
    @ODataField( odataName = "BusVolFieldCombnType" )
    private String busVolFieldCombnType;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFieldCombnType</b> field to query operations.
     *
     */
    public final static BusVolFldCombnTypeFldAssgmtField<String> BUS_VOL_FIELD_COMBN_TYPE =
        new BusVolFldCombnTypeFldAssgmtField<String>("BusVolFieldCombnType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnExtFieldName</b>
     * </p>
     *
     * @return External Field Name (GFN)
     */
    @Key
    @SerializedName( "BusVolFldCombnExtFieldName" )
    @JsonProperty( "BusVolFldCombnExtFieldName" )
    @Nullable
    @ODataField( odataName = "BusVolFldCombnExtFieldName" )
    private String busVolFldCombnExtFieldName;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnExtFieldName</b> field to query operations.
     *
     */
    public final static BusVolFldCombnTypeFldAssgmtField<String> BUS_VOL_FLD_COMBN_EXT_FIELD_NAME =
        new BusVolFldCombnTypeFldAssgmtField<String>("BusVolFldCombnExtFieldName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnFldInitIsAllwd</b>
     * </p>
     *
     * @return Initial Values allowed
     */
    @SerializedName( "BusVolFldCombnFldInitIsAllwd" )
    @JsonProperty( "BusVolFldCombnFldInitIsAllwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusVolFldCombnFldInitIsAllwd" )
    private Boolean busVolFldCombnFldInitIsAllwd;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnFldInitIsAllwd</b> field to query operations.
     *
     */
    public final static BusVolFldCombnTypeFldAssgmtField<Boolean> BUS_VOL_FLD_COMBN_FLD_INIT_IS_ALLWD =
        new BusVolFldCombnTypeFldAssgmtField<Boolean>("BusVolFldCombnFldInitIsAllwd");

    @Nonnull
    @Override
    public Class<BusVolFldCombnTypeFldAssgmt> getType()
    {
        return BusVolFldCombnTypeFldAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFieldCombnType</b>
     * </p>
     *
     * @param busVolFieldCombnType
     *            Field Combination for Business Volume Selection
     */
    public void setBusVolFieldCombnType( @Nullable final String busVolFieldCombnType )
    {
        rememberChangedField("BusVolFieldCombnType", this.busVolFieldCombnType);
        this.busVolFieldCombnType = busVolFieldCombnType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnExtFieldName</b>
     * </p>
     *
     * @param busVolFldCombnExtFieldName
     *            External Field Name (GFN)
     */
    public void setBusVolFldCombnExtFieldName( @Nullable final String busVolFldCombnExtFieldName )
    {
        rememberChangedField("BusVolFldCombnExtFieldName", this.busVolFldCombnExtFieldName);
        this.busVolFldCombnExtFieldName = busVolFldCombnExtFieldName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnFldInitIsAllwd</b>
     * </p>
     *
     * @param busVolFldCombnFldInitIsAllwd
     *            Initial Values allowed
     */
    public void setBusVolFldCombnFldInitIsAllwd( @Nullable final Boolean busVolFldCombnFldInitIsAllwd )
    {
        rememberChangedField("BusVolFldCombnFldInitIsAllwd", this.busVolFldCombnFldInitIsAllwd);
        this.busVolFldCombnFldInitIsAllwd = busVolFldCombnFldInitIsAllwd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusVolFldCombnTypeFldAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusVolFieldCombnType", getBusVolFieldCombnType());
        result.put("BusVolFldCombnExtFieldName", getBusVolFldCombnExtFieldName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusVolFieldCombnType", getBusVolFieldCombnType());
        values.put("BusVolFldCombnExtFieldName", getBusVolFldCombnExtFieldName());
        values.put("BusVolFldCombnFldInitIsAllwd", getBusVolFldCombnFldInitIsAllwd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusVolFieldCombnType") ) {
                final Object value = values.remove("BusVolFieldCombnType");
                if( (value == null) || (!value.equals(getBusVolFieldCombnType())) ) {
                    setBusVolFieldCombnType(((String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnExtFieldName") ) {
                final Object value = values.remove("BusVolFldCombnExtFieldName");
                if( (value == null) || (!value.equals(getBusVolFldCombnExtFieldName())) ) {
                    setBusVolFldCombnExtFieldName(((String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnFldInitIsAllwd") ) {
                final Object value = values.remove("BusVolFldCombnFldInitIsAllwd");
                if( (value == null) || (!value.equals(getBusVolFldCombnFldInitIsAllwd())) ) {
                    setBusVolFldCombnFldInitIsAllwd(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusVolFldCombnTypeFldAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusVolFldCombnTypeFldAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusVolFldCombnTypeFldAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusVolFldCombnTypeFldAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService.DEFAULT_SERVICE_PATH);
    }

}
