/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.field.CndnContrTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.link.CndnContrTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.selectable.CndnContrTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Contract Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CndnContrTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CndnContrType extends VdmEntity<CndnContrType>
{

    /**
     * Selector for all available fields of CndnContrType.
     *
     */
    public final static CndnContrTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrType</b>
     * </p>
     *
     * @return Condition Contract Type
     */
    @Key
    @SerializedName( "CndnContrType" )
    @JsonProperty( "CndnContrType" )
    @Nullable
    @ODataField( odataName = "CndnContrType" )
    private String cndnContrType;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrType</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_TYPE = new CndnContrTypeField<String>("CndnContrType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnSet</b>
     * </p>
     *
     * @return Set of Field Combinations
     */
    @SerializedName( "BusVolFldCombnSet" )
    @JsonProperty( "BusVolFldCombnSet" )
    @Nullable
    @ODataField( odataName = "BusVolFldCombnSet" )
    private String busVolFldCombnSet;
    /**
     * Use with available fluent helpers to apply the <b>BusVolFldCombnSet</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> BUS_VOL_FLD_COMBN_SET =
        new CndnContrTypeField<String>("BusVolFldCombnSet");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrTypeBlockUsage</b>
     * </p>
     *
     * @return Condition Contract Type Block
     */
    @SerializedName( "CndnContrTypeBlockUsage" )
    @JsonProperty( "CndnContrTypeBlockUsage" )
    @Nullable
    @ODataField( odataName = "CndnContrTypeBlockUsage" )
    private String cndnContrTypeBlockUsage;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrTypeBlockUsage</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_TYPE_BLOCK_USAGE =
        new CndnContrTypeField<String>("CndnContrTypeBlockUsage");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPartnerCat</b>
     * </p>
     *
     * @return Type of Business Partner for Condition Contract
     */
    @SerializedName( "CndnContrPartnerCat" )
    @JsonProperty( "CndnContrPartnerCat" )
    @Nullable
    @ODataField( odataName = "CndnContrPartnerCat" )
    private String cndnContrPartnerCat;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrPartnerCat</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_PARTNER_CAT =
        new CndnContrTypeField<String>("CndnContrPartnerCat");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrEligibleCat</b>
     * </p>
     *
     * @return Type of Eligible Partner for a Condition Contract
     */
    @SerializedName( "CndnContrEligibleCat" )
    @JsonProperty( "CndnContrEligibleCat" )
    @Nullable
    @ODataField( odataName = "CndnContrEligibleCat" )
    private String cndnContrEligibleCat;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrEligibleCat</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_ELIGIBLE_CAT =
        new CndnContrTypeField<String>("CndnContrEligibleCat");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrClassfctnType</b>
     * </p>
     *
     * @return Condition Contract Category
     */
    @SerializedName( "CndnContrClassfctnType" )
    @JsonProperty( "CndnContrClassfctnType" )
    @Nullable
    @ODataField( odataName = "CndnContrClassfctnType" )
    private String cndnContrClassfctnType;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrClassfctnType</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_CLASSFCTN_TYPE =
        new CndnContrTypeField<String>("CndnContrClassfctnType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrHasNoConditions</b>
     * </p>
     *
     * @return Hide Conditions Area in Condition Contract Maintenance
     */
    @SerializedName( "CndnContrHasNoConditions" )
    @JsonProperty( "CndnContrHasNoConditions" )
    @Nullable
    @ODataField( odataName = "CndnContrHasNoConditions" )
    private String cndnContrHasNoConditions;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrHasNoConditions</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_HAS_NO_CONDITIONS =
        new CndnContrTypeField<String>("CndnContrHasNoConditions");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSettlmtType</b>
     * </p>
     *
     * @return Conditon Contract Settlement Type
     */
    @SerializedName( "CndnContrSettlmtType" )
    @JsonProperty( "CndnContrSettlmtType" )
    @Nullable
    @ODataField( odataName = "CndnContrSettlmtType" )
    private String cndnContrSettlmtType;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrSettlmtType</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_SETTLMT_TYPE =
        new CndnContrTypeField<String>("CndnContrSettlmtType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrChangeability</b>
     * </p>
     *
     * @return Control for Changes on the User Interface
     */
    @SerializedName( "CndnContrChangeability" )
    @JsonProperty( "CndnContrChangeability" )
    @Nullable
    @ODataField( odataName = "CndnContrChangeability" )
    private String cndnContrChangeability;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrChangeability</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_CHANGEABILITY =
        new CndnContrTypeField<String>("CndnContrChangeability");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPrtlSettlmtCat</b>
     * </p>
     *
     * @return Condition Contract Settlement: Partial Settlement Type
     */
    @SerializedName( "CndnContrPrtlSettlmtCat" )
    @JsonProperty( "CndnContrPrtlSettlmtCat" )
    @Nullable
    @ODataField( odataName = "CndnContrPrtlSettlmtCat" )
    private String cndnContrPrtlSettlmtCat;
    /**
     * Use with available fluent helpers to apply the <b>CndnContrPrtlSettlmtCat</b> field to query operations.
     *
     */
    public final static CndnContrTypeField<String> CNDN_CONTR_PRTL_SETTLMT_CAT =
        new CndnContrTypeField<String>("CndnContrPrtlSettlmtCat");
    /**
     * Navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b> for <b>CndnContrType</b> to multiple
     * <b>BusVolFldCombnSetTypeAssgmt</b>.
     *
     */
    @SerializedName( "to_BusVolFldCombnSetTypeAssgmt" )
    @JsonProperty( "to_BusVolFldCombnSetTypeAssgmt" )
    @ODataField( odataName = "to_BusVolFldCombnSetTypeAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusVolFldCombnSetTypeAssgmt> toBusVolFldCombnSetTypeAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>to_BusVolFldCombnSetTypeAssgmt</b> navigation property to query
     * operations.
     *
     */
    public final static CndnContrTypeLink<BusVolFldCombnSetTypeAssgmt> TO_BUS_VOL_FLD_COMBN_SET_TYPE_ASSGMT =
        new CndnContrTypeLink<BusVolFldCombnSetTypeAssgmt>("to_BusVolFldCombnSetTypeAssgmt");

    @Nonnull
    @Override
    public Class<CndnContrType> getType()
    {
        return CndnContrType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrType</b>
     * </p>
     *
     * @param cndnContrType
     *            Condition Contract Type
     */
    public void setCndnContrType( @Nullable final String cndnContrType )
    {
        rememberChangedField("CndnContrType", this.cndnContrType);
        this.cndnContrType = cndnContrType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnSet</b>
     * </p>
     *
     * @param busVolFldCombnSet
     *            Set of Field Combinations
     */
    public void setBusVolFldCombnSet( @Nullable final String busVolFldCombnSet )
    {
        rememberChangedField("BusVolFldCombnSet", this.busVolFldCombnSet);
        this.busVolFldCombnSet = busVolFldCombnSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrTypeBlockUsage</b>
     * </p>
     *
     * @param cndnContrTypeBlockUsage
     *            Condition Contract Type Block
     */
    public void setCndnContrTypeBlockUsage( @Nullable final String cndnContrTypeBlockUsage )
    {
        rememberChangedField("CndnContrTypeBlockUsage", this.cndnContrTypeBlockUsage);
        this.cndnContrTypeBlockUsage = cndnContrTypeBlockUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPartnerCat</b>
     * </p>
     *
     * @param cndnContrPartnerCat
     *            Type of Business Partner for Condition Contract
     */
    public void setCndnContrPartnerCat( @Nullable final String cndnContrPartnerCat )
    {
        rememberChangedField("CndnContrPartnerCat", this.cndnContrPartnerCat);
        this.cndnContrPartnerCat = cndnContrPartnerCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrEligibleCat</b>
     * </p>
     *
     * @param cndnContrEligibleCat
     *            Type of Eligible Partner for a Condition Contract
     */
    public void setCndnContrEligibleCat( @Nullable final String cndnContrEligibleCat )
    {
        rememberChangedField("CndnContrEligibleCat", this.cndnContrEligibleCat);
        this.cndnContrEligibleCat = cndnContrEligibleCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrClassfctnType</b>
     * </p>
     *
     * @param cndnContrClassfctnType
     *            Condition Contract Category
     */
    public void setCndnContrClassfctnType( @Nullable final String cndnContrClassfctnType )
    {
        rememberChangedField("CndnContrClassfctnType", this.cndnContrClassfctnType);
        this.cndnContrClassfctnType = cndnContrClassfctnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrHasNoConditions</b>
     * </p>
     *
     * @param cndnContrHasNoConditions
     *            Hide Conditions Area in Condition Contract Maintenance
     */
    public void setCndnContrHasNoConditions( @Nullable final String cndnContrHasNoConditions )
    {
        rememberChangedField("CndnContrHasNoConditions", this.cndnContrHasNoConditions);
        this.cndnContrHasNoConditions = cndnContrHasNoConditions;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSettlmtType</b>
     * </p>
     *
     * @param cndnContrSettlmtType
     *            Conditon Contract Settlement Type
     */
    public void setCndnContrSettlmtType( @Nullable final String cndnContrSettlmtType )
    {
        rememberChangedField("CndnContrSettlmtType", this.cndnContrSettlmtType);
        this.cndnContrSettlmtType = cndnContrSettlmtType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrChangeability</b>
     * </p>
     *
     * @param cndnContrChangeability
     *            Control for Changes on the User Interface
     */
    public void setCndnContrChangeability( @Nullable final String cndnContrChangeability )
    {
        rememberChangedField("CndnContrChangeability", this.cndnContrChangeability);
        this.cndnContrChangeability = cndnContrChangeability;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPrtlSettlmtCat</b>
     * </p>
     *
     * @param cndnContrPrtlSettlmtCat
     *            Condition Contract Settlement: Partial Settlement Type
     */
    public void setCndnContrPrtlSettlmtCat( @Nullable final String cndnContrPrtlSettlmtCat )
    {
        rememberChangedField("CndnContrPrtlSettlmtCat", this.cndnContrPrtlSettlmtCat);
        this.cndnContrPrtlSettlmtCat = cndnContrPrtlSettlmtCat;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CndnContrType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CndnContrType", getCndnContrType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CndnContrType", getCndnContrType());
        values.put("BusVolFldCombnSet", getBusVolFldCombnSet());
        values.put("CndnContrTypeBlockUsage", getCndnContrTypeBlockUsage());
        values.put("CndnContrPartnerCat", getCndnContrPartnerCat());
        values.put("CndnContrEligibleCat", getCndnContrEligibleCat());
        values.put("CndnContrClassfctnType", getCndnContrClassfctnType());
        values.put("CndnContrHasNoConditions", getCndnContrHasNoConditions());
        values.put("CndnContrSettlmtType", getCndnContrSettlmtType());
        values.put("CndnContrChangeability", getCndnContrChangeability());
        values.put("CndnContrPrtlSettlmtCat", getCndnContrPrtlSettlmtCat());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CndnContrType") ) {
                final Object value = values.remove("CndnContrType");
                if( (value == null) || (!value.equals(getCndnContrType())) ) {
                    setCndnContrType(((String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnSet") ) {
                final Object value = values.remove("BusVolFldCombnSet");
                if( (value == null) || (!value.equals(getBusVolFldCombnSet())) ) {
                    setBusVolFldCombnSet(((String) value));
                }
            }
            if( values.containsKey("CndnContrTypeBlockUsage") ) {
                final Object value = values.remove("CndnContrTypeBlockUsage");
                if( (value == null) || (!value.equals(getCndnContrTypeBlockUsage())) ) {
                    setCndnContrTypeBlockUsage(((String) value));
                }
            }
            if( values.containsKey("CndnContrPartnerCat") ) {
                final Object value = values.remove("CndnContrPartnerCat");
                if( (value == null) || (!value.equals(getCndnContrPartnerCat())) ) {
                    setCndnContrPartnerCat(((String) value));
                }
            }
            if( values.containsKey("CndnContrEligibleCat") ) {
                final Object value = values.remove("CndnContrEligibleCat");
                if( (value == null) || (!value.equals(getCndnContrEligibleCat())) ) {
                    setCndnContrEligibleCat(((String) value));
                }
            }
            if( values.containsKey("CndnContrClassfctnType") ) {
                final Object value = values.remove("CndnContrClassfctnType");
                if( (value == null) || (!value.equals(getCndnContrClassfctnType())) ) {
                    setCndnContrClassfctnType(((String) value));
                }
            }
            if( values.containsKey("CndnContrHasNoConditions") ) {
                final Object value = values.remove("CndnContrHasNoConditions");
                if( (value == null) || (!value.equals(getCndnContrHasNoConditions())) ) {
                    setCndnContrHasNoConditions(((String) value));
                }
            }
            if( values.containsKey("CndnContrSettlmtType") ) {
                final Object value = values.remove("CndnContrSettlmtType");
                if( (value == null) || (!value.equals(getCndnContrSettlmtType())) ) {
                    setCndnContrSettlmtType(((String) value));
                }
            }
            if( values.containsKey("CndnContrChangeability") ) {
                final Object value = values.remove("CndnContrChangeability");
                if( (value == null) || (!value.equals(getCndnContrChangeability())) ) {
                    setCndnContrChangeability(((String) value));
                }
            }
            if( values.containsKey("CndnContrPrtlSettlmtCat") ) {
                final Object value = values.remove("CndnContrPrtlSettlmtCat");
                if( (value == null) || (!value.equals(getCndnContrPrtlSettlmtCat())) ) {
                    setCndnContrPrtlSettlmtCat(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusVolFldCombnSetTypeAssgmt") ) {
                final Object value = (values).remove("to_BusVolFldCombnSetTypeAssgmt");
                if( value instanceof Iterable ) {
                    if( toBusVolFldCombnSetTypeAssgmt == null ) {
                        toBusVolFldCombnSetTypeAssgmt = Lists.newArrayList();
                    } else {
                        toBusVolFldCombnSetTypeAssgmt = Lists.newArrayList(toBusVolFldCombnSetTypeAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusVolFldCombnSetTypeAssgmt entity;
                        if( toBusVolFldCombnSetTypeAssgmt.size() > i ) {
                            entity = toBusVolFldCombnSetTypeAssgmt.get(i);
                        } else {
                            entity = new BusVolFldCombnSetTypeAssgmt();
                            toBusVolFldCombnSetTypeAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CndnContrTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CndnContrTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CndnContrTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CndnContrTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusVolFldCombnSetTypeAssgmt != null ) {
            (values).put("to_BusVolFldCombnSetTypeAssgmt", toBusVolFldCombnSetTypeAssgmt);
        }
        return values;
    }

    /**
     * Fetches the <b>BusVolFldCombnSetTypeAssgmt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusVolFldCombnSetTypeAssgmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusVolFldCombnSetTypeAssgmt> fetchBusVolFldCombnSetTypeAssgmt()
    {
        return fetchFieldAsList("to_BusVolFldCombnSetTypeAssgmt", BusVolFldCombnSetTypeAssgmt.class);
    }

    /**
     * Retrieval of associated <b>BusVolFldCombnSetTypeAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b> of a queried <b>CndnContrType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusVolFldCombnSetTypeAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusVolFldCombnSetTypeAssgmt> getBusVolFldCombnSetTypeAssgmtOrFetch()
    {
        if( toBusVolFldCombnSetTypeAssgmt == null ) {
            toBusVolFldCombnSetTypeAssgmt = fetchBusVolFldCombnSetTypeAssgmt();
        }
        return toBusVolFldCombnSetTypeAssgmt;
    }

    /**
     * Retrieval of associated <b>BusVolFldCombnSetTypeAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b> is already loaded, the
     *         result will contain the <b>BusVolFldCombnSetTypeAssgmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusVolFldCombnSetTypeAssgmt>> getBusVolFldCombnSetTypeAssgmtIfPresent()
    {
        return Option.of(toBusVolFldCombnSetTypeAssgmt);
    }

    /**
     * Overwrites the list of associated <b>BusVolFldCombnSetTypeAssgmt</b> entities for the loaded navigation property
     * <b>to_BusVolFldCombnSetTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b> of a queried <b>CndnContrType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusVolFldCombnSetTypeAssgmt</b> entities.
     */
    public void setBusVolFldCombnSetTypeAssgmt( @Nonnull final List<BusVolFldCombnSetTypeAssgmt> value )
    {
        if( toBusVolFldCombnSetTypeAssgmt == null ) {
            toBusVolFldCombnSetTypeAssgmt = Lists.newArrayList();
        }
        toBusVolFldCombnSetTypeAssgmt.clear();
        toBusVolFldCombnSetTypeAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusVolFldCombnSetTypeAssgmt</b> entities. This corresponds to the
     * OData navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b> of a queried <b>CndnContrType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusVolFldCombnSetTypeAssgmt</b> entities.
     */
    public void addBusVolFldCombnSetTypeAssgmt( BusVolFldCombnSetTypeAssgmt... entity )
    {
        if( toBusVolFldCombnSetTypeAssgmt == null ) {
            toBusVolFldCombnSetTypeAssgmt = Lists.newArrayList();
        }
        toBusVolFldCombnSetTypeAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CndnContrType instances.
     *
     */
    public final static class CndnContrTypeBuilder
    {

        private List<BusVolFldCombnSetTypeAssgmt> toBusVolFldCombnSetTypeAssgmt = Lists.newArrayList();

        private CndnContrType.CndnContrTypeBuilder toBusVolFldCombnSetTypeAssgmt(
            final List<BusVolFldCombnSetTypeAssgmt> value )
        {
            toBusVolFldCombnSetTypeAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusVolFldCombnSetTypeAssgmt</b> for <b>CndnContrType</b> to multiple
         * <b>BusVolFldCombnSetTypeAssgmt</b>.
         *
         * @param value
         *            The BusVolFldCombnSetTypeAssgmts to build this CndnContrType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrType.CndnContrTypeBuilder busVolFldCombnSetTypeAssgmt( BusVolFldCombnSetTypeAssgmt... value )
        {
            return toBusVolFldCombnSetTypeAssgmt(Lists.newArrayList(value));
        }

    }

}
