/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ConditionContractTypeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService ConditionContractTypeService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultConditionContractTypeServiceBatch
    extends
    BatchFluentHelperBasic<ConditionContractTypeServiceBatch, ConditionContractTypeServiceBatchChangeSet>
    implements
    ConditionContractTypeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultConditionContractTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultConditionContractTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultConditionContractTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultConditionContractTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultConditionContractTypeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ConditionContractTypeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultConditionContractTypeServiceBatchChangeSet(this, service);
    }

}
