/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ConditionContractTypeServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService ConditionContractTypeService}.
 *
 */
public class DefaultConditionContractTypeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ConditionContractTypeServiceBatch, ConditionContractTypeServiceBatchChangeSet>
    implements
    ConditionContractTypeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService service;

    @SuppressWarnings( "deprecation" )
    DefaultConditionContractTypeServiceBatchChangeSet(
        @Nonnull final DefaultConditionContractTypeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionContractTypeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultConditionContractTypeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
