/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt
 * BusVolFldCombnSetTypeAssgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.field.BusVolFldCombnSetTypeAssgmtField
 * BusVolFldCombnSetTypeAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.link.BusVolFldCombnSetTypeAssgmtLink
 * BusVolFldCombnSetTypeAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#CNDN_CONTR_TYPE
 * CNDN_CONTR_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#BUS_VOL_FLD_COMBN_SET
 * BUS_VOL_FLD_COMBN_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#BUS_VOL_FIELD_COMBN_TYPE
 * BUS_VOL_FIELD_COMBN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#BUS_VOL_FLD_COMBN_MIN_NR_OF_ENTRIES
 * BUS_VOL_FLD_COMBN_MIN_NR_OF_ENTRIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#BUS_VOL_FLD_COMBN_MAX_NR_OF_ENTRIES
 * BUS_VOL_FLD_COMBN_MAX_NR_OF_ENTRIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#BUS_VOL_FLD_COMBN_GROUP
 * BUS_VOL_FLD_COMBN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#BUS_VOL_FLD_COMBN_ALLWD_SIGN
 * BUS_VOL_FLD_COMBN_ALLWD_SIGN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#BUS_VOL_FLD_COMBN_VALDTY_IS_ALLWD
 * BUS_VOL_FLD_COMBN_VALDTY_IS_ALLWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt#TO_BUS_VOL_FLD_COMBN_TYPE_FLD_ASSGMT
 * TO_BUS_VOL_FLD_COMBN_TYPE_FLD_ASSGMT}</li>
 * </ul>
 *
 */
public interface BusVolFldCombnSetTypeAssgmtSelectable extends EntitySelectable<BusVolFldCombnSetTypeAssgmt>
{

}
