/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnTypeFldAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnTypeFldAssgmt
 * BusVolFldCombnTypeFldAssgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.field.BusVolFldCombnTypeFldAssgmtField
 * BusVolFldCombnTypeFldAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.link.BusVolFldCombnTypeFldAssgmtLink
 * BusVolFldCombnTypeFldAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnTypeFldAssgmt#BUS_VOL_FIELD_COMBN_TYPE
 * BUS_VOL_FIELD_COMBN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnTypeFldAssgmt#BUS_VOL_FLD_COMBN_EXT_FIELD_NAME
 * BUS_VOL_FLD_COMBN_EXT_FIELD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnTypeFldAssgmt#BUS_VOL_FLD_COMBN_FLD_INIT_IS_ALLWD
 * BUS_VOL_FLD_COMBN_FLD_INIT_IS_ALLWD}</li>
 * </ul>
 *
 */
public interface BusVolFldCombnTypeFldAssgmtSelectable extends EntitySelectable<BusVolFldCombnTypeFldAssgmt>
{

}
