/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType CndnContrType}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.field.CndnContrTypeField
 * CndnContrTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.link.CndnContrTypeLink
 * CndnContrTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_TYPE
 * CNDN_CONTR_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#BUS_VOL_FLD_COMBN_SET
 * BUS_VOL_FLD_COMBN_SET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_TYPE_BLOCK_USAGE
 * CNDN_CONTR_TYPE_BLOCK_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_PARTNER_CAT
 * CNDN_CONTR_PARTNER_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_ELIGIBLE_CAT
 * CNDN_CONTR_ELIGIBLE_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_CLASSFCTN_TYPE
 * CNDN_CONTR_CLASSFCTN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_HAS_NO_CONDITIONS
 * CNDN_CONTR_HAS_NO_CONDITIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_SETTLMT_TYPE
 * CNDN_CONTR_SETTLMT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_CHANGEABILITY
 * CNDN_CONTR_CHANGEABILITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#CNDN_CONTR_PRTL_SETTLMT_CAT
 * CNDN_CONTR_PRTL_SETTLMT_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType#TO_BUS_VOL_FLD_COMBN_SET_TYPE_ASSGMT
 * TO_BUS_VOL_FLD_COMBN_SET_TYPE_ASSGMT}</li>
 * </ul>
 *
 */
public interface CndnContrTypeSelectable extends EntitySelectable<CndnContrType>
{

}
