/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.field.PurgPricingConditionTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.link.PurgPricingConditionTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.selectable.PurgPricingConditionTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Types
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgPricingConditionTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgPricingConditionType extends VdmEntity<PurgPricingConditionType>
{

    /**
     * Selector for all available fields of PurgPricingConditionType.
     *
     */
    public final static PurgPricingConditionTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @return Usage of the condition table
     */
    @Key
    @SerializedName( "ConditionUsage" )
    @JsonProperty( "ConditionUsage" )
    @Nullable
    @ODataField( odataName = "ConditionUsage" )
    private String conditionUsage;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUsage</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CONDITION_USAGE =
        new PurgPricingConditionTypeField<String>("ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @Key
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CONDITION_APPLICATION =
        new PurgPricingConditionTypeField<String>("ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @Key
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CONDITION_TYPE =
        new PurgPricingConditionTypeField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     *
     * @return Access sequence
     */
    @SerializedName( "AccessSequence" )
    @JsonProperty( "AccessSequence" )
    @Nullable
    @ODataField( odataName = "AccessSequence" )
    private String accessSequence;
    /**
     * Use with available fluent helpers to apply the <b>AccessSequence</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> ACCESS_SEQUENCE =
        new PurgPricingConditionTypeField<String>("AccessSequence");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "ConditionCalculationType" )
    @JsonProperty( "ConditionCalculationType" )
    @Nullable
    @ODataField( odataName = "ConditionCalculationType" )
    private String conditionCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCalculationType</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CONDITION_CALCULATION_TYPE =
        new PurgPricingConditionTypeField<String>("ConditionCalculationType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @return Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    @SerializedName( "ConditionCategory" )
    @JsonProperty( "ConditionCategory" )
    @Nullable
    @ODataField( odataName = "ConditionCategory" )
    private String conditionCategory;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCategory</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CONDITION_CATEGORY =
        new PurgPricingConditionTypeField<String>("ConditionCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @return Condition Class
     */
    @SerializedName( "ConditionClass" )
    @JsonProperty( "ConditionClass" )
    @Nullable
    @ODataField( odataName = "ConditionClass" )
    private String conditionClass;
    /**
     * Use with available fluent helpers to apply the <b>ConditionClass</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CONDITION_CLASS =
        new PurgPricingConditionTypeField<String>("ConditionClass");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAmountRoundingRule</b>
     * </p>
     *
     * @return Rounding Rule
     */
    @SerializedName( "PrcgCndnAmountRoundingRule" )
    @JsonProperty( "PrcgCndnAmountRoundingRule" )
    @Nullable
    @ODataField( odataName = "PrcgCndnAmountRoundingRule" )
    private String prcgCndnAmountRoundingRule;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnAmountRoundingRule</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRCG_CNDN_AMOUNT_ROUNDING_RULE =
        new PurgPricingConditionTypeField<String>("PrcgCndnAmountRoundingRule");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     *
     * @return Structure Condition
     */
    @SerializedName( "StructureCondition" )
    @JsonProperty( "StructureCondition" )
    @Nullable
    @ODataField( odataName = "StructureCondition" )
    private String structureCondition;
    /**
     * Use with available fluent helpers to apply the <b>StructureCondition</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> STRUCTURE_CONDITION =
        new PurgPricingConditionTypeField<String>("StructureCondition");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionAmountSign</b>
     * </p>
     *
     * @return Plus/Minus Sign of the condition Amount
     */
    @SerializedName( "PrcgConditionAmountSign" )
    @JsonProperty( "PrcgConditionAmountSign" )
    @Nullable
    @ODataField( odataName = "PrcgConditionAmountSign" )
    private String prcgConditionAmountSign;
    /**
     * Use with available fluent helpers to apply the <b>PrcgConditionAmountSign</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRCG_CONDITION_AMOUNT_SIGN =
        new PurgPricingConditionTypeField<String>("PrcgConditionAmountSign");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @return Group Condition
     */
    @SerializedName( "IsGroupCondition" )
    @JsonProperty( "IsGroupCondition" )
    @Nullable
    @ODataField( odataName = "IsGroupCondition" )
    private String isGroupCondition;
    /**
     * Use with available fluent helpers to apply the <b>IsGroupCondition</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> IS_GROUP_CONDITION =
        new PurgPricingConditionTypeField<String>("IsGroupCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnRndngDiffsIsSettled</b>
     * </p>
     *
     * @return Rounding Difference Comparison
     */
    @SerializedName( "PrcgCndnRndngDiffsIsSettled" )
    @JsonProperty( "PrcgCndnRndngDiffsIsSettled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PrcgCndnRndngDiffsIsSettled" )
    private Boolean prcgCndnRndngDiffsIsSettled;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnRndngDiffsIsSettled</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> PRCG_CNDN_RNDNG_DIFFS_IS_SETTLED =
        new PurgPricingConditionTypeField<Boolean>("PrcgCndnRndngDiffsIsSettled");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>PrcgGroupConditionRoutine</b>
     * </p>
     *
     * @return Routine Number for Creating Group Key
     */
    @SerializedName( "PrcgGroupConditionRoutine" )
    @JsonProperty( "PrcgGroupConditionRoutine" )
    @Nullable
    @ODataField( odataName = "PrcgGroupConditionRoutine" )
    private String prcgGroupConditionRoutine;
    /**
     * Use with available fluent helpers to apply the <b>PrcgGroupConditionRoutine</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRCG_GROUP_CONDITION_ROUTINE =
        new PurgPricingConditionTypeField<String>("PrcgGroupConditionRoutine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnManualEntries</b>
     * </p>
     *
     * @return Making Manual Entries
     */
    @SerializedName( "CndnManualEntries" )
    @JsonProperty( "CndnManualEntries" )
    @Nullable
    @ODataField( odataName = "CndnManualEntries" )
    private String cndnManualEntries;
    /**
     * Use with available fluent helpers to apply the <b>CndnManualEntries</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CNDN_MANUAL_ENTRIES =
        new PurgPricingConditionTypeField<String>("CndnManualEntries");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnAppliesHeader</b>
     * </p>
     *
     * @return Condition Applies to Header
     */
    @SerializedName( "CndnAppliesHeader" )
    @JsonProperty( "CndnAppliesHeader" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnAppliesHeader" )
    private Boolean cndnAppliesHeader;
    /**
     * Use with available fluent helpers to apply the <b>CndnAppliesHeader</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> CNDN_APPLIES_HEADER =
        new PurgPricingConditionTypeField<Boolean>("CndnAppliesHeader");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnAppliesItems</b>
     * </p>
     *
     * @return Condition Applies to Items
     */
    @SerializedName( "CndnAppliesItems" )
    @JsonProperty( "CndnAppliesItems" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnAppliesItems" )
    private Boolean cndnAppliesItems;
    /**
     * Use with available fluent helpers to apply the <b>CndnAppliesItems</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> CNDN_APPLIES_ITEMS =
        new PurgPricingConditionTypeField<Boolean>("CndnAppliesItems");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTypeDeletionIsAllowed</b>
     * </p>
     *
     * @return Delete the Scope for Changing Amount/Percentage
     */
    @SerializedName( "PrcgCndnTypeDeletionIsAllowed" )
    @JsonProperty( "PrcgCndnTypeDeletionIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PrcgCndnTypeDeletionIsAllowed" )
    private Boolean prcgCndnTypeDeletionIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnTypeDeletionIsAllowed</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> PRCG_CNDN_TYPE_DELETION_IS_ALLOWED =
        new PurgPricingConditionTypeField<Boolean>("PrcgCndnTypeDeletionIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAmountChangedIsAllowed</b>
     * </p>
     *
     * @return Change of Condition Amount/Percentage
     */
    @SerializedName( "PrcgCndnAmountChangedIsAllowed" )
    @JsonProperty( "PrcgCndnAmountChangedIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PrcgCndnAmountChangedIsAllowed" )
    private Boolean prcgCndnAmountChangedIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnAmountChangedIsAllowed</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> PRCG_CNDN_AMOUNT_CHANGED_IS_ALLOWED =
        new PurgPricingConditionTypeField<Boolean>("PrcgCndnAmountChangedIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnCnvrsnFctrChgIsAllowed</b>
     * </p>
     *
     * @return Scope for Changing Conversion Factors
     */
    @SerializedName( "PrcgCndnCnvrsnFctrChgIsAllowed" )
    @JsonProperty( "PrcgCndnCnvrsnFctrChgIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PrcgCndnCnvrsnFctrChgIsAllowed" )
    private Boolean prcgCndnCnvrsnFctrChgIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnCnvrsnFctrChgIsAllowed</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> PRCG_CNDN_CNVRSN_FCTR_CHG_IS_ALLOWED =
        new PurgPricingConditionTypeField<Boolean>("PrcgCndnCnvrsnFctrChgIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnValChgIsAllwd</b>
     * </p>
     *
     * @return Scope for Changing the Value
     */
    @SerializedName( "PrcgCndnValChgIsAllwd" )
    @JsonProperty( "PrcgCndnValChgIsAllwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PrcgCndnValChgIsAllwd" )
    private Boolean prcgCndnValChgIsAllwd;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnValChgIsAllwd</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> PRCG_CNDN_VAL_CHG_IS_ALLWD =
        new PurgPricingConditionTypeField<Boolean>("PrcgCndnValChgIsAllwd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnPrpsdValidFromDateCode</b>
     * </p>
     *
     * @return Proposed Start Date for the Validity Period
     */
    @SerializedName( "PrcgCndnPrpsdValidFromDateCode" )
    @JsonProperty( "PrcgCndnPrpsdValidFromDateCode" )
    @Nullable
    @ODataField( odataName = "PrcgCndnPrpsdValidFromDateCode" )
    private String prcgCndnPrpsdValidFromDateCode;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnPrpsdValidFromDateCode</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRCG_CNDN_PRPSD_VALID_FROM_DATE_CODE =
        new PurgPricingConditionTypeField<String>("PrcgCndnPrpsdValidFromDateCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnPrpsdValidToDateCode</b>
     * </p>
     *
     * @return Proposed End Date for the Validity Period
     */
    @SerializedName( "PrcgCndnPrpsdValidToDateCode" )
    @JsonProperty( "PrcgCndnPrpsdValidToDateCode" )
    @Nullable
    @ODataField( odataName = "PrcgCndnPrpsdValidToDateCode" )
    private String prcgCndnPrpsdValidToDateCode;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnPrpsdValidToDateCode</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRCG_CNDN_PRPSD_VALID_TO_DATE_CODE =
        new PurgPricingConditionTypeField<String>("PrcgCndnPrpsdValidToDateCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @return Pricing Procedure in Pricing
     */
    @SerializedName( "PricingProcedure" )
    @JsonProperty( "PricingProcedure" )
    @Nullable
    @ODataField( odataName = "PricingProcedure" )
    private String pricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedure</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRICING_PROCEDURE =
        new PurgPricingConditionTypeField<String>("PricingProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionDeletionMethod</b>
     * </p>
     *
     * @return Condition records should be deleted from the database
     */
    @SerializedName( "PrcgConditionDeletionMethod" )
    @JsonProperty( "PrcgConditionDeletionMethod" )
    @Nullable
    @ODataField( odataName = "PrcgConditionDeletionMethod" )
    private String prcgConditionDeletionMethod;
    /**
     * Use with available fluent helpers to apply the <b>PrcgConditionDeletionMethod</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRCG_CONDITION_DELETION_METHOD =
        new PurgPricingConditionTypeField<String>("PrcgConditionDeletionMethod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasisShort</b>
     * </p>
     *
     * @return Scale Base Type
     */
    @SerializedName( "PricingScaleBasisShort" )
    @JsonProperty( "PricingScaleBasisShort" )
    @Nullable
    @ODataField( odataName = "PricingScaleBasisShort" )
    private String pricingScaleBasisShort;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleBasisShort</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRICING_SCALE_BASIS_SHORT =
        new PurgPricingConditionTypeField<String>("PricingScaleBasisShort");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleCheckingRule</b>
     * </p>
     *
     * @return Checking Rule for Scale Amounts
     */
    @SerializedName( "PricingScaleCheckingRule" )
    @JsonProperty( "PricingScaleCheckingRule" )
    @Nullable
    @ODataField( odataName = "PricingScaleCheckingRule" )
    private String pricingScaleCheckingRule;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleCheckingRule</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRICING_SCALE_CHECKING_RULE =
        new PurgPricingConditionTypeField<String>("PricingScaleCheckingRule");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRICING_SCALE_TYPE =
        new PurgPricingConditionTypeField<String>("PricingScaleType");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleRoutine</b>
     * </p>
     *
     * @return Routine for Alternative Calculation of Scale Base Value
     */
    @SerializedName( "PricingScaleRoutine" )
    @JsonProperty( "PricingScaleRoutine" )
    @Nullable
    @ODataField( odataName = "PricingScaleRoutine" )
    private String pricingScaleRoutine;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleRoutine</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRICING_SCALE_ROUTINE =
        new PurgPricingConditionTypeField<String>("PricingScaleRoutine");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleUnit</b>
     * </p>
     *
     * @return Scale Unit
     */
    @SerializedName( "PricingScaleUnit" )
    @JsonProperty( "PricingScaleUnit" )
    @Nullable
    @ODataField( odataName = "PricingScaleUnit" )
    private String pricingScaleUnit;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleUnit</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> PRICING_SCALE_UNIT =
        new PurgPricingConditionTypeField<String>("PricingScaleUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnCrcyCnvrsnIsAftMltpl</b>
     * </p>
     *
     * @return Indicator: Currency Translation after Multiplication
     */
    @SerializedName( "PrcgCndnCrcyCnvrsnIsAftMltpl" )
    @JsonProperty( "PrcgCndnCrcyCnvrsnIsAftMltpl" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PrcgCndnCrcyCnvrsnIsAftMltpl" )
    private Boolean prcgCndnCrcyCnvrsnIsAftMltpl;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnCrcyCnvrsnIsAftMltpl</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> PRCG_CNDN_CRCY_CNVRSN_IS_AFT_MLTPL =
        new PurgPricingConditionTypeField<Boolean>("PrcgCndnCrcyCnvrsnIsAftMltpl");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @return Condition is Relevant for Accrual (e.g. Freight)
     */
    @SerializedName( "IsRelevantForAccrual" )
    @JsonProperty( "IsRelevantForAccrual" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsRelevantForAccrual" )
    private Boolean isRelevantForAccrual;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForAccrual</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> IS_RELEVANT_FOR_ACCRUAL =
        new PurgPricingConditionTypeField<Boolean>("IsRelevantForAccrual");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsForVariantConfiguration</b>
     * </p>
     *
     * @return Condition Used for Variant Configuration
     */
    @SerializedName( "CndnIsForVariantConfiguration" )
    @JsonProperty( "CndnIsForVariantConfiguration" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnIsForVariantConfiguration" )
    private Boolean cndnIsForVariantConfiguration;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsForVariantConfiguration</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> CNDN_IS_FOR_VARIANT_CONFIGURATION =
        new PurgPricingConditionTypeField<Boolean>("CndnIsForVariantConfiguration");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnQtyCnvrsnIsActivated</b>
     * </p>
     *
     * @return Quantity Conversion
     */
    @SerializedName( "PrcgCndnQtyCnvrsnIsActivated" )
    @JsonProperty( "PrcgCndnQtyCnvrsnIsActivated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PrcgCndnQtyCnvrsnIsActivated" )
    private Boolean prcgCndnQtyCnvrsnIsActivated;
    /**
     * Use with available fluent helpers to apply the <b>PrcgCndnQtyCnvrsnIsActivated</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> PRCG_CNDN_QTY_CNVRSN_IS_ACTIVATED =
        new PurgPricingConditionTypeField<Boolean>("PrcgCndnQtyCnvrsnIsActivated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @return Condition for Intercompany Billing
     */
    @SerializedName( "CndnIsRelevantForIntcoBilling" )
    @JsonProperty( "CndnIsRelevantForIntcoBilling" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnIsRelevantForIntcoBilling" )
    private Boolean cndnIsRelevantForIntcoBilling;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsRelevantForIntcoBilling</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> CNDN_IS_RELEVANT_FOR_INTCO_BILLING =
        new PurgPricingConditionTypeField<Boolean>("CndnIsRelevantForIntcoBilling");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @return Condition exclusion indicator
     */
    @SerializedName( "ConditionExclusion" )
    @JsonProperty( "ConditionExclusion" )
    @Nullable
    @ODataField( odataName = "ConditionExclusion" )
    private String conditionExclusion;
    /**
     * Use with available fluent helpers to apply the <b>ConditionExclusion</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CONDITION_EXCLUSION =
        new PurgPricingConditionTypeField<String>("ConditionExclusion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnValueZeroProcgCode</b>
     * </p>
     *
     * @return Process Conditions with Value Equal to Zero
     */
    @SerializedName( "CndnValueZeroProcgCode" )
    @JsonProperty( "CndnValueZeroProcgCode" )
    @Nullable
    @ODataField( odataName = "CndnValueZeroProcgCode" )
    private String cndnValueZeroProcgCode;
    /**
     * Use with available fluent helpers to apply the <b>CndnValueZeroProcgCode</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<String> CNDN_VALUE_ZERO_PROCG_CODE =
        new PurgPricingConditionTypeField<String>("CndnValueZeroProcgCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForSalesPriceCalc</b>
     * </p>
     *
     * @return Sales Price Calculation: Relevant to Pricing
     */
    @SerializedName( "IsRelevantForSalesPriceCalc" )
    @JsonProperty( "IsRelevantForSalesPriceCalc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsRelevantForSalesPriceCalc" )
    private Boolean isRelevantForSalesPriceCalc;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForSalesPriceCalc</b> field to query operations.
     *
     */
    public final static PurgPricingConditionTypeField<Boolean> IS_RELEVANT_FOR_SALES_PRICE_CALC =
        new PurgPricingConditionTypeField<Boolean>("IsRelevantForSalesPriceCalc");
    /**
     * Navigation property <b>to_Text</b> for <b>PurgPricingConditionType</b> to multiple <b>PurgPrcgCndnTypeText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgPrcgCndnTypeText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static PurgPricingConditionTypeLink<PurgPrcgCndnTypeText> TO_TEXT =
        new PurgPricingConditionTypeLink<PurgPrcgCndnTypeText>("to_Text");

    @Nonnull
    @Override
    public Class<PurgPricingConditionType> getType()
    {
        return PurgPricingConditionType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     *
     * @param accessSequence
     *            Access sequence
     */
    public void setAccessSequence( @Nullable final String accessSequence )
    {
        rememberChangedField("AccessSequence", this.accessSequence);
        this.accessSequence = accessSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @param conditionCategory
     *            Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    public void setConditionCategory( @Nullable final String conditionCategory )
    {
        rememberChangedField("ConditionCategory", this.conditionCategory);
        this.conditionCategory = conditionCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @param conditionClass
     *            Condition Class
     */
    public void setConditionClass( @Nullable final String conditionClass )
    {
        rememberChangedField("ConditionClass", this.conditionClass);
        this.conditionClass = conditionClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAmountRoundingRule</b>
     * </p>
     *
     * @param prcgCndnAmountRoundingRule
     *            Rounding Rule
     */
    public void setPrcgCndnAmountRoundingRule( @Nullable final String prcgCndnAmountRoundingRule )
    {
        rememberChangedField("PrcgCndnAmountRoundingRule", this.prcgCndnAmountRoundingRule);
        this.prcgCndnAmountRoundingRule = prcgCndnAmountRoundingRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     *
     * @param structureCondition
     *            Structure Condition
     */
    public void setStructureCondition( @Nullable final String structureCondition )
    {
        rememberChangedField("StructureCondition", this.structureCondition);
        this.structureCondition = structureCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionAmountSign</b>
     * </p>
     *
     * @param prcgConditionAmountSign
     *            Plus/Minus Sign of the condition Amount
     */
    public void setPrcgConditionAmountSign( @Nullable final String prcgConditionAmountSign )
    {
        rememberChangedField("PrcgConditionAmountSign", this.prcgConditionAmountSign);
        this.prcgConditionAmountSign = prcgConditionAmountSign;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @param isGroupCondition
     *            Group Condition
     */
    public void setIsGroupCondition( @Nullable final String isGroupCondition )
    {
        rememberChangedField("IsGroupCondition", this.isGroupCondition);
        this.isGroupCondition = isGroupCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnRndngDiffsIsSettled</b>
     * </p>
     *
     * @param prcgCndnRndngDiffsIsSettled
     *            Rounding Difference Comparison
     */
    public void setPrcgCndnRndngDiffsIsSettled( @Nullable final Boolean prcgCndnRndngDiffsIsSettled )
    {
        rememberChangedField("PrcgCndnRndngDiffsIsSettled", this.prcgCndnRndngDiffsIsSettled);
        this.prcgCndnRndngDiffsIsSettled = prcgCndnRndngDiffsIsSettled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>PrcgGroupConditionRoutine</b>
     * </p>
     *
     * @param prcgGroupConditionRoutine
     *            Routine Number for Creating Group Key
     */
    public void setPrcgGroupConditionRoutine( @Nullable final String prcgGroupConditionRoutine )
    {
        rememberChangedField("PrcgGroupConditionRoutine", this.prcgGroupConditionRoutine);
        this.prcgGroupConditionRoutine = prcgGroupConditionRoutine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnManualEntries</b>
     * </p>
     *
     * @param cndnManualEntries
     *            Making Manual Entries
     */
    public void setCndnManualEntries( @Nullable final String cndnManualEntries )
    {
        rememberChangedField("CndnManualEntries", this.cndnManualEntries);
        this.cndnManualEntries = cndnManualEntries;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnAppliesHeader</b>
     * </p>
     *
     * @param cndnAppliesHeader
     *            Condition Applies to Header
     */
    public void setCndnAppliesHeader( @Nullable final Boolean cndnAppliesHeader )
    {
        rememberChangedField("CndnAppliesHeader", this.cndnAppliesHeader);
        this.cndnAppliesHeader = cndnAppliesHeader;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnAppliesItems</b>
     * </p>
     *
     * @param cndnAppliesItems
     *            Condition Applies to Items
     */
    public void setCndnAppliesItems( @Nullable final Boolean cndnAppliesItems )
    {
        rememberChangedField("CndnAppliesItems", this.cndnAppliesItems);
        this.cndnAppliesItems = cndnAppliesItems;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTypeDeletionIsAllowed</b>
     * </p>
     *
     * @param prcgCndnTypeDeletionIsAllowed
     *            Delete the Scope for Changing Amount/Percentage
     */
    public void setPrcgCndnTypeDeletionIsAllowed( @Nullable final Boolean prcgCndnTypeDeletionIsAllowed )
    {
        rememberChangedField("PrcgCndnTypeDeletionIsAllowed", this.prcgCndnTypeDeletionIsAllowed);
        this.prcgCndnTypeDeletionIsAllowed = prcgCndnTypeDeletionIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAmountChangedIsAllowed</b>
     * </p>
     *
     * @param prcgCndnAmountChangedIsAllowed
     *            Change of Condition Amount/Percentage
     */
    public void setPrcgCndnAmountChangedIsAllowed( @Nullable final Boolean prcgCndnAmountChangedIsAllowed )
    {
        rememberChangedField("PrcgCndnAmountChangedIsAllowed", this.prcgCndnAmountChangedIsAllowed);
        this.prcgCndnAmountChangedIsAllowed = prcgCndnAmountChangedIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnCnvrsnFctrChgIsAllowed</b>
     * </p>
     *
     * @param prcgCndnCnvrsnFctrChgIsAllowed
     *            Scope for Changing Conversion Factors
     */
    public void setPrcgCndnCnvrsnFctrChgIsAllowed( @Nullable final Boolean prcgCndnCnvrsnFctrChgIsAllowed )
    {
        rememberChangedField("PrcgCndnCnvrsnFctrChgIsAllowed", this.prcgCndnCnvrsnFctrChgIsAllowed);
        this.prcgCndnCnvrsnFctrChgIsAllowed = prcgCndnCnvrsnFctrChgIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnValChgIsAllwd</b>
     * </p>
     *
     * @param prcgCndnValChgIsAllwd
     *            Scope for Changing the Value
     */
    public void setPrcgCndnValChgIsAllwd( @Nullable final Boolean prcgCndnValChgIsAllwd )
    {
        rememberChangedField("PrcgCndnValChgIsAllwd", this.prcgCndnValChgIsAllwd);
        this.prcgCndnValChgIsAllwd = prcgCndnValChgIsAllwd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnPrpsdValidFromDateCode</b>
     * </p>
     *
     * @param prcgCndnPrpsdValidFromDateCode
     *            Proposed Start Date for the Validity Period
     */
    public void setPrcgCndnPrpsdValidFromDateCode( @Nullable final String prcgCndnPrpsdValidFromDateCode )
    {
        rememberChangedField("PrcgCndnPrpsdValidFromDateCode", this.prcgCndnPrpsdValidFromDateCode);
        this.prcgCndnPrpsdValidFromDateCode = prcgCndnPrpsdValidFromDateCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnPrpsdValidToDateCode</b>
     * </p>
     *
     * @param prcgCndnPrpsdValidToDateCode
     *            Proposed End Date for the Validity Period
     */
    public void setPrcgCndnPrpsdValidToDateCode( @Nullable final String prcgCndnPrpsdValidToDateCode )
    {
        rememberChangedField("PrcgCndnPrpsdValidToDateCode", this.prcgCndnPrpsdValidToDateCode);
        this.prcgCndnPrpsdValidToDateCode = prcgCndnPrpsdValidToDateCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @param pricingProcedure
     *            Pricing Procedure in Pricing
     */
    public void setPricingProcedure( @Nullable final String pricingProcedure )
    {
        rememberChangedField("PricingProcedure", this.pricingProcedure);
        this.pricingProcedure = pricingProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionDeletionMethod</b>
     * </p>
     *
     * @param prcgConditionDeletionMethod
     *            Condition records should be deleted from the database
     */
    public void setPrcgConditionDeletionMethod( @Nullable final String prcgConditionDeletionMethod )
    {
        rememberChangedField("PrcgConditionDeletionMethod", this.prcgConditionDeletionMethod);
        this.prcgConditionDeletionMethod = prcgConditionDeletionMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasisShort</b>
     * </p>
     *
     * @param pricingScaleBasisShort
     *            Scale Base Type
     */
    public void setPricingScaleBasisShort( @Nullable final String pricingScaleBasisShort )
    {
        rememberChangedField("PricingScaleBasisShort", this.pricingScaleBasisShort);
        this.pricingScaleBasisShort = pricingScaleBasisShort;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleCheckingRule</b>
     * </p>
     *
     * @param pricingScaleCheckingRule
     *            Checking Rule for Scale Amounts
     */
    public void setPricingScaleCheckingRule( @Nullable final String pricingScaleCheckingRule )
    {
        rememberChangedField("PricingScaleCheckingRule", this.pricingScaleCheckingRule);
        this.pricingScaleCheckingRule = pricingScaleCheckingRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleRoutine</b>
     * </p>
     *
     * @param pricingScaleRoutine
     *            Routine for Alternative Calculation of Scale Base Value
     */
    public void setPricingScaleRoutine( @Nullable final String pricingScaleRoutine )
    {
        rememberChangedField("PricingScaleRoutine", this.pricingScaleRoutine);
        this.pricingScaleRoutine = pricingScaleRoutine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleUnit</b>
     * </p>
     *
     * @param pricingScaleUnit
     *            Scale Unit
     */
    public void setPricingScaleUnit( @Nullable final String pricingScaleUnit )
    {
        rememberChangedField("PricingScaleUnit", this.pricingScaleUnit);
        this.pricingScaleUnit = pricingScaleUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnCrcyCnvrsnIsAftMltpl</b>
     * </p>
     *
     * @param prcgCndnCrcyCnvrsnIsAftMltpl
     *            Indicator: Currency Translation after Multiplication
     */
    public void setPrcgCndnCrcyCnvrsnIsAftMltpl( @Nullable final Boolean prcgCndnCrcyCnvrsnIsAftMltpl )
    {
        rememberChangedField("PrcgCndnCrcyCnvrsnIsAftMltpl", this.prcgCndnCrcyCnvrsnIsAftMltpl);
        this.prcgCndnCrcyCnvrsnIsAftMltpl = prcgCndnCrcyCnvrsnIsAftMltpl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @param isRelevantForAccrual
     *            Condition is Relevant for Accrual (e.g. Freight)
     */
    public void setIsRelevantForAccrual( @Nullable final Boolean isRelevantForAccrual )
    {
        rememberChangedField("IsRelevantForAccrual", this.isRelevantForAccrual);
        this.isRelevantForAccrual = isRelevantForAccrual;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsForVariantConfiguration</b>
     * </p>
     *
     * @param cndnIsForVariantConfiguration
     *            Condition Used for Variant Configuration
     */
    public void setCndnIsForVariantConfiguration( @Nullable final Boolean cndnIsForVariantConfiguration )
    {
        rememberChangedField("CndnIsForVariantConfiguration", this.cndnIsForVariantConfiguration);
        this.cndnIsForVariantConfiguration = cndnIsForVariantConfiguration;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnQtyCnvrsnIsActivated</b>
     * </p>
     *
     * @param prcgCndnQtyCnvrsnIsActivated
     *            Quantity Conversion
     */
    public void setPrcgCndnQtyCnvrsnIsActivated( @Nullable final Boolean prcgCndnQtyCnvrsnIsActivated )
    {
        rememberChangedField("PrcgCndnQtyCnvrsnIsActivated", this.prcgCndnQtyCnvrsnIsActivated);
        this.prcgCndnQtyCnvrsnIsActivated = prcgCndnQtyCnvrsnIsActivated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @param cndnIsRelevantForIntcoBilling
     *            Condition for Intercompany Billing
     */
    public void setCndnIsRelevantForIntcoBilling( @Nullable final Boolean cndnIsRelevantForIntcoBilling )
    {
        rememberChangedField("CndnIsRelevantForIntcoBilling", this.cndnIsRelevantForIntcoBilling);
        this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @param conditionExclusion
     *            Condition exclusion indicator
     */
    public void setConditionExclusion( @Nullable final String conditionExclusion )
    {
        rememberChangedField("ConditionExclusion", this.conditionExclusion);
        this.conditionExclusion = conditionExclusion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnValueZeroProcgCode</b>
     * </p>
     *
     * @param cndnValueZeroProcgCode
     *            Process Conditions with Value Equal to Zero
     */
    public void setCndnValueZeroProcgCode( @Nullable final String cndnValueZeroProcgCode )
    {
        rememberChangedField("CndnValueZeroProcgCode", this.cndnValueZeroProcgCode);
        this.cndnValueZeroProcgCode = cndnValueZeroProcgCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForSalesPriceCalc</b>
     * </p>
     *
     * @param isRelevantForSalesPriceCalc
     *            Sales Price Calculation: Relevant to Pricing
     */
    public void setIsRelevantForSalesPriceCalc( @Nullable final Boolean isRelevantForSalesPriceCalc )
    {
        rememberChangedField("IsRelevantForSalesPriceCalc", this.isRelevantForSalesPriceCalc);
        this.isRelevantForSalesPriceCalc = isRelevantForSalesPriceCalc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgPricingConditionType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionUsage", getConditionUsage());
        result.put("ConditionApplication", getConditionApplication());
        result.put("ConditionType", getConditionType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("AccessSequence", getAccessSequence());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionCategory", getConditionCategory());
        values.put("ConditionClass", getConditionClass());
        values.put("PrcgCndnAmountRoundingRule", getPrcgCndnAmountRoundingRule());
        values.put("StructureCondition", getStructureCondition());
        values.put("PrcgConditionAmountSign", getPrcgConditionAmountSign());
        values.put("IsGroupCondition", getIsGroupCondition());
        values.put("PrcgCndnRndngDiffsIsSettled", getPrcgCndnRndngDiffsIsSettled());
        values.put("PrcgGroupConditionRoutine", getPrcgGroupConditionRoutine());
        values.put("CndnManualEntries", getCndnManualEntries());
        values.put("CndnAppliesHeader", getCndnAppliesHeader());
        values.put("CndnAppliesItems", getCndnAppliesItems());
        values.put("PrcgCndnTypeDeletionIsAllowed", getPrcgCndnTypeDeletionIsAllowed());
        values.put("PrcgCndnAmountChangedIsAllowed", getPrcgCndnAmountChangedIsAllowed());
        values.put("PrcgCndnCnvrsnFctrChgIsAllowed", getPrcgCndnCnvrsnFctrChgIsAllowed());
        values.put("PrcgCndnValChgIsAllwd", getPrcgCndnValChgIsAllwd());
        values.put("PrcgCndnPrpsdValidFromDateCode", getPrcgCndnPrpsdValidFromDateCode());
        values.put("PrcgCndnPrpsdValidToDateCode", getPrcgCndnPrpsdValidToDateCode());
        values.put("PricingProcedure", getPricingProcedure());
        values.put("PrcgConditionDeletionMethod", getPrcgConditionDeletionMethod());
        values.put("PricingScaleBasisShort", getPricingScaleBasisShort());
        values.put("PricingScaleCheckingRule", getPricingScaleCheckingRule());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("PricingScaleRoutine", getPricingScaleRoutine());
        values.put("PricingScaleUnit", getPricingScaleUnit());
        values.put("PrcgCndnCrcyCnvrsnIsAftMltpl", getPrcgCndnCrcyCnvrsnIsAftMltpl());
        values.put("IsRelevantForAccrual", getIsRelevantForAccrual());
        values.put("CndnIsForVariantConfiguration", getCndnIsForVariantConfiguration());
        values.put("PrcgCndnQtyCnvrsnIsActivated", getPrcgCndnQtyCnvrsnIsActivated());
        values.put("CndnIsRelevantForIntcoBilling", getCndnIsRelevantForIntcoBilling());
        values.put("ConditionExclusion", getConditionExclusion());
        values.put("CndnValueZeroProcgCode", getCndnValueZeroProcgCode());
        values.put("IsRelevantForSalesPriceCalc", getIsRelevantForSalesPriceCalc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("AccessSequence") ) {
                final Object value = values.remove("AccessSequence");
                if( (value == null) || (!value.equals(getAccessSequence())) ) {
                    setAccessSequence(((String) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((String) value));
                }
            }
            if( values.containsKey("ConditionCategory") ) {
                final Object value = values.remove("ConditionCategory");
                if( (value == null) || (!value.equals(getConditionCategory())) ) {
                    setConditionCategory(((String) value));
                }
            }
            if( values.containsKey("ConditionClass") ) {
                final Object value = values.remove("ConditionClass");
                if( (value == null) || (!value.equals(getConditionClass())) ) {
                    setConditionClass(((String) value));
                }
            }
            if( values.containsKey("PrcgCndnAmountRoundingRule") ) {
                final Object value = values.remove("PrcgCndnAmountRoundingRule");
                if( (value == null) || (!value.equals(getPrcgCndnAmountRoundingRule())) ) {
                    setPrcgCndnAmountRoundingRule(((String) value));
                }
            }
            if( values.containsKey("StructureCondition") ) {
                final Object value = values.remove("StructureCondition");
                if( (value == null) || (!value.equals(getStructureCondition())) ) {
                    setStructureCondition(((String) value));
                }
            }
            if( values.containsKey("PrcgConditionAmountSign") ) {
                final Object value = values.remove("PrcgConditionAmountSign");
                if( (value == null) || (!value.equals(getPrcgConditionAmountSign())) ) {
                    setPrcgConditionAmountSign(((String) value));
                }
            }
            if( values.containsKey("IsGroupCondition") ) {
                final Object value = values.remove("IsGroupCondition");
                if( (value == null) || (!value.equals(getIsGroupCondition())) ) {
                    setIsGroupCondition(((String) value));
                }
            }
            if( values.containsKey("PrcgCndnRndngDiffsIsSettled") ) {
                final Object value = values.remove("PrcgCndnRndngDiffsIsSettled");
                if( (value == null) || (!value.equals(getPrcgCndnRndngDiffsIsSettled())) ) {
                    setPrcgCndnRndngDiffsIsSettled(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgGroupConditionRoutine") ) {
                final Object value = values.remove("PrcgGroupConditionRoutine");
                if( (value == null) || (!value.equals(getPrcgGroupConditionRoutine())) ) {
                    setPrcgGroupConditionRoutine(((String) value));
                }
            }
            if( values.containsKey("CndnManualEntries") ) {
                final Object value = values.remove("CndnManualEntries");
                if( (value == null) || (!value.equals(getCndnManualEntries())) ) {
                    setCndnManualEntries(((String) value));
                }
            }
            if( values.containsKey("CndnAppliesHeader") ) {
                final Object value = values.remove("CndnAppliesHeader");
                if( (value == null) || (!value.equals(getCndnAppliesHeader())) ) {
                    setCndnAppliesHeader(((Boolean) value));
                }
            }
            if( values.containsKey("CndnAppliesItems") ) {
                final Object value = values.remove("CndnAppliesItems");
                if( (value == null) || (!value.equals(getCndnAppliesItems())) ) {
                    setCndnAppliesItems(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnTypeDeletionIsAllowed") ) {
                final Object value = values.remove("PrcgCndnTypeDeletionIsAllowed");
                if( (value == null) || (!value.equals(getPrcgCndnTypeDeletionIsAllowed())) ) {
                    setPrcgCndnTypeDeletionIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnAmountChangedIsAllowed") ) {
                final Object value = values.remove("PrcgCndnAmountChangedIsAllowed");
                if( (value == null) || (!value.equals(getPrcgCndnAmountChangedIsAllowed())) ) {
                    setPrcgCndnAmountChangedIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnCnvrsnFctrChgIsAllowed") ) {
                final Object value = values.remove("PrcgCndnCnvrsnFctrChgIsAllowed");
                if( (value == null) || (!value.equals(getPrcgCndnCnvrsnFctrChgIsAllowed())) ) {
                    setPrcgCndnCnvrsnFctrChgIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnValChgIsAllwd") ) {
                final Object value = values.remove("PrcgCndnValChgIsAllwd");
                if( (value == null) || (!value.equals(getPrcgCndnValChgIsAllwd())) ) {
                    setPrcgCndnValChgIsAllwd(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnPrpsdValidFromDateCode") ) {
                final Object value = values.remove("PrcgCndnPrpsdValidFromDateCode");
                if( (value == null) || (!value.equals(getPrcgCndnPrpsdValidFromDateCode())) ) {
                    setPrcgCndnPrpsdValidFromDateCode(((String) value));
                }
            }
            if( values.containsKey("PrcgCndnPrpsdValidToDateCode") ) {
                final Object value = values.remove("PrcgCndnPrpsdValidToDateCode");
                if( (value == null) || (!value.equals(getPrcgCndnPrpsdValidToDateCode())) ) {
                    setPrcgCndnPrpsdValidToDateCode(((String) value));
                }
            }
            if( values.containsKey("PricingProcedure") ) {
                final Object value = values.remove("PricingProcedure");
                if( (value == null) || (!value.equals(getPricingProcedure())) ) {
                    setPricingProcedure(((String) value));
                }
            }
            if( values.containsKey("PrcgConditionDeletionMethod") ) {
                final Object value = values.remove("PrcgConditionDeletionMethod");
                if( (value == null) || (!value.equals(getPrcgConditionDeletionMethod())) ) {
                    setPrcgConditionDeletionMethod(((String) value));
                }
            }
            if( values.containsKey("PricingScaleBasisShort") ) {
                final Object value = values.remove("PricingScaleBasisShort");
                if( (value == null) || (!value.equals(getPricingScaleBasisShort())) ) {
                    setPricingScaleBasisShort(((String) value));
                }
            }
            if( values.containsKey("PricingScaleCheckingRule") ) {
                final Object value = values.remove("PricingScaleCheckingRule");
                if( (value == null) || (!value.equals(getPricingScaleCheckingRule())) ) {
                    setPricingScaleCheckingRule(((String) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("PricingScaleRoutine") ) {
                final Object value = values.remove("PricingScaleRoutine");
                if( (value == null) || (!value.equals(getPricingScaleRoutine())) ) {
                    setPricingScaleRoutine(((String) value));
                }
            }
            if( values.containsKey("PricingScaleUnit") ) {
                final Object value = values.remove("PricingScaleUnit");
                if( (value == null) || (!value.equals(getPricingScaleUnit())) ) {
                    setPricingScaleUnit(((String) value));
                }
            }
            if( values.containsKey("PrcgCndnCrcyCnvrsnIsAftMltpl") ) {
                final Object value = values.remove("PrcgCndnCrcyCnvrsnIsAftMltpl");
                if( (value == null) || (!value.equals(getPrcgCndnCrcyCnvrsnIsAftMltpl())) ) {
                    setPrcgCndnCrcyCnvrsnIsAftMltpl(((Boolean) value));
                }
            }
            if( values.containsKey("IsRelevantForAccrual") ) {
                final Object value = values.remove("IsRelevantForAccrual");
                if( (value == null) || (!value.equals(getIsRelevantForAccrual())) ) {
                    setIsRelevantForAccrual(((Boolean) value));
                }
            }
            if( values.containsKey("CndnIsForVariantConfiguration") ) {
                final Object value = values.remove("CndnIsForVariantConfiguration");
                if( (value == null) || (!value.equals(getCndnIsForVariantConfiguration())) ) {
                    setCndnIsForVariantConfiguration(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnQtyCnvrsnIsActivated") ) {
                final Object value = values.remove("PrcgCndnQtyCnvrsnIsActivated");
                if( (value == null) || (!value.equals(getPrcgCndnQtyCnvrsnIsActivated())) ) {
                    setPrcgCndnQtyCnvrsnIsActivated(((Boolean) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForIntcoBilling") ) {
                final Object value = values.remove("CndnIsRelevantForIntcoBilling");
                if( (value == null) || (!value.equals(getCndnIsRelevantForIntcoBilling())) ) {
                    setCndnIsRelevantForIntcoBilling(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionExclusion") ) {
                final Object value = values.remove("ConditionExclusion");
                if( (value == null) || (!value.equals(getConditionExclusion())) ) {
                    setConditionExclusion(((String) value));
                }
            }
            if( values.containsKey("CndnValueZeroProcgCode") ) {
                final Object value = values.remove("CndnValueZeroProcgCode");
                if( (value == null) || (!value.equals(getCndnValueZeroProcgCode())) ) {
                    setCndnValueZeroProcgCode(((String) value));
                }
            }
            if( values.containsKey("IsRelevantForSalesPriceCalc") ) {
                final Object value = values.remove("IsRelevantForSalesPriceCalc");
                if( (value == null) || (!value.equals(getIsRelevantForSalesPriceCalc())) ) {
                    setIsRelevantForSalesPriceCalc(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgPrcgCndnTypeText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new PurgPrcgCndnTypeText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgPricingConditionTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgPricingConditionTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgPricingConditionTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgPricingConditionTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgPrcgCndnTypeText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgPrcgCndnTypeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgPrcgCndnTypeText> fetchText()
    {
        return fetchFieldAsList("to_Text", PurgPrcgCndnTypeText.class);
    }

    /**
     * Retrieval of associated <b>PurgPrcgCndnTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>PurgPricingConditionType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPrcgCndnTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgPrcgCndnTypeText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>PurgPrcgCndnTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPricingConditionType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>PurgPrcgCndnTypeText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<PurgPrcgCndnTypeText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>PurgPrcgCndnTypeText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>PurgPricingConditionType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgPrcgCndnTypeText</b> entities.
     */
    public void setText( @Nonnull final List<PurgPrcgCndnTypeText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgPrcgCndnTypeText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>PurgPricingConditionType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgPrcgCndnTypeText</b> entities.
     */
    public void addText( PurgPrcgCndnTypeText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurgPricingConditionType instances.
     *
     */
    public final static class PurgPricingConditionTypeBuilder
    {

        private List<PurgPrcgCndnTypeText> toText = Lists.newArrayList();

        private PurgPricingConditionType.PurgPricingConditionTypeBuilder toText(
            final List<PurgPrcgCndnTypeText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>PurgPricingConditionType</b> to multiple
         * <b>PurgPrcgCndnTypeText</b>.
         *
         * @param value
         *            The PurgPrcgCndnTypeTexts to build this PurgPricingConditionType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPricingConditionType.PurgPricingConditionTypeBuilder text( PurgPrcgCndnTypeText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
