/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ConditionTypeForPricingInPurchasingServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService
 * ConditionTypeForPricingInPurchasingService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultConditionTypeForPricingInPurchasingServiceBatch
    extends
    BatchFluentHelperBasic<ConditionTypeForPricingInPurchasingServiceBatch, ConditionTypeForPricingInPurchasingServiceBatchChangeSet>
    implements
    ConditionTypeForPricingInPurchasingServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultConditionTypeForPricingInPurchasingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultConditionTypeForPricingInPurchasingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultConditionTypeForPricingInPurchasingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultConditionTypeForPricingInPurchasingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultConditionTypeForPricingInPurchasingServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ConditionTypeForPricingInPurchasingServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultConditionTypeForPricingInPurchasingServiceBatchChangeSet(this, service);
    }

}
