/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ConditionTypeForPricingInPurchasingServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService
 * ConditionTypeForPricingInPurchasingService}.
 *
 */
public class DefaultConditionTypeForPricingInPurchasingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ConditionTypeForPricingInPurchasingServiceBatch, ConditionTypeForPricingInPurchasingServiceBatchChangeSet>
    implements
    ConditionTypeForPricingInPurchasingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService service;

    @SuppressWarnings( "deprecation" )
    DefaultConditionTypeForPricingInPurchasingServiceBatchChangeSet(
        @Nonnull final DefaultConditionTypeForPricingInPurchasingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInPurchasingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultConditionTypeForPricingInPurchasingServiceBatchChangeSet getThis()
    {
        return this;
    }

}
