/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType
 * PurgPricingConditionType}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.field.PurgPricingConditionTypeField
 * PurgPricingConditionTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.link.PurgPricingConditionTypeLink
 * PurgPricingConditionTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#ACCESS_SEQUENCE
 * ACCESS_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CONDITION_CATEGORY
 * CONDITION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CONDITION_CLASS
 * CONDITION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_AMOUNT_ROUNDING_RULE
 * PRCG_CNDN_AMOUNT_ROUNDING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#STRUCTURE_CONDITION
 * STRUCTURE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CONDITION_AMOUNT_SIGN
 * PRCG_CONDITION_AMOUNT_SIGN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#IS_GROUP_CONDITION
 * IS_GROUP_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_RNDNG_DIFFS_IS_SETTLED
 * PRCG_CNDN_RNDNG_DIFFS_IS_SETTLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_GROUP_CONDITION_ROUTINE
 * PRCG_GROUP_CONDITION_ROUTINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CNDN_MANUAL_ENTRIES
 * CNDN_MANUAL_ENTRIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CNDN_APPLIES_HEADER
 * CNDN_APPLIES_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CNDN_APPLIES_ITEMS
 * CNDN_APPLIES_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_TYPE_DELETION_IS_ALLOWED
 * PRCG_CNDN_TYPE_DELETION_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_AMOUNT_CHANGED_IS_ALLOWED
 * PRCG_CNDN_AMOUNT_CHANGED_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_CNVRSN_FCTR_CHG_IS_ALLOWED
 * PRCG_CNDN_CNVRSN_FCTR_CHG_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_VAL_CHG_IS_ALLWD
 * PRCG_CNDN_VAL_CHG_IS_ALLWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_PRPSD_VALID_FROM_DATE_CODE
 * PRCG_CNDN_PRPSD_VALID_FROM_DATE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_PRPSD_VALID_TO_DATE_CODE
 * PRCG_CNDN_PRPSD_VALID_TO_DATE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRICING_PROCEDURE
 * PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CONDITION_DELETION_METHOD
 * PRCG_CONDITION_DELETION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRICING_SCALE_BASIS_SHORT
 * PRICING_SCALE_BASIS_SHORT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRICING_SCALE_CHECKING_RULE
 * PRICING_SCALE_CHECKING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRICING_SCALE_ROUTINE
 * PRICING_SCALE_ROUTINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRICING_SCALE_UNIT
 * PRICING_SCALE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_CRCY_CNVRSN_IS_AFT_MLTPL
 * PRCG_CNDN_CRCY_CNVRSN_IS_AFT_MLTPL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#IS_RELEVANT_FOR_ACCRUAL
 * IS_RELEVANT_FOR_ACCRUAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CNDN_IS_FOR_VARIANT_CONFIGURATION
 * CNDN_IS_FOR_VARIANT_CONFIGURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#PRCG_CNDN_QTY_CNVRSN_IS_ACTIVATED
 * PRCG_CNDN_QTY_CNVRSN_IS_ACTIVATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CNDN_IS_RELEVANT_FOR_INTCO_BILLING
 * CNDN_IS_RELEVANT_FOR_INTCO_BILLING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CONDITION_EXCLUSION
 * CONDITION_EXCLUSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#CNDN_VALUE_ZERO_PROCG_CODE
 * CNDN_VALUE_ZERO_PROCG_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#IS_RELEVANT_FOR_SALES_PRICE_CALC
 * IS_RELEVANT_FOR_SALES_PRICE_CALC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginpurchasing.PurgPricingConditionType#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface PurgPricingConditionTypeSelectable extends EntitySelectable<PurgPricingConditionType>
{

}
