/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.selectable.SlsPrcgCndnTypeTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText
 * SlsPrcgCndnTypeText} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SlsPrcgCndnTypeTextByKeyFluentHelper
    extends
    FluentHelperByKey<SlsPrcgCndnTypeTextByKeyFluentHelper, SlsPrcgCndnTypeText, SlsPrcgCndnTypeTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText
     * SlsPrcgCndnTypeText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SlsPrcgCndnTypeText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SlsPrcgCndnTypeText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionType
     *            Condition Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param conditionUsage
     *            Usage of the condition table
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param conditionApplication
     *            Application
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public SlsPrcgCndnTypeTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String conditionUsage,
        final String conditionApplication,
        final String conditionType )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("ConditionUsage", conditionUsage);
        this.key.put("ConditionApplication", conditionApplication);
        this.key.put("ConditionType", conditionType);
    }

    @Override
    @Nonnull
    protected Class<SlsPrcgCndnTypeText> getEntityClass()
    {
        return SlsPrcgCndnTypeText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
