/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.field.SlsPrcgConditionFunctionTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.selectable.SlsPrcgConditionFunctionTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Condition Function Descriptions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsPrcgConditionFunctionTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsPrcgConditionFunctionText extends VdmEntity<SlsPrcgConditionFunctionText>
{

    /**
     * Selector for all available fields of SlsPrcgConditionFunctionText.
     *
     */
    public final static SlsPrcgConditionFunctionTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionFunctionTextField<String> LANGUAGE =
        new SlsPrcgConditionFunctionTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @return Usage of the condition table
     */
    @Key
    @SerializedName( "ConditionUsage" )
    @JsonProperty( "ConditionUsage" )
    @Nullable
    @ODataField( odataName = "ConditionUsage" )
    private String conditionUsage;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUsage</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionFunctionTextField<String> CONDITION_USAGE =
        new SlsPrcgConditionFunctionTextField<String>("ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @Key
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionFunctionTextField<String> CONDITION_APPLICATION =
        new SlsPrcgConditionFunctionTextField<String>("ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionFunction</b>
     * </p>
     *
     * @return Condition Function
     */
    @Key
    @SerializedName( "PricingConditionFunction" )
    @JsonProperty( "PricingConditionFunction" )
    @Nullable
    @ODataField( odataName = "PricingConditionFunction" )
    private String pricingConditionFunction;
    /**
     * Use with available fluent helpers to apply the <b>PricingConditionFunction</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionFunctionTextField<String> PRICING_CONDITION_FUNCTION =
        new SlsPrcgConditionFunctionTextField<String>("PricingConditionFunction");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionFunctionText</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "PricingConditionFunctionText" )
    @JsonProperty( "PricingConditionFunctionText" )
    @Nullable
    @ODataField( odataName = "PricingConditionFunctionText" )
    private String pricingConditionFunctionText;
    /**
     * Use with available fluent helpers to apply the <b>PricingConditionFunctionText</b> field to query operations.
     *
     */
    public final static SlsPrcgConditionFunctionTextField<String> PRICING_CONDITION_FUNCTION_TEXT =
        new SlsPrcgConditionFunctionTextField<String>("PricingConditionFunctionText");

    @Nonnull
    @Override
    public Class<SlsPrcgConditionFunctionText> getType()
    {
        return SlsPrcgConditionFunctionText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionFunction</b>
     * </p>
     *
     * @param pricingConditionFunction
     *            Condition Function
     */
    public void setPricingConditionFunction( @Nullable final String pricingConditionFunction )
    {
        rememberChangedField("PricingConditionFunction", this.pricingConditionFunction);
        this.pricingConditionFunction = pricingConditionFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionFunctionText</b>
     * </p>
     *
     * @param pricingConditionFunctionText
     *            Description
     */
    public void setPricingConditionFunctionText( @Nullable final String pricingConditionFunctionText )
    {
        rememberChangedField("PricingConditionFunctionText", this.pricingConditionFunctionText);
        this.pricingConditionFunctionText = pricingConditionFunctionText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsPrcgConditionFunctionText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConditionUsage", getConditionUsage());
        result.put("ConditionApplication", getConditionApplication());
        result.put("PricingConditionFunction", getPricingConditionFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("PricingConditionFunction", getPricingConditionFunction());
        values.put("PricingConditionFunctionText", getPricingConditionFunctionText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("PricingConditionFunction") ) {
                final Object value = values.remove("PricingConditionFunction");
                if( (value == null) || (!value.equals(getPricingConditionFunction())) ) {
                    setPricingConditionFunction(((String) value));
                }
            }
            if( values.containsKey("PricingConditionFunctionText") ) {
                final Object value = values.remove("PricingConditionFunctionText");
                if( (value == null) || (!value.equals(getPricingConditionFunctionText())) ) {
                    setPricingConditionFunctionText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SlsPrcgConditionFunctionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SlsPrcgConditionFunctionTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsPrcgConditionFunctionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsPrcgConditionFunctionTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInSalesService.DEFAULT_SERVICE_PATH);
    }

}
