/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ConditionTypeForPricingInSalesServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInSalesService
 * ConditionTypeForPricingInSalesService}.
 *
 */
public class DefaultConditionTypeForPricingInSalesServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ConditionTypeForPricingInSalesServiceBatch, ConditionTypeForPricingInSalesServiceBatchChangeSet>
    implements
    ConditionTypeForPricingInSalesServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInSalesService service;

    @SuppressWarnings( "deprecation" )
    DefaultConditionTypeForPricingInSalesServiceBatchChangeSet(
        @Nonnull final DefaultConditionTypeForPricingInSalesServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConditionTypeForPricingInSalesService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultConditionTypeForPricingInSalesServiceBatchChangeSet getThis()
    {
        return this;
    }

}
