/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText
 * SlsPrcgCndnTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.field.SlsPrcgCndnTypeTextField
 * SlsPrcgCndnTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.link.SlsPrcgCndnTypeTextLink
 * SlsPrcgCndnTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText#CONDITION_TYPE_NAME
 * CONDITION_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgCndnTypeText#TO_SLS_PRICING_CONDITION_TYPE
 * TO_SLS_PRICING_CONDITION_TYPE}</li>
 * </ul>
 *
 */
public interface SlsPrcgCndnTypeTextSelectable extends EntitySelectable<SlsPrcgCndnTypeText>
{

}
