/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgConditionFunctionText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgConditionFunctionText
 * SlsPrcgConditionFunctionText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.field.SlsPrcgConditionFunctionTextField
 * SlsPrcgConditionFunctionTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.link.SlsPrcgConditionFunctionTextLink
 * SlsPrcgConditionFunctionTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgConditionFunctionText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgConditionFunctionText#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgConditionFunctionText#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgConditionFunctionText#PRICING_CONDITION_FUNCTION
 * PRICING_CONDITION_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditiontypeforpricinginsales.SlsPrcgConditionFunctionText#PRICING_CONDITION_FUNCTION_TEXT
 * PRICING_CONDITION_FUNCTION_TEXT}</li>
 * </ul>
 *
 */
public interface SlsPrcgConditionFunctionTextSelectable extends EntitySelectable<SlsPrcgConditionFunctionText>
{

}
