/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.field.ConsolidationUnitField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.link.ConsolidationUnitLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable.ConsolidationUnitSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationUnitType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationUnit extends VdmEntity<ConsolidationUnit>
{

    /**
     * Selector for all available fields of ConsolidationUnit.
     *
     */
    public final static ConsolidationUnitSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> CONSOLIDATION_UNIT =
        new ConsolidationUnitField<String>("ConsolidationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region in Consolidation
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> COUNTRY = new ConsolidationUnitField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLink</b>
     * </p>
     *
     * @return Link URL
     */
    @SerializedName( "ConsolidationUnitLink" )
    @JsonProperty( "ConsolidationUnitLink" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLink" )
    private String consolidationUnitLink;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLink</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> CONSOLIDATION_UNIT_LINK =
        new ConsolidationUnitField<String>("ConsolidationUnitLink");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLinkLabel</b>
     * </p>
     *
     * @return Link Title
     */
    @SerializedName( "ConsolidationUnitLinkLabel" )
    @JsonProperty( "ConsolidationUnitLinkLabel" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLinkLabel" )
    private String consolidationUnitLinkLabel;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLinkLabel</b> field to query operations.
     *
     */
    public final static ConsolidationUnitField<String> CONSOLIDATION_UNIT_LINK_LABEL =
        new ConsolidationUnitField<String>("ConsolidationUnitLinkLabel");
    /**
     * Navigation property <b>to_CnsldtnUnitByTime</b> for <b>ConsolidationUnit</b> to multiple
     * <b>ConsolidationUnitByTime</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitByTime" )
    @JsonProperty( "to_CnsldtnUnitByTime" )
    @ODataField( odataName = "to_CnsldtnUnitByTime" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationUnitByTime> toCnsldtnUnitByTime;
    /**
     * Navigation property <b>to_CnsldtnUnitByTimeVersion</b> for <b>ConsolidationUnit</b> to multiple
     * <b>ConsolidationUnitByTimeVersion</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnitByTimeVersion" )
    @JsonProperty( "to_CnsldtnUnitByTimeVersion" )
    @ODataField( odataName = "to_CnsldtnUnitByTimeVersion" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationUnitByTimeVersion> toCnsldtnUnitByTimeVersion;
    /**
     * Navigation property <b>to_Text</b> for <b>ConsolidationUnit</b> to multiple <b>ConsolidationUnitText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConsolidationUnitText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitByTime</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationUnitLink<ConsolidationUnitByTime> TO_CNSLDTN_UNIT_BY_TIME =
        new ConsolidationUnitLink<ConsolidationUnitByTime>("to_CnsldtnUnitByTime");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnitByTimeVersion</b> navigation property to query
     * operations.
     *
     */
    public final static ConsolidationUnitLink<ConsolidationUnitByTimeVersion> TO_CNSLDTN_UNIT_BY_TIME_VERSION =
        new ConsolidationUnitLink<ConsolidationUnitByTimeVersion>("to_CnsldtnUnitByTimeVersion");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ConsolidationUnitLink<ConsolidationUnitText> TO_TEXT =
        new ConsolidationUnitLink<ConsolidationUnitText>("to_Text");

    @Nonnull
    @Override
    public Class<ConsolidationUnit> getType()
    {
        return ConsolidationUnit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region in Consolidation
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLink</b>
     * </p>
     *
     * @param consolidationUnitLink
     *            Link URL
     */
    public void setConsolidationUnitLink( @Nullable final String consolidationUnitLink )
    {
        rememberChangedField("ConsolidationUnitLink", this.consolidationUnitLink);
        this.consolidationUnitLink = consolidationUnitLink;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLinkLabel</b>
     * </p>
     *
     * @param consolidationUnitLinkLabel
     *            Link Title
     */
    public void setConsolidationUnitLinkLabel( @Nullable final String consolidationUnitLinkLabel )
    {
        rememberChangedField("ConsolidationUnitLinkLabel", this.consolidationUnitLinkLabel);
        this.consolidationUnitLinkLabel = consolidationUnitLinkLabel;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationUnit";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("Country", getCountry());
        values.put("ConsolidationUnitLink", getConsolidationUnitLink());
        values.put("ConsolidationUnitLinkLabel", getConsolidationUnitLinkLabel());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLink") ) {
                final Object value = values.remove("ConsolidationUnitLink");
                if( (value == null) || (!value.equals(getConsolidationUnitLink())) ) {
                    setConsolidationUnitLink(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLinkLabel") ) {
                final Object value = values.remove("ConsolidationUnitLinkLabel");
                if( (value == null) || (!value.equals(getConsolidationUnitLinkLabel())) ) {
                    setConsolidationUnitLinkLabel(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnitByTime") ) {
                final Object value = (values).remove("to_CnsldtnUnitByTime");
                if( value instanceof Iterable ) {
                    if( toCnsldtnUnitByTime == null ) {
                        toCnsldtnUnitByTime = Lists.newArrayList();
                    } else {
                        toCnsldtnUnitByTime = Lists.newArrayList(toCnsldtnUnitByTime);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationUnitByTime entity;
                        if( toCnsldtnUnitByTime.size() > i ) {
                            entity = toCnsldtnUnitByTime.get(i);
                        } else {
                            entity = new ConsolidationUnitByTime();
                            toCnsldtnUnitByTime.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnUnitByTimeVersion") ) {
                final Object value = (values).remove("to_CnsldtnUnitByTimeVersion");
                if( value instanceof Iterable ) {
                    if( toCnsldtnUnitByTimeVersion == null ) {
                        toCnsldtnUnitByTimeVersion = Lists.newArrayList();
                    } else {
                        toCnsldtnUnitByTimeVersion = Lists.newArrayList(toCnsldtnUnitByTimeVersion);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationUnitByTimeVersion entity;
                        if( toCnsldtnUnitByTimeVersion.size() > i ) {
                            entity = toCnsldtnUnitByTimeVersion.get(i);
                        } else {
                            entity = new ConsolidationUnitByTimeVersion();
                            toCnsldtnUnitByTimeVersion.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConsolidationUnitText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ConsolidationUnitText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationUnitField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationUnitField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationUnitField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationUnitField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnitByTime != null ) {
            (values).put("to_CnsldtnUnitByTime", toCnsldtnUnitByTime);
        }
        if( toCnsldtnUnitByTimeVersion != null ) {
            (values).put("to_CnsldtnUnitByTimeVersion", toCnsldtnUnitByTimeVersion);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationUnitByTime</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnUnitByTime</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationUnitByTime</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitByTime> fetchCnsldtnUnitByTime()
    {
        return fetchFieldAsList("to_CnsldtnUnitByTime", ConsolidationUnitByTime.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitByTime</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitByTime</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitByTime</b> of a queried <b>ConsolidationUnit</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnitByTime</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitByTime> getCnsldtnUnitByTimeOrFetch()
    {
        if( toCnsldtnUnitByTime == null ) {
            toCnsldtnUnitByTime = fetchCnsldtnUnitByTime();
        }
        return toCnsldtnUnitByTime;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitByTime</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitByTime</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitByTime</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnitByTime</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationUnitByTime>> getCnsldtnUnitByTimeIfPresent()
    {
        return Option.of(toCnsldtnUnitByTime);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationUnitByTime</b> entities for the loaded navigation property
     * <b>to_CnsldtnUnitByTime</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitByTime</b> of a queried <b>ConsolidationUnit</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationUnitByTime</b> entities.
     */
    public void setCnsldtnUnitByTime( @Nonnull final List<ConsolidationUnitByTime> value )
    {
        if( toCnsldtnUnitByTime == null ) {
            toCnsldtnUnitByTime = Lists.newArrayList();
        }
        toCnsldtnUnitByTime.clear();
        toCnsldtnUnitByTime.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationUnitByTime</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnUnitByTime</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitByTime</b> of a queried <b>ConsolidationUnit</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationUnitByTime</b> entities.
     */
    public void addCnsldtnUnitByTime( ConsolidationUnitByTime... entity )
    {
        if( toCnsldtnUnitByTime == null ) {
            toCnsldtnUnitByTime = Lists.newArrayList();
        }
        toCnsldtnUnitByTime.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ConsolidationUnitByTimeVersion</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CnsldtnUnitByTimeVersion</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationUnitByTimeVersion</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitByTimeVersion> fetchCnsldtnUnitByTimeVersion()
    {
        return fetchFieldAsList("to_CnsldtnUnitByTimeVersion", ConsolidationUnitByTimeVersion.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitByTimeVersion</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_CnsldtnUnitByTimeVersion</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitByTimeVersion</b> of a queried <b>ConsolidationUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnitByTimeVersion</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitByTimeVersion> getCnsldtnUnitByTimeVersionOrFetch()
    {
        if( toCnsldtnUnitByTimeVersion == null ) {
            toCnsldtnUnitByTimeVersion = fetchCnsldtnUnitByTimeVersion();
        }
        return toCnsldtnUnitByTimeVersion;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitByTimeVersion</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_CnsldtnUnitByTimeVersion</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnitByTimeVersion</b> is already loaded, the
     *         result will contain the <b>ConsolidationUnitByTimeVersion</b> entities. If not, an <code>Option</code>
     *         with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationUnitByTimeVersion>> getCnsldtnUnitByTimeVersionIfPresent()
    {
        return Option.of(toCnsldtnUnitByTimeVersion);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationUnitByTimeVersion</b> entities for the loaded navigation
     * property <b>to_CnsldtnUnitByTimeVersion</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitByTimeVersion</b> of a queried <b>ConsolidationUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationUnitByTimeVersion</b> entities.
     */
    public void setCnsldtnUnitByTimeVersion( @Nonnull final List<ConsolidationUnitByTimeVersion> value )
    {
        if( toCnsldtnUnitByTimeVersion == null ) {
            toCnsldtnUnitByTimeVersion = Lists.newArrayList();
        }
        toCnsldtnUnitByTimeVersion.clear();
        toCnsldtnUnitByTimeVersion.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationUnitByTimeVersion</b> entities. This corresponds to the
     * OData navigation property <b>to_CnsldtnUnitByTimeVersion</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnitByTimeVersion</b> of a queried <b>ConsolidationUnit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationUnitByTimeVersion</b> entities.
     */
    public void addCnsldtnUnitByTimeVersion( ConsolidationUnitByTimeVersion... entity )
    {
        if( toCnsldtnUnitByTimeVersion == null ) {
            toCnsldtnUnitByTimeVersion = Lists.newArrayList();
        }
        toCnsldtnUnitByTimeVersion.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ConsolidationUnitText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ConsolidationUnitText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitText> fetchText()
    {
        return fetchFieldAsList("to_Text", ConsolidationUnitText.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnitText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ConsolidationUnitText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnitText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ConsolidationUnitText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConsolidationUnitText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ConsolidationUnitText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ConsolidationUnitText</b> entities.
     */
    public void setText( @Nonnull final List<ConsolidationUnitText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConsolidationUnitText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ConsolidationUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ConsolidationUnitText</b> entities.
     */
    public void addText( ConsolidationUnitText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationUnit instances.
     *
     */
    public final static class ConsolidationUnitBuilder
    {

        private List<ConsolidationUnitByTime> toCnsldtnUnitByTime = Lists.newArrayList();
        private List<ConsolidationUnitByTimeVersion> toCnsldtnUnitByTimeVersion = Lists.newArrayList();
        private List<ConsolidationUnitText> toText = Lists.newArrayList();

        private ConsolidationUnit.ConsolidationUnitBuilder toCnsldtnUnitByTime(
            final List<ConsolidationUnitByTime> value )
        {
            toCnsldtnUnitByTime.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitByTime</b> for <b>ConsolidationUnit</b> to multiple
         * <b>ConsolidationUnitByTime</b>.
         *
         * @param value
         *            The ConsolidationUnitByTimes to build this ConsolidationUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnit.ConsolidationUnitBuilder cnsldtnUnitByTime( ConsolidationUnitByTime... value )
        {
            return toCnsldtnUnitByTime(Lists.newArrayList(value));
        }

        private ConsolidationUnit.ConsolidationUnitBuilder toCnsldtnUnitByTimeVersion(
            final List<ConsolidationUnitByTimeVersion> value )
        {
            toCnsldtnUnitByTimeVersion.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnitByTimeVersion</b> for <b>ConsolidationUnit</b> to multiple
         * <b>ConsolidationUnitByTimeVersion</b>.
         *
         * @param value
         *            The ConsolidationUnitByTimeVersions to build this ConsolidationUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnit.ConsolidationUnitBuilder cnsldtnUnitByTimeVersion(
            ConsolidationUnitByTimeVersion... value )
        {
            return toCnsldtnUnitByTimeVersion(Lists.newArrayList(value));
        }

        private ConsolidationUnit.ConsolidationUnitBuilder toText( final List<ConsolidationUnitText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ConsolidationUnit</b> to multiple <b>ConsolidationUnitText</b>.
         *
         * @param value
         *            The ConsolidationUnitTexts to build this ConsolidationUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnit.ConsolidationUnitBuilder text( ConsolidationUnitText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
