/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.field.ConsolidationUnitByTimeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.link.ConsolidationUnitByTimeOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable.ConsolidationUnitByTimeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit by Time
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationUnitByTimeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationUnitByTime extends VdmEntity<ConsolidationUnitByTime>
{

    /**
     * Selector for all available fields of ConsolidationUnitByTime.
     *
     */
    public final static ConsolidationUnitByTimeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeField<String> CONSOLIDATION_UNIT =
        new ConsolidationUnitByTimeField<String>("ConsolidationUnit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FromFiscalYearPeriod</b>
     * </p>
     *
     * @return From Fiscal Year Period
     */
    @Key
    @SerializedName( "FromFiscalYearPeriod" )
    @JsonProperty( "FromFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FromFiscalYearPeriod" )
    private String fromFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FromFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeField<String> FROM_FISCAL_YEAR_PERIOD =
        new ConsolidationUnitByTimeField<String>("FromFiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ToFiscalYearPeriod</b>
     * </p>
     *
     * @return To Fiscal Year Period
     */
    @SerializedName( "ToFiscalYearPeriod" )
    @JsonProperty( "ToFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "ToFiscalYearPeriod" )
    private String toFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ToFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeField<String> TO_FISCAL_YEAR_PERIOD =
        new ConsolidationUnitByTimeField<String>("ToFiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @return Consolidation Local Currency
     */
    @SerializedName( "ConsolidationUnitLocalCurrency" )
    @JsonProperty( "ConsolidationUnitLocalCurrency" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitLocalCurrency" )
    private String consolidationUnitLocalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitLocalCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeField<String> CONSOLIDATION_UNIT_LOCAL_CURRENCY =
        new ConsolidationUnitByTimeField<String>("ConsolidationUnitLocalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @return Company in Consolidation
     */
    @SerializedName( "Company" )
    @JsonProperty( "Company" )
    @Nullable
    @ODataField( odataName = "Company" )
    private String company;
    /**
     * Use with available fluent helpers to apply the <b>Company</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeField<String> COMPANY =
        new ConsolidationUnitByTimeField<String>("Company");
    /**
     * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitByTime</b> to single <b>ConsolidationUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnit" )
    @JsonProperty( "to_CnsldtnUnit" )
    @ODataField( odataName = "to_CnsldtnUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationUnit toCnsldtnUnit;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnit</b> navigation property to query operations.
     *
     */
    public final static ConsolidationUnitByTimeOneToOneLink<ConsolidationUnit> TO_CNSLDTN_UNIT =
        new ConsolidationUnitByTimeOneToOneLink<ConsolidationUnit>("to_CnsldtnUnit");

    @Nonnull
    @Override
    public Class<ConsolidationUnitByTime> getType()
    {
        return ConsolidationUnitByTime.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FromFiscalYearPeriod</b>
     * </p>
     *
     * @param fromFiscalYearPeriod
     *            From Fiscal Year Period
     */
    public void setFromFiscalYearPeriod( @Nullable final String fromFiscalYearPeriod )
    {
        rememberChangedField("FromFiscalYearPeriod", this.fromFiscalYearPeriod);
        this.fromFiscalYearPeriod = fromFiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ToFiscalYearPeriod</b>
     * </p>
     *
     * @param toFiscalYearPeriod
     *            To Fiscal Year Period
     */
    public void setToFiscalYearPeriod( @Nullable final String toFiscalYearPeriod )
    {
        rememberChangedField("ToFiscalYearPeriod", this.toFiscalYearPeriod);
        this.toFiscalYearPeriod = toFiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitLocalCurrency</b>
     * </p>
     *
     * @param consolidationUnitLocalCurrency
     *            Consolidation Local Currency
     */
    public void setConsolidationUnitLocalCurrency( @Nullable final String consolidationUnitLocalCurrency )
    {
        rememberChangedField("ConsolidationUnitLocalCurrency", this.consolidationUnitLocalCurrency);
        this.consolidationUnitLocalCurrency = consolidationUnitLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @param company
     *            Company in Consolidation
     */
    public void setCompany( @Nullable final String company )
    {
        rememberChangedField("Company", this.company);
        this.company = company;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationUnitByTime";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        result.put("FromFiscalYearPeriod", getFromFiscalYearPeriod());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("FromFiscalYearPeriod", getFromFiscalYearPeriod());
        values.put("ToFiscalYearPeriod", getToFiscalYearPeriod());
        values.put("ConsolidationUnitLocalCurrency", getConsolidationUnitLocalCurrency());
        values.put("Company", getCompany());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("FromFiscalYearPeriod") ) {
                final Object value = values.remove("FromFiscalYearPeriod");
                if( (value == null) || (!value.equals(getFromFiscalYearPeriod())) ) {
                    setFromFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("ToFiscalYearPeriod") ) {
                final Object value = values.remove("ToFiscalYearPeriod");
                if( (value == null) || (!value.equals(getToFiscalYearPeriod())) ) {
                    setToFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitLocalCurrency") ) {
                final Object value = values.remove("ConsolidationUnitLocalCurrency");
                if( (value == null) || (!value.equals(getConsolidationUnitLocalCurrency())) ) {
                    setConsolidationUnitLocalCurrency(((String) value));
                }
            }
            if( values.containsKey("Company") ) {
                final Object value = values.remove("Company");
                if( (value == null) || (!value.equals(getCompany())) ) {
                    setCompany(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnit") ) {
                final Object value = (values).remove("to_CnsldtnUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnUnit == null ) {
                        toCnsldtnUnit = new ConsolidationUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ConsolidationUnitByTimeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationUnitByTimeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationUnitByTimeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationUnitByTimeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnit != null ) {
            (values).put("to_CnsldtnUnit", toCnsldtnUnit);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationUnit</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit fetchCnsldtnUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnUnit", ConsolidationUnit.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnit</b> of a queried <b>ConsolidationUnitByTime</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit getCnsldtnUnitOrFetch()
    {
        if( toCnsldtnUnit == null ) {
            toCnsldtnUnit = fetchCnsldtnUnit();
        }
        return toCnsldtnUnit;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnitByTime</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnit</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationUnit> getCnsldtnUnitIfPresent()
    {
        return Option.of(toCnsldtnUnit);
    }

    /**
     * Overwrites the associated <b>ConsolidationUnit</b> entity for the loaded navigation property
     * <b>to_CnsldtnUnit</b>.
     *
     * @param value
     *            New <b>ConsolidationUnit</b> entity.
     */
    public void setCnsldtnUnit( final ConsolidationUnit value )
    {
        toCnsldtnUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationUnitByTime instances.
     *
     */
    public final static class ConsolidationUnitByTimeBuilder
    {

        private ConsolidationUnit toCnsldtnUnit;

        private ConsolidationUnitByTime.ConsolidationUnitByTimeBuilder toCnsldtnUnit( final ConsolidationUnit value )
        {
            toCnsldtnUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitByTime</b> to single
         * <b>ConsolidationUnit</b>.
         *
         * @param value
         *            The ConsolidationUnit to build this ConsolidationUnitByTime with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnitByTime.ConsolidationUnitByTimeBuilder cnsldtnUnit( final ConsolidationUnit value )
        {
            return toCnsldtnUnit(value);
        }

    }

}
