/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable.ConsolidationUnitByTimeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime
 * ConsolidationUnitByTime} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ConsolidationUnitByTimeByKeyFluentHelper
    extends
    FluentHelperByKey<ConsolidationUnitByTimeByKeyFluentHelper, ConsolidationUnitByTime, ConsolidationUnitByTimeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime
     * ConsolidationUnitByTime} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ConsolidationUnitByTime}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ConsolidationUnitByTime}
     * @param fromFiscalYearPeriod
     *            From Fiscal Year Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param consolidationUnit
     *            Consolidation Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public ConsolidationUnitByTimeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationUnit,
        final String fromFiscalYearPeriod )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationUnit", consolidationUnit);
        this.key.put("FromFiscalYearPeriod", fromFiscalYearPeriod);
    }

    @Override
    @Nonnull
    protected Class<ConsolidationUnitByTime> getEntityClass()
    {
        return ConsolidationUnitByTime.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
