/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.field.ConsolidationUnitByTimeVersionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.link.ConsolidationUnitByTimeVersionOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable.ConsolidationUnitByTimeVersionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Unit by Time and Version
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConsolidationUnitByTimeVersionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ConsolidationUnitByTimeVersion extends VdmEntity<ConsolidationUnitByTimeVersion>
{

    /**
     * Selector for all available fields of ConsolidationUnitByTimeVersion.
     *
     */
    public final static ConsolidationUnitByTimeVersionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @return Consolidation Unit
     */
    @Key
    @SerializedName( "ConsolidationUnit" )
    @JsonProperty( "ConsolidationUnit" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnit" )
    private String consolidationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnit</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CONSOLIDATION_UNIT =
        new ConsolidationUnitByTimeVersionField<String>("ConsolidationUnit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @return Consolidation Version
     */
    @Key
    @SerializedName( "ConsolidationVersion" )
    @JsonProperty( "ConsolidationVersion" )
    @Nullable
    @ODataField( odataName = "ConsolidationVersion" )
    private String consolidationVersion;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationVersion</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CONSOLIDATION_VERSION =
        new ConsolidationUnitByTimeVersionField<String>("ConsolidationVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FromFiscalYearPeriod</b>
     * </p>
     *
     * @return From Fiscal Year Period
     */
    @Key
    @SerializedName( "FromFiscalYearPeriod" )
    @JsonProperty( "FromFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FromFiscalYearPeriod" )
    private String fromFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FromFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> FROM_FISCAL_YEAR_PERIOD =
        new ConsolidationUnitByTimeVersionField<String>("FromFiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ToFiscalYearPeriod</b>
     * </p>
     *
     * @return To Fiscal Year Period
     */
    @SerializedName( "ToFiscalYearPeriod" )
    @JsonProperty( "ToFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "ToFiscalYearPeriod" )
    private String toFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ToFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> TO_FISCAL_YEAR_PERIOD =
        new ConsolidationUnitByTimeVersionField<String>("ToFiscalYearPeriod");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitIsPartnerOnly</b>
     * </p>
     *
     * @return Consolidation Unit is Partner Unit Only
     */
    @SerializedName( "ConsolidationUnitIsPartnerOnly" )
    @JsonProperty( "ConsolidationUnitIsPartnerOnly" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConsolidationUnitIsPartnerOnly" )
    private Boolean consolidationUnitIsPartnerOnly;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitIsPartnerOnly</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<Boolean> CONSOLIDATION_UNIT_IS_PARTNER_ONLY =
        new ConsolidationUnitByTimeVersionField<Boolean>("ConsolidationUnitIsPartnerOnly");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnCrcyTranslationMethod</b>
     * </p>
     *
     * @return Currency Translation Method
     */
    @SerializedName( "CnsldtnCrcyTranslationMethod" )
    @JsonProperty( "CnsldtnCrcyTranslationMethod" )
    @Nullable
    @ODataField( odataName = "CnsldtnCrcyTranslationMethod" )
    private String cnsldtnCrcyTranslationMethod;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnCrcyTranslationMethod</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CNSLDTN_CRCY_TRANSLATION_METHOD =
        new ConsolidationUnitByTimeVersionField<String>("CnsldtnCrcyTranslationMethod");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxRate</b>
     * </p>
     *
     * @return Tax Rate
     */
    @SerializedName( "TaxRate" )
    @JsonProperty( "TaxRate" )
    @Nullable
    @ODataField( odataName = "TaxRate" )
    private BigDecimal taxRate;
    /**
     * Use with available fluent helpers to apply the <b>TaxRate</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<BigDecimal> TAX_RATE =
        new ConsolidationUnitByTimeVersionField<BigDecimal>("TaxRate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Deviating Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> FISCAL_YEAR_VARIANT =
        new ConsolidationUnitByTimeVersionField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnDataTransferMethod</b>
     * </p>
     *
     * @return Universal Journal Integration
     */
    @SerializedName( "CnsldtnDataTransferMethod" )
    @JsonProperty( "CnsldtnDataTransferMethod" )
    @Nullable
    @ODataField( odataName = "CnsldtnDataTransferMethod" )
    private String cnsldtnDataTransferMethod;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnDataTransferMethod</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CNSLDTN_DATA_TRANSFER_METHOD =
        new ConsolidationUnitByTimeVersionField<String>("CnsldtnDataTransferMethod");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentEntryIsInGroupCurrency</b>
     * </p>
     *
     * @return Group Currency is Leading Currency
     */
    @SerializedName( "DocumentEntryIsInGroupCurrency" )
    @JsonProperty( "DocumentEntryIsInGroupCurrency" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocumentEntryIsInGroupCurrency" )
    private Boolean documentEntryIsInGroupCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentEntryIsInGroupCurrency</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<Boolean> DOCUMENT_ENTRY_IS_IN_GROUP_CURRENCY =
        new ConsolidationUnitByTimeVersionField<Boolean>("DocumentEntryIsInGroupCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitLocalCrcySource</b>
     * </p>
     *
     * @return Source for Local Currency Key Figure
     */
    @SerializedName( "CnsldtnUnitLocalCrcySource" )
    @JsonProperty( "CnsldtnUnitLocalCrcySource" )
    @Nullable
    @ODataField( odataName = "CnsldtnUnitLocalCrcySource" )
    private String cnsldtnUnitLocalCrcySource;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnUnitLocalCrcySource</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CNSLDTN_UNIT_LOCAL_CRCY_SOURCE =
        new ConsolidationUnitByTimeVersionField<String>("CnsldtnUnitLocalCrcySource");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitGroupCrcySource</b>
     * </p>
     *
     * @return Source for Group Currency Key Figure
     */
    @SerializedName( "CnsldtnUnitGroupCrcySource" )
    @JsonProperty( "CnsldtnUnitGroupCrcySource" )
    @Nullable
    @ODataField( odataName = "CnsldtnUnitGroupCrcySource" )
    private String cnsldtnUnitGroupCrcySource;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnUnitGroupCrcySource</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CNSLDTN_UNIT_GROUP_CRCY_SOURCE =
        new ConsolidationUnitByTimeVersionField<String>("CnsldtnUnitGroupCrcySource");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUploadMethod</b>
     * </p>
     *
     * @return Upload Method
     */
    @SerializedName( "CnsldtnUploadMethod" )
    @JsonProperty( "CnsldtnUploadMethod" )
    @Nullable
    @ODataField( odataName = "CnsldtnUploadMethod" )
    private String cnsldtnUploadMethod;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnUploadMethod</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CNSLDTN_UPLOAD_METHOD =
        new ConsolidationUnitByTimeVersionField<String>("CnsldtnUploadMethod");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitDataCollection</b>
     * </p>
     *
     * @return Data Collection Selection Attribute
     */
    @SerializedName( "CnsldtnUnitDataCollection" )
    @JsonProperty( "CnsldtnUnitDataCollection" )
    @Nullable
    @ODataField( odataName = "CnsldtnUnitDataCollection" )
    private String cnsldtnUnitDataCollection;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnUnitDataCollection</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CNSLDTN_UNIT_DATA_COLLECTION =
        new ConsolidationUnitByTimeVersionField<String>("CnsldtnUnitDataCollection");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitPartner</b>
     * </p>
     *
     * @return Partner Selection Attribute
     */
    @SerializedName( "ConsolidationUnitPartner" )
    @JsonProperty( "ConsolidationUnitPartner" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitPartner" )
    private String consolidationUnitPartner;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitPartner</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CONSOLIDATION_UNIT_PARTNER =
        new ConsolidationUnitByTimeVersionField<String>("ConsolidationUnitPartner");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitPostingRule</b>
     * </p>
     *
     * @return Posting Rule Selection Attribute
     */
    @SerializedName( "ConsolidationUnitPostingRule" )
    @JsonProperty( "ConsolidationUnitPostingRule" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitPostingRule" )
    private String consolidationUnitPostingRule;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitPostingRule</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CONSOLIDATION_UNIT_POSTING_RULE =
        new ConsolidationUnitByTimeVersionField<String>("ConsolidationUnitPostingRule");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitValidation</b>
     * </p>
     *
     * @return Validation Selection Attribute
     */
    @SerializedName( "ConsolidationUnitValidation" )
    @JsonProperty( "ConsolidationUnitValidation" )
    @Nullable
    @ODataField( odataName = "ConsolidationUnitValidation" )
    private String consolidationUnitValidation;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationUnitValidation</b> field to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionField<String> CONSOLIDATION_UNIT_VALIDATION =
        new ConsolidationUnitByTimeVersionField<String>("ConsolidationUnitValidation");
    /**
     * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitByTimeVersion</b> to single
     * <b>ConsolidationUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnUnit" )
    @JsonProperty( "to_CnsldtnUnit" )
    @ODataField( odataName = "to_CnsldtnUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConsolidationUnit toCnsldtnUnit;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnUnit</b> navigation property to query operations.
     *
     */
    public final static ConsolidationUnitByTimeVersionOneToOneLink<ConsolidationUnit> TO_CNSLDTN_UNIT =
        new ConsolidationUnitByTimeVersionOneToOneLink<ConsolidationUnit>("to_CnsldtnUnit");

    @Nonnull
    @Override
    public Class<ConsolidationUnitByTimeVersion> getType()
    {
        return ConsolidationUnitByTimeVersion.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnit</b>
     * </p>
     *
     * @param consolidationUnit
     *            Consolidation Unit
     */
    public void setConsolidationUnit( @Nullable final String consolidationUnit )
    {
        rememberChangedField("ConsolidationUnit", this.consolidationUnit);
        this.consolidationUnit = consolidationUnit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationVersion</b>
     * </p>
     *
     * @param consolidationVersion
     *            Consolidation Version
     */
    public void setConsolidationVersion( @Nullable final String consolidationVersion )
    {
        rememberChangedField("ConsolidationVersion", this.consolidationVersion);
        this.consolidationVersion = consolidationVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FromFiscalYearPeriod</b>
     * </p>
     *
     * @param fromFiscalYearPeriod
     *            From Fiscal Year Period
     */
    public void setFromFiscalYearPeriod( @Nullable final String fromFiscalYearPeriod )
    {
        rememberChangedField("FromFiscalYearPeriod", this.fromFiscalYearPeriod);
        this.fromFiscalYearPeriod = fromFiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ToFiscalYearPeriod</b>
     * </p>
     *
     * @param toFiscalYearPeriod
     *            To Fiscal Year Period
     */
    public void setToFiscalYearPeriod( @Nullable final String toFiscalYearPeriod )
    {
        rememberChangedField("ToFiscalYearPeriod", this.toFiscalYearPeriod);
        this.toFiscalYearPeriod = toFiscalYearPeriod;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitIsPartnerOnly</b>
     * </p>
     *
     * @param consolidationUnitIsPartnerOnly
     *            Consolidation Unit is Partner Unit Only
     */
    public void setConsolidationUnitIsPartnerOnly( @Nullable final Boolean consolidationUnitIsPartnerOnly )
    {
        rememberChangedField("ConsolidationUnitIsPartnerOnly", this.consolidationUnitIsPartnerOnly);
        this.consolidationUnitIsPartnerOnly = consolidationUnitIsPartnerOnly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnCrcyTranslationMethod</b>
     * </p>
     *
     * @param cnsldtnCrcyTranslationMethod
     *            Currency Translation Method
     */
    public void setCnsldtnCrcyTranslationMethod( @Nullable final String cnsldtnCrcyTranslationMethod )
    {
        rememberChangedField("CnsldtnCrcyTranslationMethod", this.cnsldtnCrcyTranslationMethod);
        this.cnsldtnCrcyTranslationMethod = cnsldtnCrcyTranslationMethod;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxRate</b>
     * </p>
     *
     * @param taxRate
     *            Tax Rate
     */
    public void setTaxRate( @Nullable final BigDecimal taxRate )
    {
        rememberChangedField("TaxRate", this.taxRate);
        this.taxRate = taxRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Deviating Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnDataTransferMethod</b>
     * </p>
     *
     * @param cnsldtnDataTransferMethod
     *            Universal Journal Integration
     */
    public void setCnsldtnDataTransferMethod( @Nullable final String cnsldtnDataTransferMethod )
    {
        rememberChangedField("CnsldtnDataTransferMethod", this.cnsldtnDataTransferMethod);
        this.cnsldtnDataTransferMethod = cnsldtnDataTransferMethod;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentEntryIsInGroupCurrency</b>
     * </p>
     *
     * @param documentEntryIsInGroupCurrency
     *            Group Currency is Leading Currency
     */
    public void setDocumentEntryIsInGroupCurrency( @Nullable final Boolean documentEntryIsInGroupCurrency )
    {
        rememberChangedField("DocumentEntryIsInGroupCurrency", this.documentEntryIsInGroupCurrency);
        this.documentEntryIsInGroupCurrency = documentEntryIsInGroupCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitLocalCrcySource</b>
     * </p>
     *
     * @param cnsldtnUnitLocalCrcySource
     *            Source for Local Currency Key Figure
     */
    public void setCnsldtnUnitLocalCrcySource( @Nullable final String cnsldtnUnitLocalCrcySource )
    {
        rememberChangedField("CnsldtnUnitLocalCrcySource", this.cnsldtnUnitLocalCrcySource);
        this.cnsldtnUnitLocalCrcySource = cnsldtnUnitLocalCrcySource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitGroupCrcySource</b>
     * </p>
     *
     * @param cnsldtnUnitGroupCrcySource
     *            Source for Group Currency Key Figure
     */
    public void setCnsldtnUnitGroupCrcySource( @Nullable final String cnsldtnUnitGroupCrcySource )
    {
        rememberChangedField("CnsldtnUnitGroupCrcySource", this.cnsldtnUnitGroupCrcySource);
        this.cnsldtnUnitGroupCrcySource = cnsldtnUnitGroupCrcySource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUploadMethod</b>
     * </p>
     *
     * @param cnsldtnUploadMethod
     *            Upload Method
     */
    public void setCnsldtnUploadMethod( @Nullable final String cnsldtnUploadMethod )
    {
        rememberChangedField("CnsldtnUploadMethod", this.cnsldtnUploadMethod);
        this.cnsldtnUploadMethod = cnsldtnUploadMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnUnitDataCollection</b>
     * </p>
     *
     * @param cnsldtnUnitDataCollection
     *            Data Collection Selection Attribute
     */
    public void setCnsldtnUnitDataCollection( @Nullable final String cnsldtnUnitDataCollection )
    {
        rememberChangedField("CnsldtnUnitDataCollection", this.cnsldtnUnitDataCollection);
        this.cnsldtnUnitDataCollection = cnsldtnUnitDataCollection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitPartner</b>
     * </p>
     *
     * @param consolidationUnitPartner
     *            Partner Selection Attribute
     */
    public void setConsolidationUnitPartner( @Nullable final String consolidationUnitPartner )
    {
        rememberChangedField("ConsolidationUnitPartner", this.consolidationUnitPartner);
        this.consolidationUnitPartner = consolidationUnitPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitPostingRule</b>
     * </p>
     *
     * @param consolidationUnitPostingRule
     *            Posting Rule Selection Attribute
     */
    public void setConsolidationUnitPostingRule( @Nullable final String consolidationUnitPostingRule )
    {
        rememberChangedField("ConsolidationUnitPostingRule", this.consolidationUnitPostingRule);
        this.consolidationUnitPostingRule = consolidationUnitPostingRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationUnitValidation</b>
     * </p>
     *
     * @param consolidationUnitValidation
     *            Validation Selection Attribute
     */
    public void setConsolidationUnitValidation( @Nullable final String consolidationUnitValidation )
    {
        rememberChangedField("ConsolidationUnitValidation", this.consolidationUnitValidation);
        this.consolidationUnitValidation = consolidationUnitValidation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ConsolidationUnitByTimeVersion";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationUnit", getConsolidationUnit());
        result.put("ConsolidationVersion", getConsolidationVersion());
        result.put("FromFiscalYearPeriod", getFromFiscalYearPeriod());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationUnit", getConsolidationUnit());
        values.put("ConsolidationVersion", getConsolidationVersion());
        values.put("FromFiscalYearPeriod", getFromFiscalYearPeriod());
        values.put("ToFiscalYearPeriod", getToFiscalYearPeriod());
        values.put("ConsolidationUnitIsPartnerOnly", getConsolidationUnitIsPartnerOnly());
        values.put("CnsldtnCrcyTranslationMethod", getCnsldtnCrcyTranslationMethod());
        values.put("TaxRate", getTaxRate());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("CnsldtnDataTransferMethod", getCnsldtnDataTransferMethod());
        values.put("DocumentEntryIsInGroupCurrency", getDocumentEntryIsInGroupCurrency());
        values.put("CnsldtnUnitLocalCrcySource", getCnsldtnUnitLocalCrcySource());
        values.put("CnsldtnUnitGroupCrcySource", getCnsldtnUnitGroupCrcySource());
        values.put("CnsldtnUploadMethod", getCnsldtnUploadMethod());
        values.put("CnsldtnUnitDataCollection", getCnsldtnUnitDataCollection());
        values.put("ConsolidationUnitPartner", getConsolidationUnitPartner());
        values.put("ConsolidationUnitPostingRule", getConsolidationUnitPostingRule());
        values.put("ConsolidationUnitValidation", getConsolidationUnitValidation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationUnit") ) {
                final Object value = values.remove("ConsolidationUnit");
                if( (value == null) || (!value.equals(getConsolidationUnit())) ) {
                    setConsolidationUnit(((String) value));
                }
            }
            if( values.containsKey("ConsolidationVersion") ) {
                final Object value = values.remove("ConsolidationVersion");
                if( (value == null) || (!value.equals(getConsolidationVersion())) ) {
                    setConsolidationVersion(((String) value));
                }
            }
            if( values.containsKey("FromFiscalYearPeriod") ) {
                final Object value = values.remove("FromFiscalYearPeriod");
                if( (value == null) || (!value.equals(getFromFiscalYearPeriod())) ) {
                    setFromFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("ToFiscalYearPeriod") ) {
                final Object value = values.remove("ToFiscalYearPeriod");
                if( (value == null) || (!value.equals(getToFiscalYearPeriod())) ) {
                    setToFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitIsPartnerOnly") ) {
                final Object value = values.remove("ConsolidationUnitIsPartnerOnly");
                if( (value == null) || (!value.equals(getConsolidationUnitIsPartnerOnly())) ) {
                    setConsolidationUnitIsPartnerOnly(((Boolean) value));
                }
            }
            if( values.containsKey("CnsldtnCrcyTranslationMethod") ) {
                final Object value = values.remove("CnsldtnCrcyTranslationMethod");
                if( (value == null) || (!value.equals(getCnsldtnCrcyTranslationMethod())) ) {
                    setCnsldtnCrcyTranslationMethod(((String) value));
                }
            }
            if( values.containsKey("TaxRate") ) {
                final Object value = values.remove("TaxRate");
                if( (value == null) || (!value.equals(getTaxRate())) ) {
                    setTaxRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("CnsldtnDataTransferMethod") ) {
                final Object value = values.remove("CnsldtnDataTransferMethod");
                if( (value == null) || (!value.equals(getCnsldtnDataTransferMethod())) ) {
                    setCnsldtnDataTransferMethod(((String) value));
                }
            }
            if( values.containsKey("DocumentEntryIsInGroupCurrency") ) {
                final Object value = values.remove("DocumentEntryIsInGroupCurrency");
                if( (value == null) || (!value.equals(getDocumentEntryIsInGroupCurrency())) ) {
                    setDocumentEntryIsInGroupCurrency(((Boolean) value));
                }
            }
            if( values.containsKey("CnsldtnUnitLocalCrcySource") ) {
                final Object value = values.remove("CnsldtnUnitLocalCrcySource");
                if( (value == null) || (!value.equals(getCnsldtnUnitLocalCrcySource())) ) {
                    setCnsldtnUnitLocalCrcySource(((String) value));
                }
            }
            if( values.containsKey("CnsldtnUnitGroupCrcySource") ) {
                final Object value = values.remove("CnsldtnUnitGroupCrcySource");
                if( (value == null) || (!value.equals(getCnsldtnUnitGroupCrcySource())) ) {
                    setCnsldtnUnitGroupCrcySource(((String) value));
                }
            }
            if( values.containsKey("CnsldtnUploadMethod") ) {
                final Object value = values.remove("CnsldtnUploadMethod");
                if( (value == null) || (!value.equals(getCnsldtnUploadMethod())) ) {
                    setCnsldtnUploadMethod(((String) value));
                }
            }
            if( values.containsKey("CnsldtnUnitDataCollection") ) {
                final Object value = values.remove("CnsldtnUnitDataCollection");
                if( (value == null) || (!value.equals(getCnsldtnUnitDataCollection())) ) {
                    setCnsldtnUnitDataCollection(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitPartner") ) {
                final Object value = values.remove("ConsolidationUnitPartner");
                if( (value == null) || (!value.equals(getConsolidationUnitPartner())) ) {
                    setConsolidationUnitPartner(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitPostingRule") ) {
                final Object value = values.remove("ConsolidationUnitPostingRule");
                if( (value == null) || (!value.equals(getConsolidationUnitPostingRule())) ) {
                    setConsolidationUnitPostingRule(((String) value));
                }
            }
            if( values.containsKey("ConsolidationUnitValidation") ) {
                final Object value = values.remove("ConsolidationUnitValidation");
                if( (value == null) || (!value.equals(getConsolidationUnitValidation())) ) {
                    setConsolidationUnitValidation(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnUnit") ) {
                final Object value = (values).remove("to_CnsldtnUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnUnit == null ) {
                        toCnsldtnUnit = new ConsolidationUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ConsolidationUnitByTimeVersionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ConsolidationUnitByTimeVersionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ConsolidationUnitByTimeVersionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ConsolidationUnitByTimeVersionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnUnit != null ) {
            (values).put("to_CnsldtnUnit", toCnsldtnUnit);
        }
        return values;
    }

    /**
     * Fetches the <b>ConsolidationUnit</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ConsolidationUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit fetchCnsldtnUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnUnit", ConsolidationUnit.class);
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnUnit</b> of a queried <b>ConsolidationUnitByTimeVersion</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ConsolidationUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ConsolidationUnit getCnsldtnUnitOrFetch()
    {
        if( toCnsldtnUnit == null ) {
            toCnsldtnUnit = fetchCnsldtnUnit();
        }
        return toCnsldtnUnit;
    }

    /**
     * Retrieval of associated <b>ConsolidationUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnUnit</b>.
     * <p>
     * If the navigation property for an entity <b>ConsolidationUnitByTimeVersion</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnUnit</b> is already loaded, the result will
     *         contain the <b>ConsolidationUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConsolidationUnit> getCnsldtnUnitIfPresent()
    {
        return Option.of(toCnsldtnUnit);
    }

    /**
     * Overwrites the associated <b>ConsolidationUnit</b> entity for the loaded navigation property
     * <b>to_CnsldtnUnit</b>.
     *
     * @param value
     *            New <b>ConsolidationUnit</b> entity.
     */
    public void setCnsldtnUnit( final ConsolidationUnit value )
    {
        toCnsldtnUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of ConsolidationUnitByTimeVersion instances.
     *
     */
    public final static class ConsolidationUnitByTimeVersionBuilder
    {

        private ConsolidationUnit toCnsldtnUnit;

        private ConsolidationUnitByTimeVersion.ConsolidationUnitByTimeVersionBuilder toCnsldtnUnit(
            final ConsolidationUnit value )
        {
            toCnsldtnUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnUnit</b> for <b>ConsolidationUnitByTimeVersion</b> to single
         * <b>ConsolidationUnit</b>.
         *
         * @param value
         *            The ConsolidationUnit to build this ConsolidationUnitByTimeVersion with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConsolidationUnitByTimeVersion.ConsolidationUnitByTimeVersionBuilder cnsldtnUnit(
            final ConsolidationUnit value )
        {
            return toCnsldtnUnit(value);
        }

    }

}
