/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable.ConsolidationUnitByTimeVersionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion
 * ConsolidationUnitByTimeVersion} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class ConsolidationUnitByTimeVersionByKeyFluentHelper
    extends
    FluentHelperByKey<ConsolidationUnitByTimeVersionByKeyFluentHelper, ConsolidationUnitByTimeVersion, ConsolidationUnitByTimeVersionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion
     * ConsolidationUnitByTimeVersion} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ConsolidationUnitByTimeVersion}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ConsolidationUnitByTimeVersion}
     * @param fromFiscalYearPeriod
     *            From Fiscal Year Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param consolidationVersion
     *            Consolidation Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param consolidationUnit
     *            Consolidation Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public ConsolidationUnitByTimeVersionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationUnit,
        final String consolidationVersion,
        final String fromFiscalYearPeriod )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationUnit", consolidationUnit);
        this.key.put("ConsolidationVersion", consolidationVersion);
        this.key.put("FromFiscalYearPeriod", fromFiscalYearPeriod);
    }

    @Override
    @Nonnull
    protected Class<ConsolidationUnitByTimeVersion> getEntityClass()
    {
        return ConsolidationUnitByTimeVersion.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
