/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ConsolidationUnitServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService ConsolidationUnitService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultConsolidationUnitServiceBatch
    extends
    BatchFluentHelperBasic<ConsolidationUnitServiceBatch, ConsolidationUnitServiceBatchChangeSet>
    implements
    ConsolidationUnitServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultConsolidationUnitServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultConsolidationUnitServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultConsolidationUnitServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultConsolidationUnitServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultConsolidationUnitServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ConsolidationUnitServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultConsolidationUnitServiceBatchChangeSet(this, service);
    }

}
