/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ConsolidationUnitServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService ConsolidationUnitService}.
 *
 */
public class DefaultConsolidationUnitServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ConsolidationUnitServiceBatch, ConsolidationUnitServiceBatchChangeSet>
    implements
    ConsolidationUnitServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService service;

    @SuppressWarnings( "deprecation" )
    DefaultConsolidationUnitServiceBatchChangeSet(
        @Nonnull final DefaultConsolidationUnitServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ConsolidationUnitService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultConsolidationUnitServiceBatchChangeSet getThis()
    {
        return this;
    }

}
