/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime
 * ConsolidationUnitByTime}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.field.ConsolidationUnitByTimeField
 * ConsolidationUnitByTimeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.link.ConsolidationUnitByTimeLink
 * ConsolidationUnitByTimeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime#FROM_FISCAL_YEAR_PERIOD
 * FROM_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime#TO_FISCAL_YEAR_PERIOD
 * TO_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime#CONSOLIDATION_UNIT_LOCAL_CURRENCY
 * CONSOLIDATION_UNIT_LOCAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime#COMPANY
 * COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime#TO_CNSLDTN_UNIT
 * TO_CNSLDTN_UNIT}</li>
 * </ul>
 *
 */
public interface ConsolidationUnitByTimeSelectable extends EntitySelectable<ConsolidationUnitByTime>
{

}
