/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion
 * ConsolidationUnitByTimeVersion}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.field.ConsolidationUnitByTimeVersionField
 * ConsolidationUnitByTimeVersionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.link.ConsolidationUnitByTimeVersionLink
 * ConsolidationUnitByTimeVersionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CONSOLIDATION_VERSION
 * CONSOLIDATION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#FROM_FISCAL_YEAR_PERIOD
 * FROM_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#TO_FISCAL_YEAR_PERIOD
 * TO_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CONSOLIDATION_UNIT_IS_PARTNER_ONLY
 * CONSOLIDATION_UNIT_IS_PARTNER_ONLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CNSLDTN_CRCY_TRANSLATION_METHOD
 * CNSLDTN_CRCY_TRANSLATION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#TAX_RATE
 * TAX_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CNSLDTN_DATA_TRANSFER_METHOD
 * CNSLDTN_DATA_TRANSFER_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#DOCUMENT_ENTRY_IS_IN_GROUP_CURRENCY
 * DOCUMENT_ENTRY_IS_IN_GROUP_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CNSLDTN_UNIT_LOCAL_CRCY_SOURCE
 * CNSLDTN_UNIT_LOCAL_CRCY_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CNSLDTN_UNIT_GROUP_CRCY_SOURCE
 * CNSLDTN_UNIT_GROUP_CRCY_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CNSLDTN_UPLOAD_METHOD
 * CNSLDTN_UPLOAD_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CNSLDTN_UNIT_DATA_COLLECTION
 * CNSLDTN_UNIT_DATA_COLLECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CONSOLIDATION_UNIT_PARTNER
 * CONSOLIDATION_UNIT_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CONSOLIDATION_UNIT_POSTING_RULE
 * CONSOLIDATION_UNIT_POSTING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#CONSOLIDATION_UNIT_VALIDATION
 * CONSOLIDATION_UNIT_VALIDATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion#TO_CNSLDTN_UNIT
 * TO_CNSLDTN_UNIT}</li>
 * </ul>
 *
 */
public interface ConsolidationUnitByTimeVersionSelectable extends EntitySelectable<ConsolidationUnitByTimeVersion>
{

}
