/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit ConsolidationUnit}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.field.ConsolidationUnitField
 * ConsolidationUnitField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.link.ConsolidationUnitLink
 * ConsolidationUnitLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit#CONSOLIDATION_UNIT
 * CONSOLIDATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit#CONSOLIDATION_UNIT_LINK
 * CONSOLIDATION_UNIT_LINK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit#CONSOLIDATION_UNIT_LINK_LABEL
 * CONSOLIDATION_UNIT_LINK_LABEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit#TO_CNSLDTN_UNIT_BY_TIME
 * TO_CNSLDTN_UNIT_BY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit#TO_CNSLDTN_UNIT_BY_TIME_VERSION
 * TO_CNSLDTN_UNIT_BY_TIME_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface ConsolidationUnitSelectable extends EntitySelectable<ConsolidationUnit>
{

}
