/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.field.SEPAMandateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.link.SEPAMandateLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.selectable.SEPAMandateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * SEPA Mandate
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SEPAMandateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SEPAMandate extends VdmEntity<SEPAMandate>
{

    /**
     * Selector for all available fields of SEPAMandate.
     *
     */
    public final static SEPAMandateSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateApplication</b>
     * </p>
     *
     * @return Application of SEPA Mandate
     */
    @SerializedName( "SEPAMandateApplication" )
    @JsonProperty( "SEPAMandateApplication" )
    @Nullable
    @ODataField( odataName = "SEPAMandateApplication" )
    private String sEPAMandateApplication;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateApplication</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_APPLICATION =
        new SEPAMandateField<String>("SEPAMandateApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @return Creditor Identification Number
     */
    @Key
    @SerializedName( "Creditor" )
    @JsonProperty( "Creditor" )
    @Nullable
    @ODataField( odataName = "Creditor" )
    private String creditor;
    /**
     * Use with available fluent helpers to apply the <b>Creditor</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> CREDITOR = new SEPAMandateField<String>("Creditor");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Unique Reference to Mandate for each Payee
     */
    @Key
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE = new SEPAMandateField<String>("SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAPaymentType</b>
     * </p>
     *
     * @return Payment Type
     */
    @SerializedName( "SEPAPaymentType" )
    @JsonProperty( "SEPAPaymentType" )
    @Nullable
    @ODataField( odataName = "SEPAPaymentType" )
    private String sEPAPaymentType;
    /**
     * Use with available fluent helpers to apply the <b>SEPAPaymentType</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_PAYMENT_TYPE = new SEPAMandateField<String>("SEPAPaymentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderType</b>
     * </p>
     *
     * @return SenderType
     */
    @SerializedName( "SenderType" )
    @JsonProperty( "SenderType" )
    @Nullable
    @ODataField( odataName = "SenderType" )
    private String senderType;
    /**
     * Use with available fluent helpers to apply the <b>SenderType</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_TYPE = new SEPAMandateField<String>("SenderType");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>Sender</b>
     * </p>
     *
     * @return ID of Sender
     */
    @SerializedName( "Sender" )
    @JsonProperty( "Sender" )
    @Nullable
    @ODataField( odataName = "Sender" )
    private String sender;
    /**
     * Use with available fluent helpers to apply the <b>Sender</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER = new SEPAMandateField<String>("Sender");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderLastName</b>
     * </p>
     *
     * @return Last name of Sender
     */
    @SerializedName( "SenderLastName" )
    @JsonProperty( "SenderLastName" )
    @Nullable
    @ODataField( odataName = "SenderLastName" )
    private String senderLastName;
    /**
     * Use with available fluent helpers to apply the <b>SenderLastName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_LAST_NAME = new SEPAMandateField<String>("SenderLastName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderFirstName</b>
     * </p>
     *
     * @return First name of Sender
     */
    @SerializedName( "SenderFirstName" )
    @JsonProperty( "SenderFirstName" )
    @Nullable
    @ODataField( odataName = "SenderFirstName" )
    private String senderFirstName;
    /**
     * Use with available fluent helpers to apply the <b>SenderFirstName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_FIRST_NAME = new SEPAMandateField<String>("SenderFirstName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SenderStreetName</b>
     * </p>
     *
     * @return Sender Street
     */
    @SerializedName( "SenderStreetName" )
    @JsonProperty( "SenderStreetName" )
    @Nullable
    @ODataField( odataName = "SenderStreetName" )
    private String senderStreetName;
    /**
     * Use with available fluent helpers to apply the <b>SenderStreetName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_STREET_NAME = new SEPAMandateField<String>("SenderStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderHouseNumber</b>
     * </p>
     *
     * @return Sender House Number
     */
    @SerializedName( "SenderHouseNumber" )
    @JsonProperty( "SenderHouseNumber" )
    @Nullable
    @ODataField( odataName = "SenderHouseNumber" )
    private String senderHouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>SenderHouseNumber</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_HOUSE_NUMBER =
        new SEPAMandateField<String>("SenderHouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderPostalCode</b>
     * </p>
     *
     * @return Sender Postal Code
     */
    @SerializedName( "SenderPostalCode" )
    @JsonProperty( "SenderPostalCode" )
    @Nullable
    @ODataField( odataName = "SenderPostalCode" )
    private String senderPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>SenderPostalCode</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_POSTAL_CODE = new SEPAMandateField<String>("SenderPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderCityName</b>
     * </p>
     *
     * @return Sender City
     */
    @SerializedName( "SenderCityName" )
    @JsonProperty( "SenderCityName" )
    @Nullable
    @ODataField( odataName = "SenderCityName" )
    private String senderCityName;
    /**
     * Use with available fluent helpers to apply the <b>SenderCityName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_CITY_NAME = new SEPAMandateField<String>("SenderCityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SenderCountry</b>
     * </p>
     *
     * @return Sender Country/Region
     */
    @SerializedName( "SenderCountry" )
    @JsonProperty( "SenderCountry" )
    @Nullable
    @ODataField( odataName = "SenderCountry" )
    private String senderCountry;
    /**
     * Use with available fluent helpers to apply the <b>SenderCountry</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_COUNTRY = new SEPAMandateField<String>("SenderCountry");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderLanguage</b>
     * </p>
     *
     * @return Sender Language
     */
    @SerializedName( "SenderLanguage" )
    @JsonProperty( "SenderLanguage" )
    @Nullable
    @ODataField( odataName = "SenderLanguage" )
    private String senderLanguage;
    /**
     * Use with available fluent helpers to apply the <b>SenderLanguage</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_LANGUAGE = new SEPAMandateField<String>("SenderLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 34
     * <p>
     * Original property name from the Odata EDM: <b>SenderIBAN</b>
     * </p>
     *
     * @return Sender IBAN
     */
    @SerializedName( "SenderIBAN" )
    @JsonProperty( "SenderIBAN" )
    @Nullable
    @ODataField( odataName = "SenderIBAN" )
    private String senderIBAN;
    /**
     * Use with available fluent helpers to apply the <b>SenderIBAN</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_IBAN = new SEPAMandateField<String>("SenderIBAN");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SenderBankSWIFTCode</b>
     * </p>
     *
     * @return SWIFT/BIC for International Payments
     */
    @SerializedName( "SenderBankSWIFTCode" )
    @JsonProperty( "SenderBankSWIFTCode" )
    @Nullable
    @ODataField( odataName = "SenderBankSWIFTCode" )
    private String senderBankSWIFTCode;
    /**
     * Use with available fluent helpers to apply the <b>SenderBankSWIFTCode</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_BANK_SWIFT_CODE =
        new SEPAMandateField<String>("SenderBankSWIFTCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayerName</b>
     * </p>
     *
     * @return Name of Alternative Debtor
     */
    @SerializedName( "AlternativePayerName" )
    @JsonProperty( "AlternativePayerName" )
    @Nullable
    @ODataField( odataName = "AlternativePayerName" )
    private String alternativePayerName;
    /**
     * Use with available fluent helpers to apply the <b>AlternativePayerName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> ALTERNATIVE_PAYER_NAME =
        new SEPAMandateField<String>("AlternativePayerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipientType</b>
     * </p>
     *
     * @return Recipient Type
     */
    @SerializedName( "RecipientType" )
    @JsonProperty( "RecipientType" )
    @Nullable
    @ODataField( odataName = "RecipientType" )
    private String recipientType;
    /**
     * Use with available fluent helpers to apply the <b>RecipientType</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_TYPE = new SEPAMandateField<String>("RecipientType");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>Recipient</b>
     * </p>
     *
     * @return Recipient ID
     */
    @SerializedName( "Recipient" )
    @JsonProperty( "Recipient" )
    @Nullable
    @ODataField( odataName = "Recipient" )
    private String recipient;
    /**
     * Use with available fluent helpers to apply the <b>Recipient</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT = new SEPAMandateField<String>("Recipient");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RecipientName1</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "RecipientName1" )
    @JsonProperty( "RecipientName1" )
    @Nullable
    @ODataField( odataName = "RecipientName1" )
    private String recipientName1;
    /**
     * Use with available fluent helpers to apply the <b>RecipientName1</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_NAME1 = new SEPAMandateField<String>("RecipientName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RecipientName2</b>
     * </p>
     *
     * @return Name 2 of organization
     */
    @SerializedName( "RecipientName2" )
    @JsonProperty( "RecipientName2" )
    @Nullable
    @ODataField( odataName = "RecipientName2" )
    private String recipientName2;
    /**
     * Use with available fluent helpers to apply the <b>RecipientName2</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_NAME2 = new SEPAMandateField<String>("RecipientName2");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RecipientStreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "RecipientStreetName" )
    @JsonProperty( "RecipientStreetName" )
    @Nullable
    @ODataField( odataName = "RecipientStreetName" )
    private String recipientStreetName;
    /**
     * Use with available fluent helpers to apply the <b>RecipientStreetName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_STREET_NAME =
        new SEPAMandateField<String>("RecipientStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipientHouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "RecipientHouseNumber" )
    @JsonProperty( "RecipientHouseNumber" )
    @Nullable
    @ODataField( odataName = "RecipientHouseNumber" )
    private String recipientHouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>RecipientHouseNumber</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_HOUSE_NUMBER =
        new SEPAMandateField<String>("RecipientHouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipientPostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "RecipientPostalCode" )
    @JsonProperty( "RecipientPostalCode" )
    @Nullable
    @ODataField( odataName = "RecipientPostalCode" )
    private String recipientPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>RecipientPostalCode</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_POSTAL_CODE =
        new SEPAMandateField<String>("RecipientPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RecipientCityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "RecipientCityName" )
    @JsonProperty( "RecipientCityName" )
    @Nullable
    @ODataField( odataName = "RecipientCityName" )
    private String recipientCityName;
    /**
     * Use with available fluent helpers to apply the <b>RecipientCityName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_CITY_NAME =
        new SEPAMandateField<String>("RecipientCityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipientCountry</b>
     * </p>
     *
     * @return Country/Region
     */
    @SerializedName( "RecipientCountry" )
    @JsonProperty( "RecipientCountry" )
    @Nullable
    @ODataField( odataName = "RecipientCountry" )
    private String recipientCountry;
    /**
     * Use with available fluent helpers to apply the <b>RecipientCountry</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> RECIPIENT_COUNTRY = new SEPAMandateField<String>("RecipientCountry");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateReferenceType</b>
     * </p>
     *
     * @return SEPA Mandate Reference Type
     */
    @SerializedName( "SEPAMandateReferenceType" )
    @JsonProperty( "SEPAMandateReferenceType" )
    @Nullable
    @ODataField( odataName = "SEPAMandateReferenceType" )
    private String sEPAMandateReferenceType;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateReferenceType</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_REFERENCE_TYPE =
        new SEPAMandateField<String>("SEPAMandateReferenceType");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateReference</b>
     * </p>
     *
     * @return SEPA Mandate Reference ID
     */
    @SerializedName( "SEPAMandateReference" )
    @JsonProperty( "SEPAMandateReference" )
    @Nullable
    @ODataField( odataName = "SEPAMandateReference" )
    private String sEPAMandateReference;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateReference</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_REFERENCE =
        new SEPAMandateField<String>("SEPAMandateReference");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateReferenceDesc</b>
     * </p>
     *
     * @return Explanation
     */
    @SerializedName( "SEPAMandateReferenceDesc" )
    @JsonProperty( "SEPAMandateReferenceDesc" )
    @Nullable
    @ODataField( odataName = "SEPAMandateReferenceDesc" )
    private String sEPAMandateReferenceDesc;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateReferenceDesc</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_REFERENCE_DESC =
        new SEPAMandateField<String>("SEPAMandateReferenceDesc");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid From
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<LocalDateTime> VALIDITY_START_DATE =
        new SEPAMandateField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<LocalDateTime> VALIDITY_END_DATE =
        new SEPAMandateField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SEPASignatureCityName</b>
     * </p>
     *
     * @return Location of signature
     */
    @SerializedName( "SEPASignatureCityName" )
    @JsonProperty( "SEPASignatureCityName" )
    @Nullable
    @ODataField( odataName = "SEPASignatureCityName" )
    private String sEPASignatureCityName;
    /**
     * Use with available fluent helpers to apply the <b>SEPASignatureCityName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_SIGNATURE_CITY_NAME =
        new SEPAMandateField<String>("SEPASignatureCityName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPASignatureDate</b>
     * </p>
     *
     * @return Date of Signature
     */
    @SerializedName( "SEPASignatureDate" )
    @JsonProperty( "SEPASignatureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SEPASignatureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime sEPASignatureDate;
    /**
     * Use with available fluent helpers to apply the <b>SEPASignatureDate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<LocalDateTime> SEPA_SIGNATURE_DATE =
        new SEPAMandateField<LocalDateTime>("SEPASignatureDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateStatus</b>
     * </p>
     *
     * @return Status of SEPA Mandate
     */
    @SerializedName( "SEPAMandateStatus" )
    @JsonProperty( "SEPAMandateStatus" )
    @Nullable
    @ODataField( odataName = "SEPAMandateStatus" )
    private String sEPAMandateStatus;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateStatus</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_STATUS =
        new SEPAMandateField<String>("SEPAMandateStatus");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayer</b>
     * </p>
     *
     * @return ID Alternative Debtor
     */
    @SerializedName( "AlternativePayer" )
    @JsonProperty( "AlternativePayer" )
    @Nullable
    @ODataField( odataName = "AlternativePayer" )
    private String alternativePayer;
    /**
     * Use with available fluent helpers to apply the <b>AlternativePayer</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> ALTERNATIVE_PAYER = new SEPAMandateField<String>("AlternativePayer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayeeName</b>
     * </p>
     *
     * @return Name Alternative Payee
     */
    @SerializedName( "AlternativePayeeName" )
    @JsonProperty( "AlternativePayeeName" )
    @Nullable
    @ODataField( odataName = "AlternativePayeeName" )
    private String alternativePayeeName;
    /**
     * Use with available fluent helpers to apply the <b>AlternativePayeeName</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> ALTERNATIVE_PAYEE_NAME =
        new SEPAMandateField<String>("AlternativePayeeName");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayee</b>
     * </p>
     *
     * @return ID Alternative Payee
     */
    @SerializedName( "AlternativePayee" )
    @JsonProperty( "AlternativePayee" )
    @Nullable
    @ODataField( odataName = "AlternativePayee" )
    private String alternativePayee;
    /**
     * Use with available fluent helpers to apply the <b>AlternativePayee</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> ALTERNATIVE_PAYEE = new SEPAMandateField<String>("AlternativePayee");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateIsB2BMandate</b>
     * </p>
     *
     * @return B2B Mandate
     */
    @SerializedName( "SEPAMandateIsB2BMandate" )
    @JsonProperty( "SEPAMandateIsB2BMandate" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SEPAMandateIsB2BMandate" )
    private Boolean sEPAMandateIsB2BMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateIsB2BMandate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<Boolean> SEPA_MANDATE_IS_B2_B_MANDATE =
        new SEPAMandateField<Boolean>("SEPAMandateIsB2BMandate");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SenderExternalID</b>
     * </p>
     *
     * @return External Reference of Sender ID
     */
    @SerializedName( "SenderExternalID" )
    @JsonProperty( "SenderExternalID" )
    @Nullable
    @ODataField( odataName = "SenderExternalID" )
    private String senderExternalID;
    /**
     * Use with available fluent helpers to apply the <b>SenderExternalID</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SENDER_EXTERNAL_ID = new SEPAMandateField<String>("SenderExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit1</b>
     * </p>
     *
     * @return Organization ID
     */
    @SerializedName( "SEPAMandateOrganizationalUnit1" )
    @JsonProperty( "SEPAMandateOrganizationalUnit1" )
    @Nullable
    @ODataField( odataName = "SEPAMandateOrganizationalUnit1" )
    private String sEPAMandateOrganizationalUnit1;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateOrganizationalUnit1</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_ORGANIZATIONAL_UNIT1 =
        new SEPAMandateField<String>("SEPAMandateOrganizationalUnit1");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit2</b>
     * </p>
     *
     * @return Organization ID
     */
    @SerializedName( "SEPAMandateOrganizationalUnit2" )
    @JsonProperty( "SEPAMandateOrganizationalUnit2" )
    @Nullable
    @ODataField( odataName = "SEPAMandateOrganizationalUnit2" )
    private String sEPAMandateOrganizationalUnit2;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateOrganizationalUnit2</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_ORGANIZATIONAL_UNIT2 =
        new SEPAMandateField<String>("SEPAMandateOrganizationalUnit2");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit3</b>
     * </p>
     *
     * @return Organization
     */
    @SerializedName( "SEPAMandateOrganizationalUnit3" )
    @JsonProperty( "SEPAMandateOrganizationalUnit3" )
    @Nullable
    @ODataField( odataName = "SEPAMandateOrganizationalUnit3" )
    private String sEPAMandateOrganizationalUnit3;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateOrganizationalUnit3</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_ORGANIZATIONAL_UNIT3 =
        new SEPAMandateField<String>("SEPAMandateOrganizationalUnit3");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit4</b>
     * </p>
     *
     * @return Organization
     */
    @SerializedName( "SEPAMandateOrganizationalUnit4" )
    @JsonProperty( "SEPAMandateOrganizationalUnit4" )
    @Nullable
    @ODataField( odataName = "SEPAMandateOrganizationalUnit4" )
    private String sEPAMandateOrganizationalUnit4;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateOrganizationalUnit4</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_ORGANIZATIONAL_UNIT4 =
        new SEPAMandateField<String>("SEPAMandateOrganizationalUnit4");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateFirstUseDate</b>
     * </p>
     *
     * @return First Use Date
     */
    @SerializedName( "SEPAMandateFirstUseDate" )
    @JsonProperty( "SEPAMandateFirstUseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SEPAMandateFirstUseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime sEPAMandateFirstUseDate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateFirstUseDate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<LocalDateTime> SEPA_MANDATE_FIRST_USE_DATE =
        new SEPAMandateField<LocalDateTime>("SEPAMandateFirstUseDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateFirstUseObjTypeCode</b>
     * </p>
     *
     * @return Type of First Usage
     */
    @SerializedName( "SEPAMandateFirstUseObjTypeCode" )
    @JsonProperty( "SEPAMandateFirstUseObjTypeCode" )
    @Nullable
    @ODataField( odataName = "SEPAMandateFirstUseObjTypeCode" )
    private String sEPAMandateFirstUseObjTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateFirstUseObjTypeCode</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_FIRST_USE_OBJ_TYPE_CODE =
        new SEPAMandateField<String>("SEPAMandateFirstUseObjTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateFirstUsePaymentDoc</b>
     * </p>
     *
     * @return ID of First Usage
     */
    @SerializedName( "SEPAMandateFirstUsePaymentDoc" )
    @JsonProperty( "SEPAMandateFirstUsePaymentDoc" )
    @Nullable
    @ODataField( odataName = "SEPAMandateFirstUsePaymentDoc" )
    private String sEPAMandateFirstUsePaymentDoc;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateFirstUsePaymentDoc</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_FIRST_USE_PAYMENT_DOC =
        new SEPAMandateField<String>("SEPAMandateFirstUsePaymentDoc");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateLastUseDate</b>
     * </p>
     *
     * @return Last Use Date
     */
    @SerializedName( "SEPAMandateLastUseDate" )
    @JsonProperty( "SEPAMandateLastUseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SEPAMandateLastUseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime sEPAMandateLastUseDate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateLastUseDate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<LocalDateTime> SEPA_MANDATE_LAST_USE_DATE =
        new SEPAMandateField<LocalDateTime>("SEPAMandateLastUseDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateLastUseObjTypeCode</b>
     * </p>
     *
     * @return Type of Last Usage
     */
    @SerializedName( "SEPAMandateLastUseObjTypeCode" )
    @JsonProperty( "SEPAMandateLastUseObjTypeCode" )
    @Nullable
    @ODataField( odataName = "SEPAMandateLastUseObjTypeCode" )
    private String sEPAMandateLastUseObjTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateLastUseObjTypeCode</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_LAST_USE_OBJ_TYPE_CODE =
        new SEPAMandateField<String>("SEPAMandateLastUseObjTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateLastUsePaymentDoc</b>
     * </p>
     *
     * @return ID of Last Usage
     */
    @SerializedName( "SEPAMandateLastUsePaymentDoc" )
    @JsonProperty( "SEPAMandateLastUsePaymentDoc" )
    @Nullable
    @ODataField( odataName = "SEPAMandateLastUsePaymentDoc" )
    private String sEPAMandateLastUsePaymentDoc;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateLastUsePaymentDoc</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_MANDATE_LAST_USE_PAYMENT_DOC =
        new SEPAMandateField<String>("SEPAMandateLastUsePaymentDoc");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SepaCreditorIdOrigin</b>
     * </p>
     *
     * @return Origin Creditor
     */
    @SerializedName( "SepaCreditorIdOrigin" )
    @JsonProperty( "SepaCreditorIdOrigin" )
    @Nullable
    @ODataField( odataName = "SepaCreditorIdOrigin" )
    private String sepaCreditorIdOrigin;
    /**
     * Use with available fluent helpers to apply the <b>SepaCreditorIdOrigin</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> SEPA_CREDITOR_ID_ORIGIN =
        new SEPAMandateField<String>("SepaCreditorIdOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OriginalSEPAMandate</b>
     * </p>
     *
     * @return Origin Mandate
     */
    @SerializedName( "OriginalSEPAMandate" )
    @JsonProperty( "OriginalSEPAMandate" )
    @Nullable
    @ODataField( odataName = "OriginalSEPAMandate" )
    private String originalSEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>OriginalSEPAMandate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> ORIGINAL_SEPA_MANDATE =
        new SEPAMandateField<String>("OriginalSEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Mandate Version
     */
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> VERSION = new SEPAMandateField<String>("Version");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SEPAMandateField<String> CREATED_BY_USER = new SEPAMandateField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SEPAMandateField<LocalDateTime> CREATION_DATE =
        new SEPAMandateField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Created at
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static SEPAMandateField<LocalTime> CREATION_TIME = new SEPAMandateField<LocalTime>("CreationTime");
    /**
     * Navigation property <b>SEPAMandateUsage</b> for <b>SEPAMandate</b> to multiple <b>SEPAMandateUsage</b>.
     *
     */
    @SerializedName( "SEPAMandateUsage" )
    @JsonProperty( "SEPAMandateUsage" )
    @ODataField( odataName = "SEPAMandateUsage" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SEPAMandateUsage> toSEPAMandateUsage;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateUsage</b> navigation property to query operations.
     *
     */
    public final static SEPAMandateLink<SEPAMandateUsage> TO_SEPA_MANDATE_USAGE =
        new SEPAMandateLink<SEPAMandateUsage>("SEPAMandateUsage");

    @Nonnull
    @Override
    public Class<SEPAMandate> getType()
    {
        return SEPAMandate.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateApplication</b>
     * </p>
     *
     * @param sEPAMandateApplication
     *            Application of SEPA Mandate
     */
    public void setSEPAMandateApplication( @Nullable final String sEPAMandateApplication )
    {
        rememberChangedField("SEPAMandateApplication", this.sEPAMandateApplication);
        this.sEPAMandateApplication = sEPAMandateApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @param creditor
     *            Creditor Identification Number
     */
    public void setCreditor( @Nullable final String creditor )
    {
        rememberChangedField("Creditor", this.creditor);
        this.creditor = creditor;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Unique Reference to Mandate for each Payee
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAPaymentType</b>
     * </p>
     *
     * @param sEPAPaymentType
     *            Payment Type
     */
    public void setSEPAPaymentType( @Nullable final String sEPAPaymentType )
    {
        rememberChangedField("SEPAPaymentType", this.sEPAPaymentType);
        this.sEPAPaymentType = sEPAPaymentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderType</b>
     * </p>
     *
     * @param senderType
     *            SenderType
     */
    public void setSenderType( @Nullable final String senderType )
    {
        rememberChangedField("SenderType", this.senderType);
        this.senderType = senderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>Sender</b>
     * </p>
     *
     * @param sender
     *            ID of Sender
     */
    public void setSender( @Nullable final String sender )
    {
        rememberChangedField("Sender", this.sender);
        this.sender = sender;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderLastName</b>
     * </p>
     *
     * @param senderLastName
     *            Last name of Sender
     */
    public void setSenderLastName( @Nullable final String senderLastName )
    {
        rememberChangedField("SenderLastName", this.senderLastName);
        this.senderLastName = senderLastName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderFirstName</b>
     * </p>
     *
     * @param senderFirstName
     *            First name of Sender
     */
    public void setSenderFirstName( @Nullable final String senderFirstName )
    {
        rememberChangedField("SenderFirstName", this.senderFirstName);
        this.senderFirstName = senderFirstName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SenderStreetName</b>
     * </p>
     *
     * @param senderStreetName
     *            Sender Street
     */
    public void setSenderStreetName( @Nullable final String senderStreetName )
    {
        rememberChangedField("SenderStreetName", this.senderStreetName);
        this.senderStreetName = senderStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderHouseNumber</b>
     * </p>
     *
     * @param senderHouseNumber
     *            Sender House Number
     */
    public void setSenderHouseNumber( @Nullable final String senderHouseNumber )
    {
        rememberChangedField("SenderHouseNumber", this.senderHouseNumber);
        this.senderHouseNumber = senderHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderPostalCode</b>
     * </p>
     *
     * @param senderPostalCode
     *            Sender Postal Code
     */
    public void setSenderPostalCode( @Nullable final String senderPostalCode )
    {
        rememberChangedField("SenderPostalCode", this.senderPostalCode);
        this.senderPostalCode = senderPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderCityName</b>
     * </p>
     *
     * @param senderCityName
     *            Sender City
     */
    public void setSenderCityName( @Nullable final String senderCityName )
    {
        rememberChangedField("SenderCityName", this.senderCityName);
        this.senderCityName = senderCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SenderCountry</b>
     * </p>
     *
     * @param senderCountry
     *            Sender Country/Region
     */
    public void setSenderCountry( @Nullable final String senderCountry )
    {
        rememberChangedField("SenderCountry", this.senderCountry);
        this.senderCountry = senderCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderLanguage</b>
     * </p>
     *
     * @param senderLanguage
     *            Sender Language
     */
    public void setSenderLanguage( @Nullable final String senderLanguage )
    {
        rememberChangedField("SenderLanguage", this.senderLanguage);
        this.senderLanguage = senderLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 34
     * <p>
     * Original property name from the Odata EDM: <b>SenderIBAN</b>
     * </p>
     *
     * @param senderIBAN
     *            Sender IBAN
     */
    public void setSenderIBAN( @Nullable final String senderIBAN )
    {
        rememberChangedField("SenderIBAN", this.senderIBAN);
        this.senderIBAN = senderIBAN;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SenderBankSWIFTCode</b>
     * </p>
     *
     * @param senderBankSWIFTCode
     *            SWIFT/BIC for International Payments
     */
    public void setSenderBankSWIFTCode( @Nullable final String senderBankSWIFTCode )
    {
        rememberChangedField("SenderBankSWIFTCode", this.senderBankSWIFTCode);
        this.senderBankSWIFTCode = senderBankSWIFTCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayerName</b>
     * </p>
     *
     * @param alternativePayerName
     *            Name of Alternative Debtor
     */
    public void setAlternativePayerName( @Nullable final String alternativePayerName )
    {
        rememberChangedField("AlternativePayerName", this.alternativePayerName);
        this.alternativePayerName = alternativePayerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipientType</b>
     * </p>
     *
     * @param recipientType
     *            Recipient Type
     */
    public void setRecipientType( @Nullable final String recipientType )
    {
        rememberChangedField("RecipientType", this.recipientType);
        this.recipientType = recipientType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>Recipient</b>
     * </p>
     *
     * @param recipient
     *            Recipient ID
     */
    public void setRecipient( @Nullable final String recipient )
    {
        rememberChangedField("Recipient", this.recipient);
        this.recipient = recipient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RecipientName1</b>
     * </p>
     *
     * @param recipientName1
     *            Name 1 of organization
     */
    public void setRecipientName1( @Nullable final String recipientName1 )
    {
        rememberChangedField("RecipientName1", this.recipientName1);
        this.recipientName1 = recipientName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RecipientName2</b>
     * </p>
     *
     * @param recipientName2
     *            Name 2 of organization
     */
    public void setRecipientName2( @Nullable final String recipientName2 )
    {
        rememberChangedField("RecipientName2", this.recipientName2);
        this.recipientName2 = recipientName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RecipientStreetName</b>
     * </p>
     *
     * @param recipientStreetName
     *            Street
     */
    public void setRecipientStreetName( @Nullable final String recipientStreetName )
    {
        rememberChangedField("RecipientStreetName", this.recipientStreetName);
        this.recipientStreetName = recipientStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipientHouseNumber</b>
     * </p>
     *
     * @param recipientHouseNumber
     *            House Number
     */
    public void setRecipientHouseNumber( @Nullable final String recipientHouseNumber )
    {
        rememberChangedField("RecipientHouseNumber", this.recipientHouseNumber);
        this.recipientHouseNumber = recipientHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipientPostalCode</b>
     * </p>
     *
     * @param recipientPostalCode
     *            Postal Code
     */
    public void setRecipientPostalCode( @Nullable final String recipientPostalCode )
    {
        rememberChangedField("RecipientPostalCode", this.recipientPostalCode);
        this.recipientPostalCode = recipientPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RecipientCityName</b>
     * </p>
     *
     * @param recipientCityName
     *            City
     */
    public void setRecipientCityName( @Nullable final String recipientCityName )
    {
        rememberChangedField("RecipientCityName", this.recipientCityName);
        this.recipientCityName = recipientCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipientCountry</b>
     * </p>
     *
     * @param recipientCountry
     *            Country/Region
     */
    public void setRecipientCountry( @Nullable final String recipientCountry )
    {
        rememberChangedField("RecipientCountry", this.recipientCountry);
        this.recipientCountry = recipientCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateReferenceType</b>
     * </p>
     *
     * @param sEPAMandateReferenceType
     *            SEPA Mandate Reference Type
     */
    public void setSEPAMandateReferenceType( @Nullable final String sEPAMandateReferenceType )
    {
        rememberChangedField("SEPAMandateReferenceType", this.sEPAMandateReferenceType);
        this.sEPAMandateReferenceType = sEPAMandateReferenceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateReference</b>
     * </p>
     *
     * @param sEPAMandateReference
     *            SEPA Mandate Reference ID
     */
    public void setSEPAMandateReference( @Nullable final String sEPAMandateReference )
    {
        rememberChangedField("SEPAMandateReference", this.sEPAMandateReference);
        this.sEPAMandateReference = sEPAMandateReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateReferenceDesc</b>
     * </p>
     *
     * @param sEPAMandateReferenceDesc
     *            Explanation
     */
    public void setSEPAMandateReferenceDesc( @Nullable final String sEPAMandateReferenceDesc )
    {
        rememberChangedField("SEPAMandateReferenceDesc", this.sEPAMandateReferenceDesc);
        this.sEPAMandateReferenceDesc = sEPAMandateReferenceDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid From
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SEPASignatureCityName</b>
     * </p>
     *
     * @param sEPASignatureCityName
     *            Location of signature
     */
    public void setSEPASignatureCityName( @Nullable final String sEPASignatureCityName )
    {
        rememberChangedField("SEPASignatureCityName", this.sEPASignatureCityName);
        this.sEPASignatureCityName = sEPASignatureCityName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPASignatureDate</b>
     * </p>
     *
     * @param sEPASignatureDate
     *            Date of Signature
     */
    public void setSEPASignatureDate( @Nullable final LocalDateTime sEPASignatureDate )
    {
        rememberChangedField("SEPASignatureDate", this.sEPASignatureDate);
        this.sEPASignatureDate = sEPASignatureDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateStatus</b>
     * </p>
     *
     * @param sEPAMandateStatus
     *            Status of SEPA Mandate
     */
    public void setSEPAMandateStatus( @Nullable final String sEPAMandateStatus )
    {
        rememberChangedField("SEPAMandateStatus", this.sEPAMandateStatus);
        this.sEPAMandateStatus = sEPAMandateStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayer</b>
     * </p>
     *
     * @param alternativePayer
     *            ID Alternative Debtor
     */
    public void setAlternativePayer( @Nullable final String alternativePayer )
    {
        rememberChangedField("AlternativePayer", this.alternativePayer);
        this.alternativePayer = alternativePayer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayeeName</b>
     * </p>
     *
     * @param alternativePayeeName
     *            Name Alternative Payee
     */
    public void setAlternativePayeeName( @Nullable final String alternativePayeeName )
    {
        rememberChangedField("AlternativePayeeName", this.alternativePayeeName);
        this.alternativePayeeName = alternativePayeeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>AlternativePayee</b>
     * </p>
     *
     * @param alternativePayee
     *            ID Alternative Payee
     */
    public void setAlternativePayee( @Nullable final String alternativePayee )
    {
        rememberChangedField("AlternativePayee", this.alternativePayee);
        this.alternativePayee = alternativePayee;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateIsB2BMandate</b>
     * </p>
     *
     * @param sEPAMandateIsB2BMandate
     *            B2B Mandate
     */
    public void setSEPAMandateIsB2BMandate( @Nullable final Boolean sEPAMandateIsB2BMandate )
    {
        rememberChangedField("SEPAMandateIsB2BMandate", this.sEPAMandateIsB2BMandate);
        this.sEPAMandateIsB2BMandate = sEPAMandateIsB2BMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SenderExternalID</b>
     * </p>
     *
     * @param senderExternalID
     *            External Reference of Sender ID
     */
    public void setSenderExternalID( @Nullable final String senderExternalID )
    {
        rememberChangedField("SenderExternalID", this.senderExternalID);
        this.senderExternalID = senderExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit1</b>
     * </p>
     *
     * @param sEPAMandateOrganizationalUnit1
     *            Organization ID
     */
    public void setSEPAMandateOrganizationalUnit1( @Nullable final String sEPAMandateOrganizationalUnit1 )
    {
        rememberChangedField("SEPAMandateOrganizationalUnit1", this.sEPAMandateOrganizationalUnit1);
        this.sEPAMandateOrganizationalUnit1 = sEPAMandateOrganizationalUnit1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit2</b>
     * </p>
     *
     * @param sEPAMandateOrganizationalUnit2
     *            Organization ID
     */
    public void setSEPAMandateOrganizationalUnit2( @Nullable final String sEPAMandateOrganizationalUnit2 )
    {
        rememberChangedField("SEPAMandateOrganizationalUnit2", this.sEPAMandateOrganizationalUnit2);
        this.sEPAMandateOrganizationalUnit2 = sEPAMandateOrganizationalUnit2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit3</b>
     * </p>
     *
     * @param sEPAMandateOrganizationalUnit3
     *            Organization
     */
    public void setSEPAMandateOrganizationalUnit3( @Nullable final String sEPAMandateOrganizationalUnit3 )
    {
        rememberChangedField("SEPAMandateOrganizationalUnit3", this.sEPAMandateOrganizationalUnit3);
        this.sEPAMandateOrganizationalUnit3 = sEPAMandateOrganizationalUnit3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateOrganizationalUnit4</b>
     * </p>
     *
     * @param sEPAMandateOrganizationalUnit4
     *            Organization
     */
    public void setSEPAMandateOrganizationalUnit4( @Nullable final String sEPAMandateOrganizationalUnit4 )
    {
        rememberChangedField("SEPAMandateOrganizationalUnit4", this.sEPAMandateOrganizationalUnit4);
        this.sEPAMandateOrganizationalUnit4 = sEPAMandateOrganizationalUnit4;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateFirstUseDate</b>
     * </p>
     *
     * @param sEPAMandateFirstUseDate
     *            First Use Date
     */
    public void setSEPAMandateFirstUseDate( @Nullable final LocalDateTime sEPAMandateFirstUseDate )
    {
        rememberChangedField("SEPAMandateFirstUseDate", this.sEPAMandateFirstUseDate);
        this.sEPAMandateFirstUseDate = sEPAMandateFirstUseDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateFirstUseObjTypeCode</b>
     * </p>
     *
     * @param sEPAMandateFirstUseObjTypeCode
     *            Type of First Usage
     */
    public void setSEPAMandateFirstUseObjTypeCode( @Nullable final String sEPAMandateFirstUseObjTypeCode )
    {
        rememberChangedField("SEPAMandateFirstUseObjTypeCode", this.sEPAMandateFirstUseObjTypeCode);
        this.sEPAMandateFirstUseObjTypeCode = sEPAMandateFirstUseObjTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateFirstUsePaymentDoc</b>
     * </p>
     *
     * @param sEPAMandateFirstUsePaymentDoc
     *            ID of First Usage
     */
    public void setSEPAMandateFirstUsePaymentDoc( @Nullable final String sEPAMandateFirstUsePaymentDoc )
    {
        rememberChangedField("SEPAMandateFirstUsePaymentDoc", this.sEPAMandateFirstUsePaymentDoc);
        this.sEPAMandateFirstUsePaymentDoc = sEPAMandateFirstUsePaymentDoc;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateLastUseDate</b>
     * </p>
     *
     * @param sEPAMandateLastUseDate
     *            Last Use Date
     */
    public void setSEPAMandateLastUseDate( @Nullable final LocalDateTime sEPAMandateLastUseDate )
    {
        rememberChangedField("SEPAMandateLastUseDate", this.sEPAMandateLastUseDate);
        this.sEPAMandateLastUseDate = sEPAMandateLastUseDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateLastUseObjTypeCode</b>
     * </p>
     *
     * @param sEPAMandateLastUseObjTypeCode
     *            Type of Last Usage
     */
    public void setSEPAMandateLastUseObjTypeCode( @Nullable final String sEPAMandateLastUseObjTypeCode )
    {
        rememberChangedField("SEPAMandateLastUseObjTypeCode", this.sEPAMandateLastUseObjTypeCode);
        this.sEPAMandateLastUseObjTypeCode = sEPAMandateLastUseObjTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateLastUsePaymentDoc</b>
     * </p>
     *
     * @param sEPAMandateLastUsePaymentDoc
     *            ID of Last Usage
     */
    public void setSEPAMandateLastUsePaymentDoc( @Nullable final String sEPAMandateLastUsePaymentDoc )
    {
        rememberChangedField("SEPAMandateLastUsePaymentDoc", this.sEPAMandateLastUsePaymentDoc);
        this.sEPAMandateLastUsePaymentDoc = sEPAMandateLastUsePaymentDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SepaCreditorIdOrigin</b>
     * </p>
     *
     * @param sepaCreditorIdOrigin
     *            Origin Creditor
     */
    public void setSepaCreditorIdOrigin( @Nullable final String sepaCreditorIdOrigin )
    {
        rememberChangedField("SepaCreditorIdOrigin", this.sepaCreditorIdOrigin);
        this.sepaCreditorIdOrigin = sepaCreditorIdOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OriginalSEPAMandate</b>
     * </p>
     *
     * @param originalSEPAMandate
     *            Origin Mandate
     */
    public void setOriginalSEPAMandate( @Nullable final String originalSEPAMandate )
    {
        rememberChangedField("OriginalSEPAMandate", this.originalSEPAMandate);
        this.originalSEPAMandate = originalSEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Mandate Version
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Created at
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SEPAMandateSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Creditor", getCreditor());
        result.put("SEPAMandate", getSEPAMandate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SEPAMandateApplication", getSEPAMandateApplication());
        values.put("Creditor", getCreditor());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("SEPAPaymentType", getSEPAPaymentType());
        values.put("SenderType", getSenderType());
        values.put("Sender", getSender());
        values.put("SenderLastName", getSenderLastName());
        values.put("SenderFirstName", getSenderFirstName());
        values.put("SenderStreetName", getSenderStreetName());
        values.put("SenderHouseNumber", getSenderHouseNumber());
        values.put("SenderPostalCode", getSenderPostalCode());
        values.put("SenderCityName", getSenderCityName());
        values.put("SenderCountry", getSenderCountry());
        values.put("SenderLanguage", getSenderLanguage());
        values.put("SenderIBAN", getSenderIBAN());
        values.put("SenderBankSWIFTCode", getSenderBankSWIFTCode());
        values.put("AlternativePayerName", getAlternativePayerName());
        values.put("RecipientType", getRecipientType());
        values.put("Recipient", getRecipient());
        values.put("RecipientName1", getRecipientName1());
        values.put("RecipientName2", getRecipientName2());
        values.put("RecipientStreetName", getRecipientStreetName());
        values.put("RecipientHouseNumber", getRecipientHouseNumber());
        values.put("RecipientPostalCode", getRecipientPostalCode());
        values.put("RecipientCityName", getRecipientCityName());
        values.put("RecipientCountry", getRecipientCountry());
        values.put("SEPAMandateReferenceType", getSEPAMandateReferenceType());
        values.put("SEPAMandateReference", getSEPAMandateReference());
        values.put("SEPAMandateReferenceDesc", getSEPAMandateReferenceDesc());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("SEPASignatureCityName", getSEPASignatureCityName());
        values.put("SEPASignatureDate", getSEPASignatureDate());
        values.put("SEPAMandateStatus", getSEPAMandateStatus());
        values.put("AlternativePayer", getAlternativePayer());
        values.put("AlternativePayeeName", getAlternativePayeeName());
        values.put("AlternativePayee", getAlternativePayee());
        values.put("SEPAMandateIsB2BMandate", getSEPAMandateIsB2BMandate());
        values.put("SenderExternalID", getSenderExternalID());
        values.put("SEPAMandateOrganizationalUnit1", getSEPAMandateOrganizationalUnit1());
        values.put("SEPAMandateOrganizationalUnit2", getSEPAMandateOrganizationalUnit2());
        values.put("SEPAMandateOrganizationalUnit3", getSEPAMandateOrganizationalUnit3());
        values.put("SEPAMandateOrganizationalUnit4", getSEPAMandateOrganizationalUnit4());
        values.put("SEPAMandateFirstUseDate", getSEPAMandateFirstUseDate());
        values.put("SEPAMandateFirstUseObjTypeCode", getSEPAMandateFirstUseObjTypeCode());
        values.put("SEPAMandateFirstUsePaymentDoc", getSEPAMandateFirstUsePaymentDoc());
        values.put("SEPAMandateLastUseDate", getSEPAMandateLastUseDate());
        values.put("SEPAMandateLastUseObjTypeCode", getSEPAMandateLastUseObjTypeCode());
        values.put("SEPAMandateLastUsePaymentDoc", getSEPAMandateLastUsePaymentDoc());
        values.put("SepaCreditorIdOrigin", getSepaCreditorIdOrigin());
        values.put("OriginalSEPAMandate", getOriginalSEPAMandate());
        values.put("Version", getVersion());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SEPAMandateApplication") ) {
                final Object value = values.remove("SEPAMandateApplication");
                if( (value == null) || (!value.equals(getSEPAMandateApplication())) ) {
                    setSEPAMandateApplication(((String) value));
                }
            }
            if( values.containsKey("Creditor") ) {
                final Object value = values.remove("Creditor");
                if( (value == null) || (!value.equals(getCreditor())) ) {
                    setCreditor(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("SEPAPaymentType") ) {
                final Object value = values.remove("SEPAPaymentType");
                if( (value == null) || (!value.equals(getSEPAPaymentType())) ) {
                    setSEPAPaymentType(((String) value));
                }
            }
            if( values.containsKey("SenderType") ) {
                final Object value = values.remove("SenderType");
                if( (value == null) || (!value.equals(getSenderType())) ) {
                    setSenderType(((String) value));
                }
            }
            if( values.containsKey("Sender") ) {
                final Object value = values.remove("Sender");
                if( (value == null) || (!value.equals(getSender())) ) {
                    setSender(((String) value));
                }
            }
            if( values.containsKey("SenderLastName") ) {
                final Object value = values.remove("SenderLastName");
                if( (value == null) || (!value.equals(getSenderLastName())) ) {
                    setSenderLastName(((String) value));
                }
            }
            if( values.containsKey("SenderFirstName") ) {
                final Object value = values.remove("SenderFirstName");
                if( (value == null) || (!value.equals(getSenderFirstName())) ) {
                    setSenderFirstName(((String) value));
                }
            }
            if( values.containsKey("SenderStreetName") ) {
                final Object value = values.remove("SenderStreetName");
                if( (value == null) || (!value.equals(getSenderStreetName())) ) {
                    setSenderStreetName(((String) value));
                }
            }
            if( values.containsKey("SenderHouseNumber") ) {
                final Object value = values.remove("SenderHouseNumber");
                if( (value == null) || (!value.equals(getSenderHouseNumber())) ) {
                    setSenderHouseNumber(((String) value));
                }
            }
            if( values.containsKey("SenderPostalCode") ) {
                final Object value = values.remove("SenderPostalCode");
                if( (value == null) || (!value.equals(getSenderPostalCode())) ) {
                    setSenderPostalCode(((String) value));
                }
            }
            if( values.containsKey("SenderCityName") ) {
                final Object value = values.remove("SenderCityName");
                if( (value == null) || (!value.equals(getSenderCityName())) ) {
                    setSenderCityName(((String) value));
                }
            }
            if( values.containsKey("SenderCountry") ) {
                final Object value = values.remove("SenderCountry");
                if( (value == null) || (!value.equals(getSenderCountry())) ) {
                    setSenderCountry(((String) value));
                }
            }
            if( values.containsKey("SenderLanguage") ) {
                final Object value = values.remove("SenderLanguage");
                if( (value == null) || (!value.equals(getSenderLanguage())) ) {
                    setSenderLanguage(((String) value));
                }
            }
            if( values.containsKey("SenderIBAN") ) {
                final Object value = values.remove("SenderIBAN");
                if( (value == null) || (!value.equals(getSenderIBAN())) ) {
                    setSenderIBAN(((String) value));
                }
            }
            if( values.containsKey("SenderBankSWIFTCode") ) {
                final Object value = values.remove("SenderBankSWIFTCode");
                if( (value == null) || (!value.equals(getSenderBankSWIFTCode())) ) {
                    setSenderBankSWIFTCode(((String) value));
                }
            }
            if( values.containsKey("AlternativePayerName") ) {
                final Object value = values.remove("AlternativePayerName");
                if( (value == null) || (!value.equals(getAlternativePayerName())) ) {
                    setAlternativePayerName(((String) value));
                }
            }
            if( values.containsKey("RecipientType") ) {
                final Object value = values.remove("RecipientType");
                if( (value == null) || (!value.equals(getRecipientType())) ) {
                    setRecipientType(((String) value));
                }
            }
            if( values.containsKey("Recipient") ) {
                final Object value = values.remove("Recipient");
                if( (value == null) || (!value.equals(getRecipient())) ) {
                    setRecipient(((String) value));
                }
            }
            if( values.containsKey("RecipientName1") ) {
                final Object value = values.remove("RecipientName1");
                if( (value == null) || (!value.equals(getRecipientName1())) ) {
                    setRecipientName1(((String) value));
                }
            }
            if( values.containsKey("RecipientName2") ) {
                final Object value = values.remove("RecipientName2");
                if( (value == null) || (!value.equals(getRecipientName2())) ) {
                    setRecipientName2(((String) value));
                }
            }
            if( values.containsKey("RecipientStreetName") ) {
                final Object value = values.remove("RecipientStreetName");
                if( (value == null) || (!value.equals(getRecipientStreetName())) ) {
                    setRecipientStreetName(((String) value));
                }
            }
            if( values.containsKey("RecipientHouseNumber") ) {
                final Object value = values.remove("RecipientHouseNumber");
                if( (value == null) || (!value.equals(getRecipientHouseNumber())) ) {
                    setRecipientHouseNumber(((String) value));
                }
            }
            if( values.containsKey("RecipientPostalCode") ) {
                final Object value = values.remove("RecipientPostalCode");
                if( (value == null) || (!value.equals(getRecipientPostalCode())) ) {
                    setRecipientPostalCode(((String) value));
                }
            }
            if( values.containsKey("RecipientCityName") ) {
                final Object value = values.remove("RecipientCityName");
                if( (value == null) || (!value.equals(getRecipientCityName())) ) {
                    setRecipientCityName(((String) value));
                }
            }
            if( values.containsKey("RecipientCountry") ) {
                final Object value = values.remove("RecipientCountry");
                if( (value == null) || (!value.equals(getRecipientCountry())) ) {
                    setRecipientCountry(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateReferenceType") ) {
                final Object value = values.remove("SEPAMandateReferenceType");
                if( (value == null) || (!value.equals(getSEPAMandateReferenceType())) ) {
                    setSEPAMandateReferenceType(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateReference") ) {
                final Object value = values.remove("SEPAMandateReference");
                if( (value == null) || (!value.equals(getSEPAMandateReference())) ) {
                    setSEPAMandateReference(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateReferenceDesc") ) {
                final Object value = values.remove("SEPAMandateReferenceDesc");
                if( (value == null) || (!value.equals(getSEPAMandateReferenceDesc())) ) {
                    setSEPAMandateReferenceDesc(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SEPASignatureCityName") ) {
                final Object value = values.remove("SEPASignatureCityName");
                if( (value == null) || (!value.equals(getSEPASignatureCityName())) ) {
                    setSEPASignatureCityName(((String) value));
                }
            }
            if( values.containsKey("SEPASignatureDate") ) {
                final Object value = values.remove("SEPASignatureDate");
                if( (value == null) || (!value.equals(getSEPASignatureDate())) ) {
                    setSEPASignatureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SEPAMandateStatus") ) {
                final Object value = values.remove("SEPAMandateStatus");
                if( (value == null) || (!value.equals(getSEPAMandateStatus())) ) {
                    setSEPAMandateStatus(((String) value));
                }
            }
            if( values.containsKey("AlternativePayer") ) {
                final Object value = values.remove("AlternativePayer");
                if( (value == null) || (!value.equals(getAlternativePayer())) ) {
                    setAlternativePayer(((String) value));
                }
            }
            if( values.containsKey("AlternativePayeeName") ) {
                final Object value = values.remove("AlternativePayeeName");
                if( (value == null) || (!value.equals(getAlternativePayeeName())) ) {
                    setAlternativePayeeName(((String) value));
                }
            }
            if( values.containsKey("AlternativePayee") ) {
                final Object value = values.remove("AlternativePayee");
                if( (value == null) || (!value.equals(getAlternativePayee())) ) {
                    setAlternativePayee(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateIsB2BMandate") ) {
                final Object value = values.remove("SEPAMandateIsB2BMandate");
                if( (value == null) || (!value.equals(getSEPAMandateIsB2BMandate())) ) {
                    setSEPAMandateIsB2BMandate(((Boolean) value));
                }
            }
            if( values.containsKey("SenderExternalID") ) {
                final Object value = values.remove("SenderExternalID");
                if( (value == null) || (!value.equals(getSenderExternalID())) ) {
                    setSenderExternalID(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateOrganizationalUnit1") ) {
                final Object value = values.remove("SEPAMandateOrganizationalUnit1");
                if( (value == null) || (!value.equals(getSEPAMandateOrganizationalUnit1())) ) {
                    setSEPAMandateOrganizationalUnit1(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateOrganizationalUnit2") ) {
                final Object value = values.remove("SEPAMandateOrganizationalUnit2");
                if( (value == null) || (!value.equals(getSEPAMandateOrganizationalUnit2())) ) {
                    setSEPAMandateOrganizationalUnit2(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateOrganizationalUnit3") ) {
                final Object value = values.remove("SEPAMandateOrganizationalUnit3");
                if( (value == null) || (!value.equals(getSEPAMandateOrganizationalUnit3())) ) {
                    setSEPAMandateOrganizationalUnit3(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateOrganizationalUnit4") ) {
                final Object value = values.remove("SEPAMandateOrganizationalUnit4");
                if( (value == null) || (!value.equals(getSEPAMandateOrganizationalUnit4())) ) {
                    setSEPAMandateOrganizationalUnit4(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateFirstUseDate") ) {
                final Object value = values.remove("SEPAMandateFirstUseDate");
                if( (value == null) || (!value.equals(getSEPAMandateFirstUseDate())) ) {
                    setSEPAMandateFirstUseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SEPAMandateFirstUseObjTypeCode") ) {
                final Object value = values.remove("SEPAMandateFirstUseObjTypeCode");
                if( (value == null) || (!value.equals(getSEPAMandateFirstUseObjTypeCode())) ) {
                    setSEPAMandateFirstUseObjTypeCode(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateFirstUsePaymentDoc") ) {
                final Object value = values.remove("SEPAMandateFirstUsePaymentDoc");
                if( (value == null) || (!value.equals(getSEPAMandateFirstUsePaymentDoc())) ) {
                    setSEPAMandateFirstUsePaymentDoc(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateLastUseDate") ) {
                final Object value = values.remove("SEPAMandateLastUseDate");
                if( (value == null) || (!value.equals(getSEPAMandateLastUseDate())) ) {
                    setSEPAMandateLastUseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SEPAMandateLastUseObjTypeCode") ) {
                final Object value = values.remove("SEPAMandateLastUseObjTypeCode");
                if( (value == null) || (!value.equals(getSEPAMandateLastUseObjTypeCode())) ) {
                    setSEPAMandateLastUseObjTypeCode(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateLastUsePaymentDoc") ) {
                final Object value = values.remove("SEPAMandateLastUsePaymentDoc");
                if( (value == null) || (!value.equals(getSEPAMandateLastUsePaymentDoc())) ) {
                    setSEPAMandateLastUsePaymentDoc(((String) value));
                }
            }
            if( values.containsKey("SepaCreditorIdOrigin") ) {
                final Object value = values.remove("SepaCreditorIdOrigin");
                if( (value == null) || (!value.equals(getSepaCreditorIdOrigin())) ) {
                    setSepaCreditorIdOrigin(((String) value));
                }
            }
            if( values.containsKey("OriginalSEPAMandate") ) {
                final Object value = values.remove("OriginalSEPAMandate");
                if( (value == null) || (!value.equals(getOriginalSEPAMandate())) ) {
                    setOriginalSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("SEPAMandateUsage") ) {
                final Object value = (values).remove("SEPAMandateUsage");
                if( value instanceof Iterable ) {
                    if( toSEPAMandateUsage == null ) {
                        toSEPAMandateUsage = Lists.newArrayList();
                    } else {
                        toSEPAMandateUsage = Lists.newArrayList(toSEPAMandateUsage);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SEPAMandateUsage entity;
                        if( toSEPAMandateUsage.size() > i ) {
                            entity = toSEPAMandateUsage.get(i);
                        } else {
                            entity = new SEPAMandateUsage();
                            toSEPAMandateUsage.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SEPAMandateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SEPAMandateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SEPAMandateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SEPAMandateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSEPAMandateUsage != null ) {
            (values).put("SEPAMandateUsage", toSEPAMandateUsage);
        }
        return values;
    }

    /**
     * Fetches the <b>SEPAMandateUsage</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>SEPAMandateUsage</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SEPAMandateUsage</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SEPAMandateUsage> fetchSEPAMandateUsage()
    {
        return fetchFieldAsList("SEPAMandateUsage", SEPAMandateUsage.class);
    }

    /**
     * Retrieval of associated <b>SEPAMandateUsage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>SEPAMandateUsage</b>.
     * <p>
     * If the navigation property <b>SEPAMandateUsage</b> of a queried <b>SEPAMandate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SEPAMandateUsage</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SEPAMandateUsage> getSEPAMandateUsageOrFetch()
    {
        if( toSEPAMandateUsage == null ) {
            toSEPAMandateUsage = fetchSEPAMandateUsage();
        }
        return toSEPAMandateUsage;
    }

    /**
     * Retrieval of associated <b>SEPAMandateUsage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>SEPAMandateUsage</b>.
     * <p>
     * If the navigation property for an entity <b>SEPAMandate</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>SEPAMandateUsage</b> is already loaded, the result will
     *         contain the <b>SEPAMandateUsage</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SEPAMandateUsage>> getSEPAMandateUsageIfPresent()
    {
        return Option.of(toSEPAMandateUsage);
    }

    /**
     * Overwrites the list of associated <b>SEPAMandateUsage</b> entities for the loaded navigation property
     * <b>SEPAMandateUsage</b>.
     * <p>
     * If the navigation property <b>SEPAMandateUsage</b> of a queried <b>SEPAMandate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SEPAMandateUsage</b> entities.
     */
    public void setSEPAMandateUsage( @Nonnull final List<SEPAMandateUsage> value )
    {
        if( toSEPAMandateUsage == null ) {
            toSEPAMandateUsage = Lists.newArrayList();
        }
        toSEPAMandateUsage.clear();
        toSEPAMandateUsage.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SEPAMandateUsage</b> entities. This corresponds to the OData
     * navigation property <b>SEPAMandateUsage</b>.
     * <p>
     * If the navigation property <b>SEPAMandateUsage</b> of a queried <b>SEPAMandate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SEPAMandateUsage</b> entities.
     */
    public void addSEPAMandateUsage( SEPAMandateUsage... entity )
    {
        if( toSEPAMandateUsage == null ) {
            toSEPAMandateUsage = Lists.newArrayList();
        }
        toSEPAMandateUsage.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SEPAMandate instances.
     *
     */
    public final static class SEPAMandateBuilder
    {

        private List<SEPAMandateUsage> toSEPAMandateUsage = Lists.newArrayList();

        private SEPAMandate.SEPAMandateBuilder toSEPAMandateUsage( final List<SEPAMandateUsage> value )
        {
            toSEPAMandateUsage.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>SEPAMandateUsage</b> for <b>SEPAMandate</b> to multiple <b>SEPAMandateUsage</b>.
         *
         * @param value
         *            The SEPAMandateUsages to build this SEPAMandate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SEPAMandate.SEPAMandateBuilder sepaMandateUsage( SEPAMandateUsage... value )
        {
            return toSEPAMandateUsage(Lists.newArrayList(value));
        }

    }

}
