/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ContractAccountingSEPAMandateServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService
 * ContractAccountingSEPAMandateService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultContractAccountingSEPAMandateServiceBatch
    extends
    BatchFluentHelperBasic<ContractAccountingSEPAMandateServiceBatch, ContractAccountingSEPAMandateServiceBatchChangeSet>
    implements
    ContractAccountingSEPAMandateServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultContractAccountingSEPAMandateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultContractAccountingSEPAMandateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultContractAccountingSEPAMandateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultContractAccountingSEPAMandateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultContractAccountingSEPAMandateServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ContractAccountingSEPAMandateServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultContractAccountingSEPAMandateServiceBatchChangeSet(this, service);
    }

}
