/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage;

/**
 * Implementation of the {@link ContractAccountingSEPAMandateServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService
 * ContractAccountingSEPAMandateService}.
 *
 */
public class DefaultContractAccountingSEPAMandateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ContractAccountingSEPAMandateServiceBatch, ContractAccountingSEPAMandateServiceBatchChangeSet>
    implements
    ContractAccountingSEPAMandateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService service;

    @SuppressWarnings( "deprecation" )
    DefaultContractAccountingSEPAMandateServiceBatchChangeSet(
        @Nonnull final DefaultContractAccountingSEPAMandateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ContractAccountingSEPAMandateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultContractAccountingSEPAMandateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ContractAccountingSEPAMandateServiceBatchChangeSet createSEPAMandate(
        @Nonnull final SEPAMandate sEPAMandate )
    {
        return addRequestCreate(service::createSEPAMandate, sEPAMandate);
    }

    @Nonnull
    @Override
    public ContractAccountingSEPAMandateServiceBatchChangeSet updateSEPAMandate(
        @Nonnull final SEPAMandate sEPAMandate )
    {
        return addRequestUpdate(service::updateSEPAMandate, sEPAMandate);
    }

    @Nonnull
    @Override
    public ContractAccountingSEPAMandateServiceBatchChangeSet createSEPAMandateUsage(
        @Nonnull final SEPAMandateUsage sEPAMandateUsage )
    {
        return addRequestCreate(service::createSEPAMandateUsage, sEPAMandateUsage);
    }

}
