/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate SEPAMandate}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.field.SEPAMandateField
 * SEPAMandateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.link.SEPAMandateLink
 * SEPAMandateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_APPLICATION
 * SEPA_MANDATE_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#CREDITOR
 * CREDITOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE
 * SEPA_MANDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_PAYMENT_TYPE
 * SEPA_PAYMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_TYPE
 * SENDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER
 * SENDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_LAST_NAME
 * SENDER_LAST_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_FIRST_NAME
 * SENDER_FIRST_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_STREET_NAME
 * SENDER_STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_HOUSE_NUMBER
 * SENDER_HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_POSTAL_CODE
 * SENDER_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_CITY_NAME
 * SENDER_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_COUNTRY
 * SENDER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_LANGUAGE
 * SENDER_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_IBAN
 * SENDER_IBAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_BANK_SWIFT_CODE
 * SENDER_BANK_SWIFT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#ALTERNATIVE_PAYER_NAME
 * ALTERNATIVE_PAYER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_TYPE
 * RECIPIENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT
 * RECIPIENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_NAME1
 * RECIPIENT_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_NAME2
 * RECIPIENT_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_STREET_NAME
 * RECIPIENT_STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_HOUSE_NUMBER
 * RECIPIENT_HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_POSTAL_CODE
 * RECIPIENT_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_CITY_NAME
 * RECIPIENT_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#RECIPIENT_COUNTRY
 * RECIPIENT_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_REFERENCE_TYPE
 * SEPA_MANDATE_REFERENCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_REFERENCE
 * SEPA_MANDATE_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_REFERENCE_DESC
 * SEPA_MANDATE_REFERENCE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_SIGNATURE_CITY_NAME
 * SEPA_SIGNATURE_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_SIGNATURE_DATE
 * SEPA_SIGNATURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_STATUS
 * SEPA_MANDATE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#ALTERNATIVE_PAYER
 * ALTERNATIVE_PAYER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#ALTERNATIVE_PAYEE_NAME
 * ALTERNATIVE_PAYEE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#ALTERNATIVE_PAYEE
 * ALTERNATIVE_PAYEE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_IS_B2_B_MANDATE
 * SEPA_MANDATE_IS_B2_B_MANDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SENDER_EXTERNAL_ID
 * SENDER_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_ORGANIZATIONAL_UNIT1
 * SEPA_MANDATE_ORGANIZATIONAL_UNIT1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_ORGANIZATIONAL_UNIT2
 * SEPA_MANDATE_ORGANIZATIONAL_UNIT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_ORGANIZATIONAL_UNIT3
 * SEPA_MANDATE_ORGANIZATIONAL_UNIT3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_ORGANIZATIONAL_UNIT4
 * SEPA_MANDATE_ORGANIZATIONAL_UNIT4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_FIRST_USE_DATE
 * SEPA_MANDATE_FIRST_USE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_FIRST_USE_OBJ_TYPE_CODE
 * SEPA_MANDATE_FIRST_USE_OBJ_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_FIRST_USE_PAYMENT_DOC
 * SEPA_MANDATE_FIRST_USE_PAYMENT_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_LAST_USE_DATE
 * SEPA_MANDATE_LAST_USE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_LAST_USE_OBJ_TYPE_CODE
 * SEPA_MANDATE_LAST_USE_OBJ_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_MANDATE_LAST_USE_PAYMENT_DOC
 * SEPA_MANDATE_LAST_USE_PAYMENT_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#SEPA_CREDITOR_ID_ORIGIN
 * SEPA_CREDITOR_ID_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#ORIGINAL_SEPA_MANDATE
 * ORIGINAL_SEPA_MANDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#VERSION
 * VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate#TO_SEPA_MANDATE_USAGE
 * TO_SEPA_MANDATE_USAGE}</li>
 * </ul>
 *
 */
public interface SEPAMandateSelectable extends EntitySelectable<SEPAMandate>
{

}
