/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
 * SEPAMandateUsage}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.field.SEPAMandateUsageField
 * SEPAMandateUsageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.link.SEPAMandateUsageLink
 * SEPAMandateUsageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage#SEPA_MANDATE_APPLICATION
 * SEPA_MANDATE_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage#CREDITOR
 * CREDITOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage#SEPA_MANDATE
 * SEPA_MANDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage#SEPA_MANDATE_USE_DATE
 * SEPA_MANDATE_USE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage#SEPA_MANDATE_USE_OBJECT_TYPE
 * SEPA_MANDATE_USE_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage#SEPA_MANDATE_USE_PAYMENT_DOC
 * SEPA_MANDATE_USE_PAYMENT_DOC}</li>
 * </ul>
 *
 */
public interface SEPAMandateUsageSelectable extends EntitySelectable<SEPAMandateUsage>
{

}
