/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.field.ControllingAreaField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.selectable.ControllingAreaSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Controlling Area
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ControllingAreaType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ControllingArea extends VdmEntity<ControllingArea>
{

    /**
     * Selector for all available fields of ControllingArea.
     *
     */
    public final static ControllingAreaSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA =
        new ControllingAreaField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> FISCAL_YEAR_VARIANT =
        new ControllingAreaField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area Name
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA_NAME =
        new ControllingAreaField<String>("ControllingAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrency</b>
     * </p>
     *
     * @return Controlling Area Currency
     */
    @SerializedName( "ControllingAreaCurrency" )
    @JsonProperty( "ControllingAreaCurrency" )
    @Nullable
    @ODataField( odataName = "ControllingAreaCurrency" )
    private String controllingAreaCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaCurrency</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA_CURRENCY =
        new ControllingAreaField<String>("ControllingAreaCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CHART_OF_ACCOUNTS =
        new ControllingAreaField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterStandardHierarchy</b>
     * </p>
     *
     * @return Cost Center Standard Hierarchy
     */
    @SerializedName( "CostCenterStandardHierarchy" )
    @JsonProperty( "CostCenterStandardHierarchy" )
    @Nullable
    @ODataField( odataName = "CostCenterStandardHierarchy" )
    private String costCenterStandardHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterStandardHierarchy</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> COST_CENTER_STANDARD_HIERARCHY =
        new ControllingAreaField<String>("CostCenterStandardHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterStandardHierarchy</b>
     * </p>
     *
     * @return Profit Center Standard Hierarchy
     */
    @SerializedName( "ProfitCenterStandardHierarchy" )
    @JsonProperty( "ProfitCenterStandardHierarchy" )
    @Nullable
    @ODataField( odataName = "ProfitCenterStandardHierarchy" )
    private String profitCenterStandardHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterStandardHierarchy</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> PROFIT_CENTER_STANDARD_HIERARCHY =
        new ControllingAreaField<String>("ProfitCenterStandardHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> FINANCIAL_MANAGEMENT_AREA =
        new ControllingAreaField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrencyRole</b>
     * </p>
     *
     * @return Currency Type for Controlling Area
     */
    @SerializedName( "ControllingAreaCurrencyRole" )
    @JsonProperty( "ControllingAreaCurrencyRole" )
    @Nullable
    @ODataField( odataName = "ControllingAreaCurrencyRole" )
    private String controllingAreaCurrencyRole;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaCurrencyRole</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> CONTROLLING_AREA_CURRENCY_ROLE =
        new ControllingAreaField<String>("ControllingAreaCurrencyRole");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterAccountingCurrency</b>
     * </p>
     *
     * @return Local Currency for Profit Center Accounting
     */
    @SerializedName( "ProfitCenterAccountingCurrency" )
    @JsonProperty( "ProfitCenterAccountingCurrency" )
    @Nullable
    @ODataField( odataName = "ProfitCenterAccountingCurrency" )
    private String profitCenterAccountingCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterAccountingCurrency</b> field to query operations.
     *
     */
    public final static ControllingAreaField<String> PROFIT_CENTER_ACCOUNTING_CURRENCY =
        new ControllingAreaField<String>("ProfitCenterAccountingCurrency");

    @Nonnull
    @Override
    public Class<ControllingArea> getType()
    {
        return ControllingArea.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area Name
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrency</b>
     * </p>
     *
     * @param controllingAreaCurrency
     *            Controlling Area Currency
     */
    public void setControllingAreaCurrency( @Nullable final String controllingAreaCurrency )
    {
        rememberChangedField("ControllingAreaCurrency", this.controllingAreaCurrency);
        this.controllingAreaCurrency = controllingAreaCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterStandardHierarchy</b>
     * </p>
     *
     * @param costCenterStandardHierarchy
     *            Cost Center Standard Hierarchy
     */
    public void setCostCenterStandardHierarchy( @Nullable final String costCenterStandardHierarchy )
    {
        rememberChangedField("CostCenterStandardHierarchy", this.costCenterStandardHierarchy);
        this.costCenterStandardHierarchy = costCenterStandardHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterStandardHierarchy</b>
     * </p>
     *
     * @param profitCenterStandardHierarchy
     *            Profit Center Standard Hierarchy
     */
    public void setProfitCenterStandardHierarchy( @Nullable final String profitCenterStandardHierarchy )
    {
        rememberChangedField("ProfitCenterStandardHierarchy", this.profitCenterStandardHierarchy);
        this.profitCenterStandardHierarchy = profitCenterStandardHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrencyRole</b>
     * </p>
     *
     * @param controllingAreaCurrencyRole
     *            Currency Type for Controlling Area
     */
    public void setControllingAreaCurrencyRole( @Nullable final String controllingAreaCurrencyRole )
    {
        rememberChangedField("ControllingAreaCurrencyRole", this.controllingAreaCurrencyRole);
        this.controllingAreaCurrencyRole = controllingAreaCurrencyRole;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterAccountingCurrency</b>
     * </p>
     *
     * @param profitCenterAccountingCurrency
     *            Local Currency for Profit Center Accounting
     */
    public void setProfitCenterAccountingCurrency( @Nullable final String profitCenterAccountingCurrency )
    {
        rememberChangedField("ProfitCenterAccountingCurrency", this.profitCenterAccountingCurrency);
        this.profitCenterAccountingCurrency = profitCenterAccountingCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ControllingArea";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea", getControllingArea());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("ControllingAreaName", getControllingAreaName());
        values.put("ControllingAreaCurrency", getControllingAreaCurrency());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("CostCenterStandardHierarchy", getCostCenterStandardHierarchy());
        values.put("ProfitCenterStandardHierarchy", getProfitCenterStandardHierarchy());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("ControllingAreaCurrencyRole", getControllingAreaCurrencyRole());
        values.put("ProfitCenterAccountingCurrency", getProfitCenterAccountingCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaCurrency") ) {
                final Object value = values.remove("ControllingAreaCurrency");
                if( (value == null) || (!value.equals(getControllingAreaCurrency())) ) {
                    setControllingAreaCurrency(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("CostCenterStandardHierarchy") ) {
                final Object value = values.remove("CostCenterStandardHierarchy");
                if( (value == null) || (!value.equals(getCostCenterStandardHierarchy())) ) {
                    setCostCenterStandardHierarchy(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterStandardHierarchy") ) {
                final Object value = values.remove("ProfitCenterStandardHierarchy");
                if( (value == null) || (!value.equals(getProfitCenterStandardHierarchy())) ) {
                    setProfitCenterStandardHierarchy(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaCurrencyRole") ) {
                final Object value = values.remove("ControllingAreaCurrencyRole");
                if( (value == null) || (!value.equals(getControllingAreaCurrencyRole())) ) {
                    setControllingAreaCurrencyRole(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterAccountingCurrency") ) {
                final Object value = values.remove("ProfitCenterAccountingCurrency");
                if( (value == null) || (!value.equals(getProfitCenterAccountingCurrency())) ) {
                    setProfitCenterAccountingCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ControllingAreaField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ControllingAreaField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ControllingAreaField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ControllingAreaField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService.DEFAULT_SERVICE_PATH);
    }

}
