/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ControllingAreaServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService ControllingAreaService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultControllingAreaServiceBatch
    extends
    BatchFluentHelperBasic<ControllingAreaServiceBatch, ControllingAreaServiceBatchChangeSet>
    implements
    ControllingAreaServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultControllingAreaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultControllingAreaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultControllingAreaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultControllingAreaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultControllingAreaServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ControllingAreaServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultControllingAreaServiceBatchChangeSet(this, service);
    }

}
