/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ControllingAreaServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService ControllingAreaService}.
 *
 */
public class DefaultControllingAreaServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ControllingAreaServiceBatch, ControllingAreaServiceBatchChangeSet>
    implements
    ControllingAreaServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService service;

    @SuppressWarnings( "deprecation" )
    DefaultControllingAreaServiceBatchChangeSet(
        @Nonnull final DefaultControllingAreaServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ControllingAreaService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultControllingAreaServiceBatchChangeSet getThis()
    {
        return this;
    }

}
