/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea ControllingArea}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.field.ControllingAreaField
 * ControllingAreaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.link.ControllingAreaLink
 * ControllingAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#CONTROLLING_AREA_CURRENCY
 * CONTROLLING_AREA_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#COST_CENTER_STANDARD_HIERARCHY
 * COST_CENTER_STANDARD_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#PROFIT_CENTER_STANDARD_HIERARCHY
 * PROFIT_CENTER_STANDARD_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#CONTROLLING_AREA_CURRENCY_ROLE
 * CONTROLLING_AREA_CURRENCY_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea#PROFIT_CENTER_ACCOUNTING_CURRENCY
 * PROFIT_CENTER_ACCOUNTING_CURRENCY}</li>
 * </ul>
 *
 */
public interface ControllingAreaSelectable extends EntitySelectable<ControllingArea>
{

}
