/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CostCenterServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService CostCenterService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCostCenterServiceBatch
    extends
    BatchFluentHelperBasic<CostCenterServiceBatch, CostCenterServiceBatchChangeSet>
    implements
    CostCenterServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCostCenterServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostCenterServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCostCenterServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostCenterServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCostCenterServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostCenterServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCostCenterServiceBatchChangeSet(this, service);
    }

}
