/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CostCenterServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService CostCenterService}.
 *
 */
public class DefaultCostCenterServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CostCenterServiceBatch, CostCenterServiceBatchChangeSet>
    implements
    CostCenterServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService service;

    @SuppressWarnings( "deprecation" )
    DefaultCostCenterServiceBatchChangeSet(
        @Nonnull final DefaultCostCenterServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCostCenterServiceBatchChangeSet getThis()
    {
        return this;
    }

}
